/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Date;
import java.util.List;

public class CommerceInventoryWarehouseItemServiceImpl
extends CommerceInventoryWarehouseItemServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceInventoryWarehouseItemServiceImpl.class, (String)"_commerceInventoryWarehouseModelResourcePermission", CommerceInventoryWarehouse.class);

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseId, sku, quantity);
    }

    @Deprecated
    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String externalReferenceCode, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.addCommerceInventoryWarehouseItem(externalReferenceCode, userId, commerceInventoryWarehouseId, sku, quantity);
    }

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(String externalReferenceCode, long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(externalReferenceCode, userId, commerceInventoryWarehouseId, sku, quantity);
    }

    public void deleteCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        this.commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
    }

    public void deleteCommerceInventoryWarehouseItems(long companyId, String sku) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        this.commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItems(companyId, sku);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItemByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItemByExternalReferenceCode(companyId, externalReferenceCode);
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "VIEW");
        }
        return this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
    }

    @Deprecated
    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItemByReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.getCommerceInventoryWarehouseItemByReferenceCode(externalReferenceCode, companyId);
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItemByReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemByReferenceCode(externalReferenceCode, companyId);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId, int start, int end) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItems(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long companyId, String sku, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItems(companyId, sku, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyId(long companyId, int start, int end) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByCompanyId(companyId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByCompanyIdAndSku(companyId, sku, start, end);
    }

    public int getCommerceInventoryWarehouseItemsCount(long commerceInventoryWarehouseId) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCount(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, String sku) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCount(companyId, sku);
    }

    public int getCommerceInventoryWarehouseItemsCountByCompanyId(long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCountByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsCountByModifiedDate(companyId, startDate, endDate);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate, int start, int end) throws PrincipalException {
        PortletResourcePermission portletResourcePermission = _commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseItemLocalService.getCommerceInventoryWarehouseItemsByModifiedDate(companyId, startDate, endDate, start, end);
    }

    public CommerceInventoryWarehouseItem increaseCommerceInventoryWarehouseItemQuantity(long commerceInventoryWarehouseItemId, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.increaseCommerceInventoryWarehouseItemQuantity(this.getUserId(), commerceInventoryWarehouseItemId, quantity);
    }

    public void moveQuantitiesBetweenWarehouses(long fromCommerceInventoryWarehouseId, long toCommerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), fromCommerceInventoryWarehouseId, "UPDATE");
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), toCommerceInventoryWarehouseId, "UPDATE");
        this.commerceInventoryWarehouseItemLocalService.moveQuantitiesBetweenWarehouses(this.getUserId(), fromCommerceInventoryWarehouseId, toCommerceInventoryWarehouseId, sku, quantity);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId, int quantity, int reservedQuantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(this.getUserId(), commerceInventoryWarehouseItemId, quantity, reservedQuantity, mvccVersion);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long commerceInventoryWarehouseItemId, int quantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem != null) {
            _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseItem.getCommerceInventoryWarehouseId(), "UPDATE");
        }
        return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(this.getUserId(), commerceInventoryWarehouseItemId, quantity, mvccVersion);
    }

    @Deprecated
    public CommerceInventoryWarehouseItem upsertCommerceInventoryWarehouseItem(long companyId, long userId, long commerceInventoryWarehouseId, String externalReferenceCode, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.upsertCommerceInventoryWarehouseItem(externalReferenceCode, companyId, userId, commerceInventoryWarehouseId, sku, quantity);
    }

    public CommerceInventoryWarehouseItem upsertCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.upsertCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseId, sku, quantity);
    }

    public CommerceInventoryWarehouseItem upsertCommerceInventoryWarehouseItem(String externalReferenceCode, long companyId, long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        _commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseItemLocalService.upsertCommerceInventoryWarehouseItem(externalReferenceCode, companyId, userId, commerceInventoryWarehouseId, sku, quantity);
    }
}

