/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.persistence.impl;

import com.liferay.commerce.inventory.exception.NoSuchInventoryBookedQuantityException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantityTable;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityImpl;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityModelImpl;
import com.liferay.commerce.inventory.service.persistence.CommerceInventoryBookedQuantityPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceInventoryBookedQuantityPersistenceImpl
extends BasePersistenceImpl<CommerceInventoryBookedQuantity>
implements CommerceInventoryBookedQuantityPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceInventoryBookedQuantityImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindBySku;
    private FinderPath _finderPathWithoutPaginationFindBySku;
    private FinderPath _finderPathCountBySku;
    private static final String _FINDER_COLUMN_SKU_SKU_2 = "commerceInventoryBookedQuantity.sku = ?";
    private static final String _FINDER_COLUMN_SKU_SKU_3 = "(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')";
    private FinderPath _finderPathWithPaginationFindByLtExpirationDate;
    private FinderPath _finderPathWithPaginationCountByLtExpirationDate;
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1 = "commerceInventoryBookedQuantity.expirationDate IS NULL";
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2 = "commerceInventoryBookedQuantity.expirationDate < ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "commerceInventoryBookedQuantity.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SKU_2 = "commerceInventoryBookedQuantity.sku = ?";
    private static final String _FINDER_COLUMN_C_S_SKU_3 = "(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY = "SELECT commerceInventoryBookedQuantity FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity";
    private static final String _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE = "SELECT commerceInventoryBookedQuantity FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity WHERE ";
    private static final String _SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY = "SELECT COUNT(commerceInventoryBookedQuantity) FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity";
    private static final String _SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE = "SELECT COUNT(commerceInventoryBookedQuantity) FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceInventoryBookedQuantity.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceInventoryBookedQuantity exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceInventoryBookedQuantity exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryBookedQuantityPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"commerceInventoryBookedQuantityId"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceInventoryBookedQuantity> findBySku(String sku) {
        return this.findBySku(sku, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end) {
        return this.findBySku(sku, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findBySku(sku, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindBySku;
                finderArgs = new Object[]{sku};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindBySku;
            finderArgs = new Object[]{sku, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (sku.equals(commerceInventoryBookedQuantity.getSku())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindSku) {
                    queryPos.add(sku);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findBySku_First(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchBySku_First(sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchBySku_First(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findBySku(sku, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findBySku_Last(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchBySku_Last(sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchBySku_Last(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countBySku(sku);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findBySku(sku, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findBySku_PrevAndNext(long commerceInventoryBookedQuantityId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        sku = Objects.toString(sku, "");
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getBySku_PrevAndNext(session, commerceInventoryBookedQuantity, sku, orderByComparator, true), commerceInventoryBookedQuantity, this.getBySku_PrevAndNext(session, commerceInventoryBookedQuantity, sku, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getBySku_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        boolean bindSku = false;
        if (sku.isEmpty()) {
            sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
        } else {
            bindSku = true;
            sb.append("commerceInventoryBookedQuantity.sku = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindSku) {
            queryPos.add(sku);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeBySku(String sku) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findBySku(sku, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countBySku(String sku) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = this._finderPathCountBySku;
        Object[] finderArgs = new Object[]{sku};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindSku) {
                    queryPos.add(sku);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate) {
        return this.findByLtExpirationDate(expirationDate, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end) {
        return this.findByLtExpirationDate(expirationDate, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findByLtExpirationDate(expirationDate, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtExpirationDate;
        finderArgs = new Object[]{CommerceInventoryBookedQuantityPersistenceImpl._getTime(expirationDate), start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (expirationDate.getTime() > commerceInventoryBookedQuantity.getExpirationDate().getTime()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findByLtExpirationDate_First(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByLtExpirationDate_First(expirationDate, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByLtExpirationDate_First(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findByLtExpirationDate(expirationDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findByLtExpirationDate_Last(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByLtExpirationDate_Last(expirationDate, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByLtExpirationDate_Last(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countByLtExpirationDate(expirationDate);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findByLtExpirationDate(expirationDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findByLtExpirationDate_PrevAndNext(long commerceInventoryBookedQuantityId, Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getByLtExpirationDate_PrevAndNext(session, commerceInventoryBookedQuantity, expirationDate, orderByComparator, true), commerceInventoryBookedQuantity, this.getByLtExpirationDate_PrevAndNext(session, commerceInventoryBookedQuantity, expirationDate, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getByLtExpirationDate_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindExpirationDate) {
            queryPos.add(new Timestamp(expirationDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeByLtExpirationDate(Date expirationDate) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findByLtExpirationDate(expirationDate, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countByLtExpirationDate(Date expirationDate) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtExpirationDate;
        Object[] finderArgs = new Object[]{CommerceInventoryBookedQuantityPersistenceImpl._getTime(expirationDate)};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku) {
        return this.findByC_S(companyId, sku, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end) {
        return this.findByC_S(companyId, sku, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findByC_S(companyId, sku, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, sku};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, sku, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (companyId == commerceInventoryBookedQuantity.getCompanyId() && sku.equals(commerceInventoryBookedQuantity.getSku())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindSku) {
                    queryPos.add(sku);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findByC_S_First(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByC_S_First(companyId, sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByC_S_First(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findByC_S(companyId, sku, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findByC_S_Last(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByC_S_Last(companyId, sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByC_S_Last(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countByC_S(companyId, sku);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findByC_S(companyId, sku, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findByC_S_PrevAndNext(long commerceInventoryBookedQuantityId, long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        sku = Objects.toString(sku, "");
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getByC_S_PrevAndNext(session, commerceInventoryBookedQuantity, companyId, sku, orderByComparator, true), commerceInventoryBookedQuantity, this.getByC_S_PrevAndNext(session, commerceInventoryBookedQuantity, companyId, sku, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getByC_S_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        boolean bindSku = false;
        if (sku.isEmpty()) {
            sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
        } else {
            bindSku = true;
            sb.append("commerceInventoryBookedQuantity.sku = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindSku) {
            queryPos.add(sku);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, String sku) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findByC_S(companyId, sku, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countByC_S(long companyId, String sku) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, sku};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindSku) {
                    queryPos.add(sku);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceInventoryBookedQuantityPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("commerceInventoryBookedQuantityId", "CIBookedQuantityId");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceInventoryBookedQuantity.class);
        this.setModelImplClass(CommerceInventoryBookedQuantityImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceInventoryBookedQuantityTable.INSTANCE);
    }

    public void cacheResult(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        this.entityCache.putResult(CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey()), (Serializable)commerceInventoryBookedQuantity);
    }

    public void cacheResult(List<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            if (this.entityCache.getResult(CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceInventoryBookedQuantity);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceInventoryBookedQuantityImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        this.entityCache.removeResult(CommerceInventoryBookedQuantityImpl.class, (BaseModel)commerceInventoryBookedQuantity);
    }

    public void clearCache(List<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            this.entityCache.removeResult(CommerceInventoryBookedQuantityImpl.class, (BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceInventoryBookedQuantityImpl.class, primaryKey);
        }
    }

    public CommerceInventoryBookedQuantity create(long commerceInventoryBookedQuantityId) {
        CommerceInventoryBookedQuantityImpl commerceInventoryBookedQuantity = new CommerceInventoryBookedQuantityImpl();
        commerceInventoryBookedQuantity.setNew(true);
        commerceInventoryBookedQuantity.setPrimaryKey(commerceInventoryBookedQuantityId);
        commerceInventoryBookedQuantity.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity remove(long commerceInventoryBookedQuantityId) throws NoSuchInventoryBookedQuantityException {
        return this.remove(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public CommerceInventoryBookedQuantity remove(Serializable primaryKey) throws NoSuchInventoryBookedQuantityException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.get(CommerceInventoryBookedQuantityImpl.class, primaryKey);
            if (commerceInventoryBookedQuantity == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchInventoryBookedQuantityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity2 = (CommerceInventoryBookedQuantity)this.remove((BaseModel)commerceInventoryBookedQuantity);
            return commerceInventoryBookedQuantity2;
        }
        catch (NoSuchInventoryBookedQuantityException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity removeImpl(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceInventoryBookedQuantity)) {
                commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.get(CommerceInventoryBookedQuantityImpl.class, commerceInventoryBookedQuantity.getPrimaryKeyObj());
            }
            if (commerceInventoryBookedQuantity != null) {
                session.delete((Object)commerceInventoryBookedQuantity);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceInventoryBookedQuantity != null) {
            this.clearCache(commerceInventoryBookedQuantity);
        }
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity updateImpl(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        boolean isNew = commerceInventoryBookedQuantity.isNew();
        if (!(commerceInventoryBookedQuantity instanceof CommerceInventoryBookedQuantityModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceInventoryBookedQuantity.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceInventoryBookedQuantity);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceInventoryBookedQuantity proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceInventoryBookedQuantity implementation " + commerceInventoryBookedQuantity.getClass());
        }
        CommerceInventoryBookedQuantityModelImpl commerceInventoryBookedQuantityModelImpl = (CommerceInventoryBookedQuantityModelImpl)commerceInventoryBookedQuantity;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceInventoryBookedQuantity.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceInventoryBookedQuantity.setCreateDate(now);
            } else {
                commerceInventoryBookedQuantity.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceInventoryBookedQuantityModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceInventoryBookedQuantity.setModifiedDate(now);
            } else {
                commerceInventoryBookedQuantity.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceInventoryBookedQuantity);
            } else {
                commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.merge((Object)commerceInventoryBookedQuantity);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceInventoryBookedQuantityImpl.class, (BaseModel)commerceInventoryBookedQuantityModelImpl, false, true);
        if (isNew) {
            commerceInventoryBookedQuantity.setNew(false);
        }
        commerceInventoryBookedQuantity.resetOriginalValues();
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity findByPrimaryKey(Serializable primaryKey) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)this.fetchByPrimaryKey(primaryKey);
        if (commerceInventoryBookedQuantity == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchInventoryBookedQuantityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity findByPrimaryKey(long commerceInventoryBookedQuantityId) throws NoSuchInventoryBookedQuantityException {
        return this.findByPrimaryKey(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public CommerceInventoryBookedQuantity fetchByPrimaryKey(long commerceInventoryBookedQuantityId) {
        return (CommerceInventoryBookedQuantity)this.fetchByPrimaryKey(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public List<CommerceInventoryBookedQuantity> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY;
                sql = sql.concat(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findAll()) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "CIBookedQuantityId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceInventoryBookedQuantityModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceInventoryBookedQuantityPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceInventoryBookedQuantityModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceInventoryBookedQuantity.class.getName()));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindBySku = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySku", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"sku"}, true);
        this._finderPathWithoutPaginationFindBySku = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySku", new String[]{String.class.getName()}, new String[]{"sku"}, true);
        this._finderPathCountBySku = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySku", new String[]{String.class.getName()}, new String[]{"sku"}, false);
        this._finderPathWithPaginationFindByLtExpirationDate = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtExpirationDate", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"expirationDate"}, true);
        this._finderPathWithPaginationCountByLtExpirationDate = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtExpirationDate", new String[]{Date.class.getName()}, new String[]{"expirationDate"}, false);
        this._finderPathWithPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "sku"}, true);
        this._finderPathWithoutPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "sku"}, true);
        this._finderPathCountByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "sku"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceInventoryBookedQuantityImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceInventoryBookedQuantityModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private CommerceInventoryBookedQuantityModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CommerceInventoryBookedQuantityModelImpl commerceInventoryBookedQuantityModelImpl = (CommerceInventoryBookedQuantityModelImpl)baseModel;
            long columnBitmask = commerceInventoryBookedQuantityModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceInventoryBookedQuantityModelArgumentsResolver._getValue(commerceInventoryBookedQuantityModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceInventoryBookedQuantityModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceInventoryBookedQuantityModelArgumentsResolver._getValue(commerceInventoryBookedQuantityModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(CommerceInventoryBookedQuantityModelImpl commerceInventoryBookedQuantityModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceInventoryBookedQuantityModelImpl.getColumnOriginalValue(columnName) : commerceInventoryBookedQuantityModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

