/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryBookedQuantityException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.base.CommerceInventoryBookedQuantityLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CommerceInventoryBookedQuantityLocalServiceImpl
extends CommerceInventoryBookedQuantityLocalServiceBaseImpl {
    @ServiceReference(type=CommerceInventoryAuditTypeRegistry.class)
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;

    public CommerceInventoryBookedQuantity addCommerceBookedQuantity(long userId, String sku, int quantity, Date expirationDate, Map<String, String> context) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceInventoryBookedQuantityId = this.counterLocalService.increment();
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceInventoryBookedQuantityId);
        commerceInventoryBookedQuantity.setCompanyId(user.getCompanyId());
        commerceInventoryBookedQuantity.setUserId(user.getUserId());
        commerceInventoryBookedQuantity.setUserName(user.getFullName());
        commerceInventoryBookedQuantity.setSku(sku);
        commerceInventoryBookedQuantity.setQuantity(quantity);
        commerceInventoryBookedQuantity.setExpirationDate(expirationDate);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("booked-quantity");
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
    }

    public void checkCommerceInventoryBookedQuantities() {
        this.commerceInventoryBookedQuantityPersistence.removeByLtExpirationDate(new Date());
    }

    public CommerceInventoryBookedQuantity consumeCommerceBookedQuantity(long commerceBookedQuantityId, int quantity) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityPersistence.findByPrimaryKey(commerceBookedQuantityId);
        if (quantity < commerceInventoryBookedQuantity.getQuantity()) {
            int newQuantity = commerceInventoryBookedQuantity.getQuantity() - quantity;
            commerceInventoryBookedQuantity.setQuantity(newQuantity);
            return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceInventoryBookedQuantity);
        }
        return this.commerceInventoryBookedQuantityPersistence.remove(commerceBookedQuantityId);
    }

    public int getCommerceBookedQuantity(long companyId, String sku) {
        List commerceInventoryBookedQuantities = this.commerceInventoryBookedQuantityPersistence.findByC_S(companyId, sku);
        int resultQuantity = 0;
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            resultQuantity += commerceInventoryBookedQuantity.getQuantity();
        }
        return resultQuantity;
    }

    public List<CommerceInventoryBookedQuantity> getCommerceInventoryBookedQuantities(long companyId, String sku, int start, int end) {
        return this.commerceInventoryBookedQuantityPersistence.findByC_S(companyId, sku, start, end);
    }

    public int getCommerceInventoryBookedQuantitiesCount(long companyId, String sku) {
        return this.commerceInventoryBookedQuantityPersistence.countByC_S(companyId, sku);
    }

    public CommerceInventoryBookedQuantity resetCommerceBookedQuantity(long commerceBookedQuantityId, long userId, String sku, int quantity, Date expirationDate, Map<String, String> context) throws PortalException {
        CommerceInventoryBookedQuantity commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.fetchByPrimaryKey(commerceBookedQuantityId);
        if (commerceBookedQuantity == null) {
            User user = this.userLocalService.getUser(userId);
            commerceBookedQuantity = this.commerceInventoryBookedQuantityPersistence.create(commerceBookedQuantityId);
            commerceBookedQuantity.setCompanyId(user.getCompanyId());
            commerceBookedQuantity.setUserId(userId);
            commerceBookedQuantity.setUserName(user.getFullName());
            commerceBookedQuantity.setSku(sku);
            commerceBookedQuantity.setExpirationDate(expirationDate);
        }
        commerceBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("restore-quantity");
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return (CommerceInventoryBookedQuantity)this.commerceInventoryBookedQuantityPersistence.update((BaseModel)commerceBookedQuantity);
    }

    public CommerceInventoryBookedQuantity updateCommerceInventoryBookedQuantity(long userId, long commerceInventoryBookedQuantityId, int quantity, Map<String, String> context, long mvccVersion) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId);
        if (commerceInventoryBookedQuantity.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryBookedQuantity.setQuantity(quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-booked-quantity");
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryBookedQuantity.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return this.commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
    }
}

