/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.persistence.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryWarehouseItemImpl;
import com.liferay.commerce.inventory.service.persistence.CommerceInventoryWarehouseItemFinder;
import com.liferay.commerce.inventory.service.persistence.impl.CommerceInventoryWarehouseItemFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CommerceInventoryWarehouseItemFinderImpl
extends CommerceInventoryWarehouseItemFinderBaseImpl
implements CommerceInventoryWarehouseItemFinder {
    public static final String COUNT_ITEMS_BY_COMPANY_ID = CommerceInventoryWarehouseItemFinder.class.getName() + ".countItemsByCompanyId";
    public static final String COUNT_STOCK_QUANTITY_BY_C_S = CommerceInventoryWarehouseItemFinder.class.getName() + ".countStockQuantityByC_S";
    public static final String COUNT_STOCK_QUANTITY_BY_C_G_S = CommerceInventoryWarehouseItemFinder.class.getName() + ".countStockQuantityByC_G_S";
    public static final String COUNT_UPDATED_ITEMS_BY_C_M = CommerceInventoryWarehouseItemFinder.class.getName() + ".countUpdatedItemsByC_M";
    public static final String FIND_ITEMS_BY_COMPANY_ID = CommerceInventoryWarehouseItemFinder.class.getName() + ".findItemsByCompanyId";
    public static final String FIND_UPDATED_ITEMS_BY_C_M = CommerceInventoryWarehouseItemFinder.class.getName() + ".findUpdatedItemsByC_M";
    private static final String _COUNT_VALUE = "COUNT_VALUE";
    private static final String _SKU = "SKU";
    private static final String _SUM_AWAITING = "SUM_AWAITING";
    private static final String _SUM_BOOKED = "SUM_BOOKED";
    private static final String _SUM_STOCK = "SUM_STOCK";
    private static final String _SUM_VALUE = "SUM_VALUE";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countItemsByCompanyId(long companyId, String sku) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_ITEMS_BY_COMPANY_ID);
            String[] keywords = this._customSQL.keywords(sku, true);
            if (Validator.isNotNull((String)sku)) {
                sql = this._customSQL.replaceKeywords(sql, "LOWER(CIWarehouseItem.sku)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.replace((String)sql, (String)" AND (LOWER(CIWarehouseItem.sku) LIKE ? [$AND_OR_NULL_CHECK$])", (String)"");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(_COUNT_VALUE, Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            if (Validator.isNotNull((String)sku)) {
                qPos.add(keywords, 2);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countStockQuantityByC_S(long companyId, String sku) {
        Session session = null;
        try {
            Integer sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_STOCK_QUANTITY_BY_C_S);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(_SUM_VALUE, Type.INTEGER);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(sku);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (sum = (Integer)itr.next()) != null) {
                int n = sum;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countStockQuantityByC_G_S(long companyId, long channelGroupId, String sku) {
        Session session = null;
        try {
            Integer sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_STOCK_QUANTITY_BY_C_G_S);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(_SUM_VALUE, Type.INTEGER);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(channelGroupId);
            qPos.add(sku);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (sum = (Integer)itr.next()) != null) {
                int n = sum;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countUpdatedItemsByC_M(long companyId, Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_UPDATED_ITEMS_BY_C_M);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(startDate);
            qPos.add(endDate);
            q.addScalar(_COUNT_VALUE, Type.LONG);
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object[]> findItemsByCompanyId(long companyId, String sku, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String[] keywords = this._customSQL.keywords(sku, true);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_ITEMS_BY_COMPANY_ID);
            sql = StringUtil.replace((String)sql, (String[])new String[]{"[$COMPANY_ID$]"}, (String[])new String[]{String.valueOf(companyId)});
            if (Validator.isNotNull((String)sku)) {
                sql = this._customSQL.replaceKeywords(sql, "LOWER(CIWarehouseItem.sku)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.replace((String)sql, (String)" AND (LOWER(CIWarehouseItem.sku) LIKE ? [$AND_OR_NULL_CHECK$])", (String)"");
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(_SKU, Type.STRING);
            q.addScalar(_SUM_STOCK, Type.INTEGER);
            q.addScalar(_SUM_BOOKED, Type.INTEGER);
            q.addScalar(_SUM_AWAITING, Type.INTEGER);
            if (Validator.isNotNull((String)sku)) {
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(keywords, 2);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceInventoryWarehouseItem> findUpdatedItemsByC_M(long companyId, Date startDate, Date endDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_UPDATED_ITEMS_BY_C_M);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CIWarehouseItem", CommerceInventoryWarehouseItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(startDate);
            qPos.add(endDate);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

