/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CommerceInventoryReplenishmentItem;
import com.liferay.commerce.inventory.service.base.CommerceInventoryReplenishmentItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;

public class CommerceInventoryReplenishmentItemLocalServiceImpl
extends CommerceInventoryReplenishmentItemLocalServiceBaseImpl {
    public CommerceInventoryReplenishmentItem addCommerceInventoryReplenishmentItem(long userId, long commerceInventoryWarehouseId, String sku, Date availabilityDate, int quantity) throws PortalException {
        if (Validator.isNull((String)sku)) {
            throw new PortalException("SKU code is null");
        }
        User user = this.userLocalService.getUser(userId);
        long commerceInventoryReplenishmentItemId = this.counterLocalService.increment();
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemPersistence.create(commerceInventoryReplenishmentItemId);
        commerceInventoryReplenishmentItem.setCompanyId(user.getCompanyId());
        commerceInventoryReplenishmentItem.setUserId(userId);
        commerceInventoryReplenishmentItem.setUserName(user.getFullName());
        commerceInventoryReplenishmentItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryReplenishmentItem.setSku(sku);
        commerceInventoryReplenishmentItem.setAvailabilityDate(availabilityDate);
        commerceInventoryReplenishmentItem.setQuantity(quantity);
        return (CommerceInventoryReplenishmentItem)this.commerceInventoryReplenishmentItemPersistence.update((BaseModel)commerceInventoryReplenishmentItem);
    }

    public List<CommerceInventoryReplenishmentItem> getCommerceInventoryReplenishmentItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) {
        return this.commerceInventoryReplenishmentItemPersistence.findByC_S(companyId, sku, start, end);
    }

    public long getCommerceInventoryReplenishmentItemsCount(long commerceInventoryWarehouseId, String sku) {
        DynamicQuery dynamicQuery = this.commerceInventoryReplenishmentItemLocalService.dynamicQuery();
        Projection projection = ProjectionFactoryUtil.sum((String)"quantity");
        dynamicQuery.setProjection(projection);
        Property commerceInventoryWarehouseIdProperty = PropertyFactoryUtil.forName((String)"commerceInventoryWarehouseId");
        dynamicQuery.add(commerceInventoryWarehouseIdProperty.eq((Object)commerceInventoryWarehouseId));
        Property skuProperty = PropertyFactoryUtil.forName((String)"sku");
        dynamicQuery.add(skuProperty.eq((Object)sku));
        List results = this.commerceInventoryReplenishmentItemLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public int getCommerceInventoryReplenishmentItemsCountByCompanyIdAndSku(long companyId, String sku) {
        return this.commerceInventoryReplenishmentItemPersistence.countByC_S(companyId, sku);
    }

    public CommerceInventoryReplenishmentItem updateCommerceInventoryReplenishmentItem(long commerceInventoryReplenishmentItemId, Date availabilityDate, int quantity, long mvccVersion) throws PortalException {
        CommerceInventoryReplenishmentItem commerceInventoryReplenishmentItem = this.commerceInventoryReplenishmentItemPersistence.findByPrimaryKey(commerceInventoryReplenishmentItemId);
        if (commerceInventoryReplenishmentItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryReplenishmentItem.setAvailabilityDate(availabilityDate);
        commerceInventoryReplenishmentItem.setQuantity(quantity);
        return (CommerceInventoryReplenishmentItem)this.commerceInventoryReplenishmentItemPersistence.update((BaseModel)commerceInventoryReplenishmentItem);
    }
}

