/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.persistence.impl;

import com.liferay.commerce.inventory.exception.NoSuchInventoryBookedQuantityException;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityImpl;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryBookedQuantityModelImpl;
import com.liferay.commerce.inventory.service.persistence.CommerceInventoryBookedQuantityPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CommerceInventoryBookedQuantityPersistenceImpl
extends BasePersistenceImpl<CommerceInventoryBookedQuantity>
implements CommerceInventoryBookedQuantityPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceInventoryBookedQuantityImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindBySku;
    private FinderPath _finderPathWithoutPaginationFindBySku;
    private FinderPath _finderPathCountBySku;
    private static final String _FINDER_COLUMN_SKU_SKU_2 = "commerceInventoryBookedQuantity.sku = ?";
    private static final String _FINDER_COLUMN_SKU_SKU_3 = "(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')";
    private FinderPath _finderPathWithPaginationFindByLtExpirationDate;
    private FinderPath _finderPathWithPaginationCountByLtExpirationDate;
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1 = "commerceInventoryBookedQuantity.expirationDate IS NULL";
    private static final String _FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2 = "commerceInventoryBookedQuantity.expirationDate < ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMPANYID_2 = "commerceInventoryBookedQuantity.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SKU_2 = "commerceInventoryBookedQuantity.sku = ?";
    private static final String _FINDER_COLUMN_C_S_SKU_3 = "(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')";
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY = "SELECT commerceInventoryBookedQuantity FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity";
    private static final String _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE_PKS_IN = "SELECT commerceInventoryBookedQuantity FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity WHERE CIBookedQuantityId IN (";
    private static final String _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE = "SELECT commerceInventoryBookedQuantity FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity WHERE ";
    private static final String _SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY = "SELECT COUNT(commerceInventoryBookedQuantity) FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity";
    private static final String _SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE = "SELECT COUNT(commerceInventoryBookedQuantity) FROM CommerceInventoryBookedQuantity commerceInventoryBookedQuantity WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceInventoryBookedQuantity.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceInventoryBookedQuantity exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceInventoryBookedQuantity exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryBookedQuantityPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"commerceInventoryBookedQuantityId"});

    public List<CommerceInventoryBookedQuantity> findBySku(String sku) {
        return this.findBySku(sku, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end) {
        return this.findBySku(sku, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findBySku(sku, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findBySku(String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindBySku;
                finderArgs = new Object[]{sku};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindBySku;
            finderArgs = new Object[]{sku, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (sku.equals(commerceInventoryBookedQuantity.getSku())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindSku) {
                    queryPos.add(sku);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findBySku_First(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchBySku_First(sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchBySku_First(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findBySku(sku, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findBySku_Last(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchBySku_Last(sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchBySku_Last(String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countBySku(sku);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findBySku(sku, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findBySku_PrevAndNext(long commerceInventoryBookedQuantityId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        sku = Objects.toString(sku, "");
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getBySku_PrevAndNext(session, commerceInventoryBookedQuantity, sku, orderByComparator, true), commerceInventoryBookedQuantity, this.getBySku_PrevAndNext(session, commerceInventoryBookedQuantity, sku, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getBySku_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        boolean bindSku = false;
        if (sku.isEmpty()) {
            sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
        } else {
            bindSku = true;
            sb.append("commerceInventoryBookedQuantity.sku = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindSku) {
            queryPos.add(sku);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeBySku(String sku) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findBySku(sku, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countBySku(String sku) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = this._finderPathCountBySku;
        Object[] finderArgs = new Object[]{sku};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindSku) {
                    queryPos.add(sku);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate) {
        return this.findByLtExpirationDate(expirationDate, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end) {
        return this.findByLtExpirationDate(expirationDate, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findByLtExpirationDate(expirationDate, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findByLtExpirationDate(Date expirationDate, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByLtExpirationDate;
        finderArgs = new Object[]{CommerceInventoryBookedQuantityPersistenceImpl._getTime(expirationDate), start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (expirationDate.getTime() > commerceInventoryBookedQuantity.getExpirationDate().getTime()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findByLtExpirationDate_First(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByLtExpirationDate_First(expirationDate, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByLtExpirationDate_First(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findByLtExpirationDate(expirationDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findByLtExpirationDate_Last(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByLtExpirationDate_Last(expirationDate, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("expirationDate<");
        sb.append((Object)expirationDate);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByLtExpirationDate_Last(Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countByLtExpirationDate(expirationDate);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findByLtExpirationDate(expirationDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findByLtExpirationDate_PrevAndNext(long commerceInventoryBookedQuantityId, Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getByLtExpirationDate_PrevAndNext(session, commerceInventoryBookedQuantity, expirationDate, orderByComparator, true), commerceInventoryBookedQuantity, this.getByLtExpirationDate_PrevAndNext(session, commerceInventoryBookedQuantity, expirationDate, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getByLtExpirationDate_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, Date expirationDate, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
        } else {
            bindExpirationDate = true;
            sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindExpirationDate) {
            queryPos.add(new Timestamp(expirationDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeByLtExpirationDate(Date expirationDate) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findByLtExpirationDate(expirationDate, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countByLtExpirationDate(Date expirationDate) {
        FinderPath finderPath = this._finderPathWithPaginationCountByLtExpirationDate;
        Object[] finderArgs = new Object[]{CommerceInventoryBookedQuantityPersistenceImpl._getTime(expirationDate)};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_1);
            } else {
                bindExpirationDate = true;
                sb.append(_FINDER_COLUMN_LTEXPIRATIONDATE_EXPIRATIONDATE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExpirationDate) {
                    queryPos.add(new Timestamp(expirationDate.getTime()));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku) {
        return this.findByC_S(companyId, sku, -1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end) {
        return this.findByC_S(companyId, sku, start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findByC_S(companyId, sku, start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findByC_S(long companyId, String sku, int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{companyId, sku};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{companyId, sku, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : list) {
                if (companyId == commerceInventoryBookedQuantity.getCompanyId() && sku.equals(commerceInventoryBookedQuantity.getSku())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindSku) {
                    queryPos.add(sku);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceInventoryBookedQuantity findByC_S_First(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByC_S_First(companyId, sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByC_S_First(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        List<CommerceInventoryBookedQuantity> list = this.findByC_S(companyId, sku, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity findByC_S_Last(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByC_S_Last(companyId, sku, orderByComparator);
        if (commerceInventoryBookedQuantity != null) {
            return commerceInventoryBookedQuantity;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", sku=");
        sb.append(sku);
        sb.append("}");
        throw new NoSuchInventoryBookedQuantityException(sb.toString());
    }

    public CommerceInventoryBookedQuantity fetchByC_S_Last(long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        int count = this.countByC_S(companyId, sku);
        if (count == 0) {
            return null;
        }
        List<CommerceInventoryBookedQuantity> list = this.findByC_S(companyId, sku, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceInventoryBookedQuantity[] findByC_S_PrevAndNext(long commerceInventoryBookedQuantityId, long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) throws NoSuchInventoryBookedQuantityException {
        sku = Objects.toString(sku, "");
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.findByPrimaryKey(commerceInventoryBookedQuantityId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity[] array = new CommerceInventoryBookedQuantityImpl[]{this.getByC_S_PrevAndNext(session, commerceInventoryBookedQuantity, companyId, sku, orderByComparator, true), commerceInventoryBookedQuantity, this.getByC_S_PrevAndNext(session, commerceInventoryBookedQuantity, companyId, sku, orderByComparator, false)};
            CommerceInventoryBookedQuantity[] commerceInventoryBookedQuantityArray = array;
            return commerceInventoryBookedQuantityArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity getByC_S_PrevAndNext(Session session, CommerceInventoryBookedQuantity commerceInventoryBookedQuantity, long companyId, String sku, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
        sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
        boolean bindSku = false;
        if (sku.isEmpty()) {
            sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
        } else {
            bindSku = true;
            sb.append("commerceInventoryBookedQuantity.sku = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindSku) {
            queryPos.add(sku);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceInventoryBookedQuantity)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceInventoryBookedQuantity)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long companyId, String sku) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findByC_S(companyId, sku, -1, -1, null)) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countByC_S(long companyId, String sku) {
        sku = Objects.toString(sku, "");
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{companyId, sku};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE);
            sb.append(_FINDER_COLUMN_C_S_COMPANYID_2);
            boolean bindSku = false;
            if (sku.isEmpty()) {
                sb.append("(commerceInventoryBookedQuantity.sku IS NULL OR commerceInventoryBookedQuantity.sku = '')");
            } else {
                bindSku = true;
                sb.append("commerceInventoryBookedQuantity.sku = ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindSku) {
                    queryPos.add(sku);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceInventoryBookedQuantityPersistenceImpl() {
        block2: {
            HashMap<String, String> dbColumnNames = new HashMap<String, String>();
            dbColumnNames.put("commerceInventoryBookedQuantityId", "CIBookedQuantityId");
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        this.setModelClass(CommerceInventoryBookedQuantity.class);
    }

    public void cacheResult(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        this.entityCache.putResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey()), (Serializable)commerceInventoryBookedQuantity);
        commerceInventoryBookedQuantity.resetOriginalValues();
    }

    public void cacheResult(List<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities) {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            if (this.entityCache.getResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey())) == null) {
                this.cacheResult(commerceInventoryBookedQuantity);
                continue;
            }
            commerceInventoryBookedQuantity.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceInventoryBookedQuantityImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        this.entityCache.removeResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<CommerceInventoryBookedQuantity> commerceInventoryBookedQuantities) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : commerceInventoryBookedQuantities) {
            this.entityCache.removeResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, primaryKey);
        }
    }

    public CommerceInventoryBookedQuantity create(long commerceInventoryBookedQuantityId) {
        CommerceInventoryBookedQuantityImpl commerceInventoryBookedQuantity = new CommerceInventoryBookedQuantityImpl();
        commerceInventoryBookedQuantity.setNew(true);
        commerceInventoryBookedQuantity.setPrimaryKey(commerceInventoryBookedQuantityId);
        commerceInventoryBookedQuantity.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity remove(long commerceInventoryBookedQuantityId) throws NoSuchInventoryBookedQuantityException {
        return this.remove(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public CommerceInventoryBookedQuantity remove(Serializable primaryKey) throws NoSuchInventoryBookedQuantityException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.get(CommerceInventoryBookedQuantityImpl.class, primaryKey);
            if (commerceInventoryBookedQuantity == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchInventoryBookedQuantityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity2 = (CommerceInventoryBookedQuantity)this.remove((BaseModel)commerceInventoryBookedQuantity);
            return commerceInventoryBookedQuantity2;
        }
        catch (NoSuchInventoryBookedQuantityException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceInventoryBookedQuantity removeImpl(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceInventoryBookedQuantity)) {
                commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.get(CommerceInventoryBookedQuantityImpl.class, commerceInventoryBookedQuantity.getPrimaryKeyObj());
            }
            if (commerceInventoryBookedQuantity != null) {
                session.delete((Object)commerceInventoryBookedQuantity);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceInventoryBookedQuantity != null) {
            this.clearCache(commerceInventoryBookedQuantity);
        }
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity updateImpl(CommerceInventoryBookedQuantity commerceInventoryBookedQuantity) {
        boolean isNew = commerceInventoryBookedQuantity.isNew();
        if (!(commerceInventoryBookedQuantity instanceof CommerceInventoryBookedQuantityModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceInventoryBookedQuantity.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceInventoryBookedQuantity);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceInventoryBookedQuantity proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceInventoryBookedQuantity implementation " + commerceInventoryBookedQuantity.getClass());
        }
        CommerceInventoryBookedQuantityModelImpl commerceInventoryBookedQuantityModelImpl = (CommerceInventoryBookedQuantityModelImpl)commerceInventoryBookedQuantity;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceInventoryBookedQuantity.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceInventoryBookedQuantity.setCreateDate(now);
            } else {
                commerceInventoryBookedQuantity.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceInventoryBookedQuantityModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceInventoryBookedQuantity.setModifiedDate(now);
            } else {
                commerceInventoryBookedQuantity.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceInventoryBookedQuantity);
                commerceInventoryBookedQuantity.setNew(false);
            } else {
                commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.merge((Object)commerceInventoryBookedQuantity);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceInventoryBookedQuantityModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceInventoryBookedQuantityModelImpl.getSku()};
            this.finderCache.removeResult(this._finderPathCountBySku, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindBySku, args);
            args = new Object[]{commerceInventoryBookedQuantityModelImpl.getCompanyId(), commerceInventoryBookedQuantityModelImpl.getSku()};
            this.finderCache.removeResult(this._finderPathCountByC_S, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceInventoryBookedQuantityModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindBySku.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceInventoryBookedQuantityModelImpl.getOriginalSku()};
                this.finderCache.removeResult(this._finderPathCountBySku, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindBySku, args);
                args = new Object[]{commerceInventoryBookedQuantityModelImpl.getSku()};
                this.finderCache.removeResult(this._finderPathCountBySku, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindBySku, args);
            }
            if ((commerceInventoryBookedQuantityModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_S.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceInventoryBookedQuantityModelImpl.getOriginalCompanyId(), commerceInventoryBookedQuantityModelImpl.getOriginalSku()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
                args = new Object[]{commerceInventoryBookedQuantityModelImpl.getCompanyId(), commerceInventoryBookedQuantityModelImpl.getSku()};
                this.finderCache.removeResult(this._finderPathCountByC_S, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_S, args);
            }
        }
        this.entityCache.putResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, (Serializable)Long.valueOf(commerceInventoryBookedQuantity.getPrimaryKey()), (Serializable)commerceInventoryBookedQuantity, false);
        commerceInventoryBookedQuantity.resetOriginalValues();
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity findByPrimaryKey(Serializable primaryKey) throws NoSuchInventoryBookedQuantityException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByPrimaryKey(primaryKey);
        if (commerceInventoryBookedQuantity == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchInventoryBookedQuantityException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity findByPrimaryKey(long commerceInventoryBookedQuantityId) throws NoSuchInventoryBookedQuantityException {
        return this.findByPrimaryKey(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public CommerceInventoryBookedQuantity fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)serializable;
        if (commerceInventoryBookedQuantity == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceInventoryBookedQuantity = (CommerceInventoryBookedQuantity)session.get(CommerceInventoryBookedQuantityImpl.class, primaryKey);
                if (commerceInventoryBookedQuantity != null) {
                    this.cacheResult(commerceInventoryBookedQuantity);
                } else {
                    this.entityCache.putResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceInventoryBookedQuantity;
    }

    public CommerceInventoryBookedQuantity fetchByPrimaryKey(long commerceInventoryBookedQuantityId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceInventoryBookedQuantityId));
    }

    public Map<Serializable, CommerceInventoryBookedQuantity> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceInventoryBookedQuantity> map = new HashMap<Serializable, CommerceInventoryBookedQuantity>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this.fetchByPrimaryKey(primaryKey);
            if (commerceInventoryBookedQuantity != null) {
                map.put(primaryKey, commerceInventoryBookedQuantity);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceInventoryBookedQuantity)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : query.list()) {
                map.put(commerceInventoryBookedQuantity.getPrimaryKeyObj(), commerceInventoryBookedQuantity);
                this.cacheResult(commerceInventoryBookedQuantity);
                uncachedPrimaryKeys.remove(commerceInventoryBookedQuantity.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceInventoryBookedQuantity> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceInventoryBookedQuantity> findAll(int start, int end, OrderByComparator<CommerceInventoryBookedQuantity> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEINVENTORYBOOKEDQUANTITY;
                sql = sql.concat(" ORDER BY commerceInventoryBookedQuantity.commerceInventoryBookedQuantityId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceInventoryBookedQuantity commerceInventoryBookedQuantity : this.findAll()) {
            this.remove((BaseModel)commerceInventoryBookedQuantity);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEINVENTORYBOOKEDQUANTITY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceInventoryBookedQuantityModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._finderPathWithPaginationFindAll = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindBySku = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySku", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindBySku = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySku", new String[]{String.class.getName()}, 4L);
        this._finderPathCountBySku = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySku", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByLtExpirationDate = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLtExpirationDate", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByLtExpirationDate = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByLtExpirationDate", new String[]{Date.class.getName()});
        this._finderPathWithPaginationFindByC_S = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_S = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, CommerceInventoryBookedQuantityImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), String.class.getName()}, 5L);
        this._finderPathCountByC_S = new FinderPath(CommerceInventoryBookedQuantityModelImpl.ENTITY_CACHE_ENABLED, CommerceInventoryBookedQuantityModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), String.class.getName()});
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceInventoryBookedQuantityImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }
}

