/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseItemException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.exception.NoSuchInventoryWarehouseItemException;
import com.liferay.commerce.inventory.model.CIWarehouseItem;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseItemLocalServiceBaseImpl;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CommerceInventoryWarehouseItemLocalServiceImpl
extends CommerceInventoryWarehouseItemLocalServiceBaseImpl {
    @ServiceReference(type=CommerceInventoryAuditTypeRegistry.class)
    protected CommerceInventoryAuditTypeRegistry commerceInventoryAuditTypeRegistry;
    @ServiceReference(type=UserService.class)
    protected UserService userService;

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseId, "", sku, quantity);
    }

    public CommerceInventoryWarehouseItem addCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String externalReferenceCode, String sku, int quantity) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        if (Validator.isNotNull((String)sku)) {
            this.validate(commerceInventoryWarehouseId, sku);
        }
        long commerceInventoryWarehouseItemId = this.counterLocalService.increment();
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.create(commerceInventoryWarehouseItemId);
        commerceInventoryWarehouseItem.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouseItem.setUserId(user.getUserId());
        commerceInventoryWarehouseItem.setUserName(user.getFullName());
        commerceInventoryWarehouseItem.setCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
        commerceInventoryWarehouseItem.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryWarehouseItem.setSku(sku);
        commerceInventoryWarehouseItem.setQuantity(quantity);
        return (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
    }

    public int countItemsByCompanyId(long companyId, String sku) {
        return this.commerceInventoryWarehouseItemFinder.countItemsByCompanyId(companyId, sku);
    }

    public void deleteCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public void deleteCommerceInventoryWarehouseItems(long companyId, String sku) {
        this.commerceInventoryWarehouseItemPersistence.removeByCompanyId_Sku(companyId, sku);
    }

    public void deleteCommerceInventoryWarehouseItemsByCompanyId(long companyId) {
        this.commerceInventoryWarehouseItemPersistence.removeByCompanyId(companyId);
    }

    public CommerceInventoryWarehouseItem fetchCommerceInventoryWarehouseItem(long commerceInventoryWarehouseId, String sku) {
        return this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
    }

    public CommerceInventoryWarehouseItem getCommerceInventoryWarehouseItemByReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            throw new NoSuchInventoryWarehouseItemException();
        }
        return this.commerceInventoryWarehouseItemPersistence.findByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long commerceInventoryWarehouseId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCommerceInventoryWarehouseId(commerceInventoryWarehouseId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItems(long companyId, String sku, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId_Sku(companyId, sku, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyId(long companyId, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId(companyId, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByCompanyIdAndSku(long companyId, String sku, int start, int end) {
        return this.commerceInventoryWarehouseItemPersistence.findByCompanyId_Sku(companyId, sku, start, end);
    }

    public List<CommerceInventoryWarehouseItem> getCommerceInventoryWarehouseItemsByModifiedDate(long companyId, Date startDate, Date endDate, int start, int end) {
        return this.commerceInventoryWarehouseItemFinder.findUpdatedItemsByC_M(companyId, startDate, endDate, start, end);
    }

    public int getCommerceInventoryWarehouseItemsCount(long commerceInventoryWarehouseId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCommerceInventoryWarehouseId(commerceInventoryWarehouseId);
    }

    public int getCommerceInventoryWarehouseItemsCount(long companyId, String sku) {
        return this.commerceInventoryWarehouseItemPersistence.countByCompanyId_Sku(companyId, sku);
    }

    public int getCommerceInventoryWarehouseItemsCountByCompanyId(long companyId) {
        return this.commerceInventoryWarehouseItemPersistence.countByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehouseItemsCountByModifiedDate(long companyId, Date startDate, Date endDate) {
        return this.commerceInventoryWarehouseItemFinder.countUpdatedItemsByC_M(companyId, startDate, endDate);
    }

    public List<CIWarehouseItem> getItemsByCompanyId(long companyId, String sku, int start, int end) {
        List objects = this.commerceInventoryWarehouseItemFinder.findItemsByCompanyId(companyId, sku, start, end);
        ArrayList<CIWarehouseItem> ciWarehouseItems = new ArrayList<CIWarehouseItem>();
        for (Object[] object : objects) {
            if (object == null) continue;
            String skuCode = "";
            if (object.length > 0 && object[0] != null) {
                skuCode = (String)object[0];
            }
            Integer stock = 0;
            if (object.length > 1 && object[1] != null) {
                stock = (Integer)object[1];
            }
            Integer booked = 0;
            if (object.length > 2 && object[2] != null) {
                booked = (Integer)object[2];
            }
            Integer replenishment = 0;
            if (object.length > 3 && object[3] != null) {
                replenishment = (Integer)object[3];
            }
            ciWarehouseItems.add(new CIWarehouseItem(skuCode, stock.intValue(), booked.intValue(), replenishment.intValue()));
        }
        return ciWarehouseItems;
    }

    public int getStockQuantity(long companyId, long groupId, String sku) {
        return this.commerceInventoryWarehouseItemFinder.countStockQuantityByC_G_S(companyId, groupId, sku);
    }

    public int getStockQuantity(long companyId, String sku) {
        return this.commerceInventoryWarehouseItemFinder.countStockQuantityByC_S(companyId, sku);
    }

    public CommerceInventoryWarehouseItem increaseCommerceInventoryWarehouseItemQuantity(long userId, long commerceInventoryWarehouseItemId, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        commerceInventoryWarehouseItem.setQuantity(quantity += commerceInventoryWarehouseItem.getQuantity());
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this.commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryWarehouseItem.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), quantity);
        return commerceInventoryWarehouseItem;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void moveQuantitiesBetweenWarehouses(long userId, long fromCommerceInventoryWarehouseId, long toCommerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem fromWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByC_S(fromCommerceInventoryWarehouseId, sku);
        if (quantity > fromWarehouseItem.getQuantity()) {
            throw new PortalException("Quantity to transfer unavailable");
        }
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, fromWarehouseItem.getCommerceInventoryWarehouseItemId(), fromWarehouseItem.getQuantity() - quantity, fromWarehouseItem.getMvccVersion());
        CommerceInventoryWarehouseItem toWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByC_S(toCommerceInventoryWarehouseId, sku);
        this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, toWarehouseItem.getCommerceInventoryWarehouseItemId(), toWarehouseItem.getQuantity() + quantity, toWarehouseItem.getMvccVersion());
        CommerceInventoryAuditType commerceInventoryAuditType = this.commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("move-quantity");
        HashMap<String, String> context = new HashMap<String, String>();
        CommerceInventoryWarehouse fromCommerceInventoryWarehouse = fromWarehouseItem.getCommerceInventoryWarehouse();
        context.put("from", String.valueOf(fromCommerceInventoryWarehouse.getName()));
        CommerceInventoryWarehouse toCommerceInventoryWarehouse = toWarehouseItem.getCommerceInventoryWarehouse();
        context.put("to", String.valueOf(toCommerceInventoryWarehouse.getName()));
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, int quantity, int reservedQuantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem.setReservedQuantity(reservedQuantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this.commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("reserved", String.valueOf(reservedQuantity));
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        context.put("warehouse", String.valueOf(commerceInventoryWarehouse.getName()));
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryWarehouseItem.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem updateCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseItemId, int quantity, long mvccVersion) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.findByPrimaryKey(commerceInventoryWarehouseItemId);
        if (commerceInventoryWarehouseItem.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouseItem.setQuantity(quantity);
        commerceInventoryWarehouseItem = (CommerceInventoryWarehouseItem)this.commerceInventoryWarehouseItemPersistence.update((BaseModel)commerceInventoryWarehouseItem);
        CommerceInventoryAuditType commerceInventoryAuditType = this.commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("update-warehouse-item");
        HashMap<String, String> context = new HashMap<String, String>();
        CommerceInventoryWarehouse commerceInventoryWarehouse = commerceInventoryWarehouseItem.getCommerceInventoryWarehouse();
        context.put("warehouse", String.valueOf(commerceInventoryWarehouse.getName()));
        this.commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryWarehouseItem.getSku(), commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
        return commerceInventoryWarehouseItem;
    }

    public CommerceInventoryWarehouseItem upsertCommerceInventoryWarehouseItem(long companyId, long userId, long commerceInventoryWarehouseId, String externalReferenceCode, String sku, int quantity) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByC_ERC(companyId, externalReferenceCode);
            if (commerceInventoryWarehouseItem != null) {
                return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), quantity, commerceInventoryWarehouseItem.getMvccVersion());
            }
        }
        return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseId, externalReferenceCode, sku, quantity);
    }

    public CommerceInventoryWarehouseItem upsertCommerceInventoryWarehouseItem(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
        if (commerceInventoryWarehouseItem == null) {
            return this.commerceInventoryWarehouseItemLocalService.addCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseId, sku, quantity);
        }
        return this.commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), quantity, commerceInventoryWarehouseItem.getMvccVersion());
    }

    protected void validate(long commerceInventoryWarehouseId, String sku) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this.commerceInventoryWarehouseItemPersistence.fetchByC_S(commerceInventoryWarehouseId, sku);
        if (commerceInventoryWarehouseItem != null) {
            throw new DuplicateCommerceInventoryWarehouseItemException();
        }
    }
}

