/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.search;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceInventoryWarehouseIndexer
extends BaseIndexer<CommerceInventoryWarehouse> {
    public static final String CLASS_NAME = CommerceInventoryWarehouse.class.getName();
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_CITY = "city";
    public static final String FIELD_COUNTRY_TWO_LETTERS_ISO_CODE = "countryTwoLettersISOCode";
    public static final String FIELD_STREET_1 = "street1";
    public static final String FIELD_ZIP = "zip";
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryWarehouseIndexer.class);
    @Reference
    private CommerceInventoryWarehouseLocalService _commerceInventoryWarehouseLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _modelResourcePermission;

    public CommerceInventoryWarehouseIndexer() {
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._modelResourcePermission.contains(permissionChecker, entryClassPK, actionId);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Boolean active = (Boolean)searchContext.getAttribute(FIELD_ACTIVE);
        if (active != null) {
            contextBooleanFilter.addTerm(FIELD_ACTIVE, String.valueOf(active), BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        super.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_CITY, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_STREET_1, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_ZIP, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_COUNTRY_TWO_LETTERS_ISO_CODE, false);
    }

    protected void doDelete(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        this.deleteDocument(commerceInventoryWarehouse.getCompanyId(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
    }

    protected Document doGetDocument(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing inventory warehouse " + commerceInventoryWarehouse));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceInventoryWarehouse);
        document.addKeyword("description", commerceInventoryWarehouse.getDescription());
        document.addNumberSortable("entryClassPK", Long.valueOf(commerceInventoryWarehouse.getCommerceInventoryWarehouseId()));
        document.addKeyword("name", commerceInventoryWarehouse.getName());
        document.addKeyword(FIELD_ACTIVE, commerceInventoryWarehouse.isActive());
        document.addKeyword(FIELD_COUNTRY_TWO_LETTERS_ISO_CODE, commerceInventoryWarehouse.getCountryTwoLettersISOCode());
        document.addKeyword(FIELD_CITY, commerceInventoryWarehouse.getCity());
        document.addKeyword(FIELD_STREET_1, commerceInventoryWarehouse.getStreet1());
        document.addKeyword(FIELD_ZIP, commerceInventoryWarehouse.getZip());
        document.addNumber("itemsQuantity", this.getItemsQuantity(commerceInventoryWarehouse));
        document.addNumber("latitude", commerceInventoryWarehouse.getLatitude());
        document.addNumber("longitude", commerceInventoryWarehouse.getLongitude());
        document.addKeyword("regionCode", commerceInventoryWarehouse.getCommerceRegionCode());
        document.addKeyword("street2", commerceInventoryWarehouse.getStreet2());
        document.addKeyword("street3", commerceInventoryWarehouse.getStreet3());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceInventoryWarehouse + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceInventoryWarehouse commerceInventoryWarehouse) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceInventoryWarehouse.getCompanyId(), this.getDocument(commerceInventoryWarehouse), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceInventoryWarehouses(companyId);
    }

    protected int getItemsQuantity(CommerceInventoryWarehouse commerceInventoryWarehouse) {
        int count = 0;
        for (CommerceInventoryWarehouseItem commerceInventoryWarehouseItem : commerceInventoryWarehouse.getCommerceInventoryWarehouseItems()) {
            count += commerceInventoryWarehouseItem.getQuantity();
        }
        return count;
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Boolean useSearchResultPermissionFilter = (Boolean)searchContext.getAttribute("useSearchResultPermissionFilter");
        if (useSearchResultPermissionFilter != null) {
            return useSearchResultPermissionFilter;
        }
        return super.isUseSearchResultPermissionFilter(searchContext);
    }

    protected void reindexCommerceInventoryWarehouses(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceInventoryWarehouseLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceInventoryWarehouse -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceInventoryWarehouse)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce inventory warehouse " + commerceInventoryWarehouse.getCommerceInventoryWarehouseId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

