/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.engine;

import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceInventoryEngine.class})
public class CommerceInventoryEngineImpl
implements CommerceInventoryEngine {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryEngineImpl.class);
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceBookedQuantityLocalService;
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void consumeQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity, long bookedQuantityId, Map<String, String> context) throws PortalException {
        if (bookedQuantityId > 0L) {
            this._commerceBookedQuantityLocalService.consumeCommerceBookedQuantity(bookedQuantityId, quantity);
        }
        this.decreaseStockQuantity(userId, commerceInventoryWarehouseId, sku, quantity);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("consume-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void decreaseStockQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku);
        this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getQuantity() - quantity, commerceInventoryWarehouseItem.getMvccVersion());
    }

    public Map<String, Integer> getStockQuantities(long companyId, long channelGroupId, List<String> skus) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String sku : skus) {
            int stockQuantity = this.getStockQuantity(companyId, channelGroupId, sku);
            results.put(sku, stockQuantity);
        }
        return results;
    }

    public int getStockQuantity(long companyId, long channelGroupId, String sku) {
        int stockQuantity = this._commerceInventoryWarehouseItemLocalService.getStockQuantity(companyId, channelGroupId, sku);
        int commerceBookedQuantity = this._commerceBookedQuantityLocalService.getCommerceBookedQuantity(companyId, sku);
        return stockQuantity - commerceBookedQuantity;
    }

    public int getStockQuantity(long companyId, String sku) {
        int stockQuantity = this._commerceInventoryWarehouseItemLocalService.getStockQuantity(companyId, sku);
        int commerceBookedQuantity = this._commerceBookedQuantityLocalService.getCommerceBookedQuantity(companyId, sku);
        return stockQuantity - commerceBookedQuantity;
    }

    public boolean hasStockQuantity(long companyId, String sku, int quantity) {
        return quantity <= this.getStockQuantity(companyId, sku);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void increaseStockQuantity(long userId, long commerceInventoryWarehouseId, String sku, int quantity) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku);
        try {
            this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getQuantity() + quantity, commerceInventoryWarehouseItem.getMvccVersion());
        }
        catch (MVCCException mvcce) {
            _log.error((Object)mvcce.getMessage(), (Throwable)mvcce);
            throw mvcce;
        }
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, sku, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), quantity);
    }
}

