/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.google.merchant.internal.background.task;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.liferay.commerce.google.merchant.internal.jsch.FingerprintHostKeyRepository;
import com.liferay.commerce.google.merchant.internal.sftp.SftpConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.commerce.google.merchant.internal.sftp.SftpConfiguration"}, property={"background.task.executor.class.name=com.liferay.commerce.google.merchant.internal.background.task.GoogleMerchantBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class GoogleMerchantBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private SftpConfiguration _sftpConfiguration;

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        this._upload("test.xml", "TEST");
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._sftpConfiguration = (SftpConfiguration)ConfigurableUtil.createConfigurable(SftpConfiguration.class, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _upload(String fileName, String fileContent) throws Exception {
        ChannelSftp channelSftp = null;
        Session jschSession = null;
        try {
            String host = this._sftpConfiguration.host();
            String password = this._sftpConfiguration.password();
            int port = this._sftpConfiguration.port();
            String username = this._sftpConfiguration.username();
            JSch jSch = new JSch();
            FingerprintHostKeyRepository fingerprintHostKeyRepository = new FingerprintHostKeyRepository(jSch, this._sftpConfiguration.fingerprint());
            jSch.setHostKeyRepository((HostKeyRepository)fingerprintHostKeyRepository);
            jschSession = jSch.getSession(username, host);
            jschSession.setPassword(password);
            jschSession.setPort(port);
            jschSession.connect();
            channelSftp = (ChannelSftp)jschSession.openChannel("sftp");
            channelSftp.connect();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
            channelSftp.put((InputStream)inputStream, fileName);
        }
        finally {
            if (channelSftp != null) {
                channelSftp.disconnect();
                channelSftp.exit();
            }
            if (jschSession != null) {
                jschSession.disconnect();
            }
        }
    }
}

