/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.google.merchant.internal.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.liferay.commerce.google.merchant.internal.xml.model.Feed;
import com.liferay.commerce.google.merchant.internal.xml.model.Link;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.exception.InvalidCommerceChannelTypeException;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ProductFeedXMLGenerator.class})
public class ProductFeedXMLGenerator {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    public String generateProductFeedXML(long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        if (!"site".equals(commerceChannel.getType())) {
            throw new InvalidCommerceChannelTypeException("Cannot generate products XML for channel with ID " + commerceChannelId + " because channel must be site type channel");
        }
        Feed feed = new Feed();
        feed.setTitle(commerceChannel.getName());
        Group group = this._groupLocalService.getGroup(commerceChannel.getSiteGroupId());
        String href = this._portal.getLayoutSetDisplayURL(group.getPublicLayoutSet(), false);
        Link link = new Link(href);
        feed.setLink(link);
        String updated = DateUtil.getCurrentDate((String)"yyyy-MM-dd'T'HH:mm:ssZ", null, (TimeZone)TimeZoneUtil.GMT);
        feed.setUpdated(updated);
        int total = this._countCPCatalogEntriesByChannel(commerceChannel);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor(total);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List<CPCatalogEntry> cpCatalogEntries = this._getCPCatalogEntriesByChannel(commerceChannel, start, end);
            intervalActionProcessor.incrementStart(cpCatalogEntries.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
        try {
            WstxInputFactory xmlInputFactory = new WstxInputFactory();
            WstxOutputFactory xmlOutputFactory = new WstxOutputFactory();
            xmlOutputFactory.setProperty("com.ctc.wstx.outputValidateAttr", true);
            XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)xmlInputFactory, (XMLOutputFactory)xmlOutputFactory);
            XmlMapper xmlMapper = new XmlMapper(xmlFactory);
            xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            return xmlMapper.writeValueAsString((Object)feed);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new PortalException((Throwable)jsonProcessingException);
        }
    }

    private int _countCPCatalogEntriesByChannel(CommerceChannel commerceChannel) throws PortalException {
        long commerceChannelGroupId = commerceChannel.getGroupId();
        SearchContext searchContext = this._getSearchContext(commerceChannel);
        return GetterUtil.getInteger((Object)this._cpDefinitionHelper.searchCount(commerceChannelGroupId, searchContext, new CPQuery()));
    }

    private List<CPCatalogEntry> _getCPCatalogEntriesByChannel(CommerceChannel commerceChannel, int start, int end) throws PortalException {
        long commerceChannelGroupId = commerceChannel.getGroupId();
        SearchContext searchContext = this._getSearchContext(commerceChannel);
        CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(commerceChannelGroupId, searchContext, new CPQuery(), start, end);
        return cpDataSourceResult.getCPCatalogEntries();
    }

    private SearchContext _getSearchContext(CommerceChannel commerceChannel) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"commerceAccountGroupIds", (Object)new long[]{-1L}).put((Object)"commerceChannelGroupId", (Object)commerceChannel.getGroupId()).build());
        searchContext.setCompanyId(commerceChannel.getCompanyId());
        return searchContext;
    }
}

