/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.google.merchant.internal.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.liferay.commerce.google.merchant.internal.jsch.FingerprintHostKeyRepository;
import com.liferay.commerce.google.merchant.internal.sftp.SftpConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.commerce.google.merchant.internal.sftp.SftpConfiguration"}, immediate=true, service={SftpUploader.class})
public class SftpUploader {
    private SftpConfiguration _sftpConfiguration;

    @Activate
    public void activate(Map<String, Object> properties) {
        this._sftpConfiguration = (SftpConfiguration)ConfigurableUtil.createConfigurable(SftpConfiguration.class, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String fileName, String fileContent) throws Exception {
        ChannelSftp channelSftp = null;
        Session jschSession = null;
        try {
            String host = this._sftpConfiguration.host();
            String password = this._sftpConfiguration.password();
            int port = this._sftpConfiguration.port();
            String username = this._sftpConfiguration.username();
            JSch jsch = new JSch();
            FingerprintHostKeyRepository fingerprintHostKeyRepository = new FingerprintHostKeyRepository(jsch, this._sftpConfiguration.fingerprint());
            jsch.setHostKeyRepository((HostKeyRepository)fingerprintHostKeyRepository);
            jschSession = jsch.getSession(username, host);
            jschSession.setPassword(password);
            jschSession.setPort(port);
            jschSession.connect();
            channelSftp = (ChannelSftp)jschSession.openChannel("sftp");
            channelSftp.connect();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
            channelSftp.put((InputStream)inputStream, fileName);
        }
        finally {
            if (channelSftp != null) {
                channelSftp.disconnect();
                channelSftp.exit();
            }
            if (jschSession != null) {
                jschSession.disconnect();
            }
        }
    }
}

