/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.internal.messaging;

import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcess;
import com.liferay.commerce.data.integration.service.CommerceDataIntegrationProcessLocalService;
import com.liferay.commerce.data.integration.service.ScheduledTaskExecutorService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/commerce/data_integration/executor"}, service={MessageListener.class})
public class CommerceDataIntegrationMessageListener
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(CommerceDataIntegrationMessageListener.class);
    @Reference
    private CommerceDataIntegrationProcessLocalService _commerceDataIntegrationProcessLocalService;
    private ServiceTrackerMap<String, ScheduledTaskExecutorService> _scheduledTaskExecutorServiceTrackerMap;

    public void receive(Message message) throws MessageListenerException {
        block8: {
            ScheduledTaskExecutorService scheduledTaskExecutorService;
            long commerceDataIntegrationProcessId;
            block7: {
                String payLoadString = (String)message.getPayload();
                JSONObject payLoad = null;
                try {
                    payLoad = JSONFactoryUtil.createJSONObject((String)payLoadString);
                }
                catch (JSONException jsone) {
                    _log.error((Object)jsone, (Throwable)jsone);
                    throw new MessageListenerException((Throwable)jsone);
                }
                commerceDataIntegrationProcessId = payLoad.getLong("commerceDataIntegrationProcessId");
                scheduledTaskExecutorService = null;
                try {
                    scheduledTaskExecutorService = this.getScheduledTaskExecutorService(commerceDataIntegrationProcessId);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)pe, (Throwable)pe);
                }
            }
            if (scheduledTaskExecutorService != null) {
                try {
                    scheduledTaskExecutorService.runProcess(commerceDataIntegrationProcessId);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._scheduledTaskExecutorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ScheduledTaskExecutorService.class, (String)"data.integration.service.executor.key");
    }

    protected ScheduledTaskExecutorService getScheduledTaskExecutorService(long commerceDataIntegrationProcessId) throws PortalException {
        ScheduledTaskExecutorService scheduledTaskExecutorService = null;
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this._commerceDataIntegrationProcessLocalService.getCommerceDataIntegrationProcess(commerceDataIntegrationProcessId);
        if (this._scheduledTaskExecutorServiceTrackerMap != null) {
            for (String key : this._scheduledTaskExecutorServiceTrackerMap.keySet()) {
                if (!key.equals(commerceDataIntegrationProcess.getType())) continue;
                scheduledTaskExecutorService = (ScheduledTaskExecutorService)this._scheduledTaskExecutorServiceTrackerMap.getService((Object)key);
                break;
            }
        }
        return scheduledTaskExecutorService;
    }
}

