/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.service.persistence.impl;

import com.liferay.commerce.bom.exception.NoSuchBOMFolderException;
import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.model.CommerceBOMFolderTable;
import com.liferay.commerce.bom.model.impl.CommerceBOMFolderImpl;
import com.liferay.commerce.bom.model.impl.CommerceBOMFolderModelImpl;
import com.liferay.commerce.bom.service.persistence.CommerceBOMFolderPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceBOMFolderPersistenceImpl
extends BasePersistenceImpl<CommerceBOMFolder>
implements CommerceBOMFolderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceBOMFolderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceBOMFolder.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_P;
    private FinderPath _finderPathWithoutPaginationFindByC_P;
    private FinderPath _finderPathCountByC_P;
    private static final String _FINDER_COLUMN_C_P_COMPANYID_2 = "commerceBOMFolder.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2 = "commerceBOMFolder.parentCommerceBOMFolderId = ?";
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEBOMFOLDER = "SELECT commerceBOMFolder FROM CommerceBOMFolder commerceBOMFolder";
    private static final String _SQL_SELECT_COMMERCEBOMFOLDER_WHERE = "SELECT commerceBOMFolder FROM CommerceBOMFolder commerceBOMFolder WHERE ";
    private static final String _SQL_COUNT_COMMERCEBOMFOLDER = "SELECT COUNT(commerceBOMFolder) FROM CommerceBOMFolder commerceBOMFolder";
    private static final String _SQL_COUNT_COMMERCEBOMFOLDER_WHERE = "SELECT COUNT(commerceBOMFolder) FROM CommerceBOMFolder commerceBOMFolder WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "commerceBOMFolder.commerceBOMFolderId";
    private static final String _FILTER_SQL_SELECT_COMMERCEBOMFOLDER_WHERE = "SELECT DISTINCT {commerceBOMFolder.*} FROM CommerceBOMFolder commerceBOMFolder WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {CommerceBOMFolder.*} FROM (SELECT DISTINCT commerceBOMFolder.commerceBOMFolderId FROM CommerceBOMFolder commerceBOMFolder WHERE ";
    private static final String _FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN CommerceBOMFolder ON TEMP_TABLE.commerceBOMFolderId = CommerceBOMFolder.commerceBOMFolderId";
    private static final String _FILTER_SQL_COUNT_COMMERCEBOMFOLDER_WHERE = "SELECT COUNT(DISTINCT commerceBOMFolder.commerceBOMFolderId) AS COUNT_VALUE FROM CommerceBOMFolder commerceBOMFolder WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "commerceBOMFolder";
    private static final String _FILTER_ENTITY_TABLE = "CommerceBOMFolder";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceBOMFolder.";
    private static final String _ORDER_BY_ENTITY_TABLE = "CommerceBOMFolder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceBOMFolder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceBOMFolder exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceBOMFolderPersistenceImpl.class);
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceBOMFolder> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceBOMFolder> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceBOMFolder> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceBOMFolder> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceBOMFolder commerceBOMFolder : list) {
                if (companyId == commerceBOMFolder.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceBOMFolder.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceBOMFolder findByCompanyId_First(long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceBOMFolder != null) {
            return commerceBOMFolder;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchBOMFolderException(sb.toString());
    }

    public CommerceBOMFolder fetchByCompanyId_First(long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        List<CommerceBOMFolder> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceBOMFolder findByCompanyId_Last(long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceBOMFolder != null) {
            return commerceBOMFolder;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchBOMFolderException(sb.toString());
    }

    public CommerceBOMFolder fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceBOMFolder> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceBOMFolder[] findByCompanyId_PrevAndNext(long commerceBOMFolderId, long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.findByPrimaryKey(commerceBOMFolderId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceBOMFolder[] array = new CommerceBOMFolderImpl[]{this.getByCompanyId_PrevAndNext(session, commerceBOMFolder, companyId, orderByComparator, true), commerceBOMFolder, this.getByCompanyId_PrevAndNext(session, commerceBOMFolder, companyId, orderByComparator, false)};
            CommerceBOMFolder[] commerceBOMFolderArray = array;
            return commerceBOMFolderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceBOMFolder getByCompanyId_PrevAndNext(Session session, CommerceBOMFolder commerceBOMFolder, long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceBOMFolder)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceBOMFolder)list.get(1);
        }
        return null;
    }

    public List<CommerceBOMFolder> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceBOMFolder> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<CommerceBOMFolder> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        } else {
            sb.append(" ORDER BY CommerceBOMFolder.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceBOMFolderImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceBOMFolderImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceBOMFolder[] filterFindByCompanyId_PrevAndNext(long commerceBOMFolderId, long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(commerceBOMFolderId, companyId, orderByComparator);
        }
        CommerceBOMFolder commerceBOMFolder = this.findByPrimaryKey(commerceBOMFolderId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceBOMFolder[] array = new CommerceBOMFolderImpl[]{this.filterGetByCompanyId_PrevAndNext(session, commerceBOMFolder, companyId, orderByComparator, true), commerceBOMFolder, this.filterGetByCompanyId_PrevAndNext(session, commerceBOMFolder, companyId, orderByComparator, false)};
            CommerceBOMFolder[] commerceBOMFolderArray = array;
            return commerceBOMFolderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceBOMFolder filterGetByCompanyId_PrevAndNext(Session session, CommerceBOMFolder commerceBOMFolder, long companyId, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        } else {
            sb.append(" ORDER BY CommerceBOMFolder.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceBOMFolderImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceBOMFolderImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceBOMFolder)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceBOMFolder)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceBOMFolder commerceBOMFolder : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceBOMFolder);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEBOMFOLDER_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_COMMERCEBOMFOLDER_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceBOMFolder> findByC_P(long companyId, long parentCommerceBOMFolderId) {
        return this.findByC_P(companyId, parentCommerceBOMFolderId, -1, -1, null);
    }

    public List<CommerceBOMFolder> findByC_P(long companyId, long parentCommerceBOMFolderId, int start, int end) {
        return this.findByC_P(companyId, parentCommerceBOMFolderId, start, end, null);
    }

    public List<CommerceBOMFolder> findByC_P(long companyId, long parentCommerceBOMFolderId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        return this.findByC_P(companyId, parentCommerceBOMFolderId, start, end, orderByComparator, true);
    }

    public List<CommerceBOMFolder> findByC_P(long companyId, long parentCommerceBOMFolderId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_P;
                finderArgs = new Object[]{companyId, parentCommerceBOMFolderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_P;
            finderArgs = new Object[]{companyId, parentCommerceBOMFolderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceBOMFolder commerceBOMFolder : list) {
                if (companyId == commerceBOMFolder.getCompanyId() && parentCommerceBOMFolderId == commerceBOMFolder.getParentCommerceBOMFolderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
            sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceBOMFolder.name ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(parentCommerceBOMFolderId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceBOMFolder findByC_P_First(long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.fetchByC_P_First(companyId, parentCommerceBOMFolderId, orderByComparator);
        if (commerceBOMFolder != null) {
            return commerceBOMFolder;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", parentCommerceBOMFolderId=");
        sb.append(parentCommerceBOMFolderId);
        sb.append("}");
        throw new NoSuchBOMFolderException(sb.toString());
    }

    public CommerceBOMFolder fetchByC_P_First(long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        List<CommerceBOMFolder> list = this.findByC_P(companyId, parentCommerceBOMFolderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceBOMFolder findByC_P_Last(long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.fetchByC_P_Last(companyId, parentCommerceBOMFolderId, orderByComparator);
        if (commerceBOMFolder != null) {
            return commerceBOMFolder;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", parentCommerceBOMFolderId=");
        sb.append(parentCommerceBOMFolderId);
        sb.append("}");
        throw new NoSuchBOMFolderException(sb.toString());
    }

    public CommerceBOMFolder fetchByC_P_Last(long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        int count = this.countByC_P(companyId, parentCommerceBOMFolderId);
        if (count == 0) {
            return null;
        }
        List<CommerceBOMFolder> list = this.findByC_P(companyId, parentCommerceBOMFolderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceBOMFolder[] findByC_P_PrevAndNext(long commerceBOMFolderId, long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = this.findByPrimaryKey(commerceBOMFolderId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceBOMFolder[] array = new CommerceBOMFolderImpl[]{this.getByC_P_PrevAndNext(session, commerceBOMFolder, companyId, parentCommerceBOMFolderId, orderByComparator, true), commerceBOMFolder, this.getByC_P_PrevAndNext(session, commerceBOMFolder, companyId, parentCommerceBOMFolderId, orderByComparator, false)};
            CommerceBOMFolder[] commerceBOMFolderArray = array;
            return commerceBOMFolderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceBOMFolder getByC_P_PrevAndNext(Session session, CommerceBOMFolder commerceBOMFolder, long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(parentCommerceBOMFolderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceBOMFolder)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceBOMFolder)list.get(1);
        }
        return null;
    }

    public List<CommerceBOMFolder> filterFindByC_P(long companyId, long parentCommerceBOMFolderId) {
        return this.filterFindByC_P(companyId, parentCommerceBOMFolderId, -1, -1, null);
    }

    public List<CommerceBOMFolder> filterFindByC_P(long companyId, long parentCommerceBOMFolderId, int start, int end) {
        return this.filterFindByC_P(companyId, parentCommerceBOMFolderId, start, end, null);
    }

    public List<CommerceBOMFolder> filterFindByC_P(long companyId, long parentCommerceBOMFolderId, int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_P(companyId, parentCommerceBOMFolderId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        } else {
            sb.append(" ORDER BY CommerceBOMFolder.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceBOMFolderImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceBOMFolderImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentCommerceBOMFolderId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceBOMFolder[] filterFindByC_P_PrevAndNext(long commerceBOMFolderId, long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator) throws NoSuchBOMFolderException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_P_PrevAndNext(commerceBOMFolderId, companyId, parentCommerceBOMFolderId, orderByComparator);
        }
        CommerceBOMFolder commerceBOMFolder = this.findByPrimaryKey(commerceBOMFolderId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceBOMFolder[] array = new CommerceBOMFolderImpl[]{this.filterGetByC_P_PrevAndNext(session, commerceBOMFolder, companyId, parentCommerceBOMFolderId, orderByComparator, true), commerceBOMFolder, this.filterGetByC_P_PrevAndNext(session, commerceBOMFolder, companyId, parentCommerceBOMFolderId, orderByComparator, false)};
            CommerceBOMFolder[] commerceBOMFolderArray = array;
            return commerceBOMFolderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceBOMFolder filterGetByC_P_PrevAndNext(Session session, CommerceBOMFolder commerceBOMFolder, long companyId, long parentCommerceBOMFolderId, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_COMMERCEBOMFOLDER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY commerceBOMFolder.name ASC");
        } else {
            sb.append(" ORDER BY CommerceBOMFolder.name ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, CommerceBOMFolderImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, CommerceBOMFolderImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        queryPos.add(parentCommerceBOMFolderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceBOMFolder)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (CommerceBOMFolder)list.get(1);
        }
        return null;
    }

    public void removeByC_P(long companyId, long parentCommerceBOMFolderId) {
        for (CommerceBOMFolder commerceBOMFolder : this.findByC_P(companyId, parentCommerceBOMFolderId, -1, -1, null)) {
            this.remove((BaseModel)commerceBOMFolder);
        }
    }

    public int countByC_P(long companyId, long parentCommerceBOMFolderId) {
        FinderPath finderPath = this._finderPathCountByC_P;
        Object[] finderArgs = new Object[]{companyId, parentCommerceBOMFolderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEBOMFOLDER_WHERE);
            sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(parentCommerceBOMFolderId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC_P(long companyId, long parentCommerceBOMFolderId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC_P(companyId, parentCommerceBOMFolderId);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_COMMERCEBOMFOLDER_WHERE);
        sb.append(_FINDER_COLUMN_C_P_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_P_PARENTCOMMERCEBOMFOLDERID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)CommerceBOMFolder.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(parentCommerceBOMFolderId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public CommerceBOMFolderPersistenceImpl() {
        this.setModelClass(CommerceBOMFolder.class);
        this.setModelImplClass(CommerceBOMFolderImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceBOMFolderTable.INSTANCE);
    }

    public void cacheResult(CommerceBOMFolder commerceBOMFolder) {
        this.entityCache.putResult(CommerceBOMFolderImpl.class, (Serializable)Long.valueOf(commerceBOMFolder.getPrimaryKey()), (Serializable)commerceBOMFolder);
    }

    public void cacheResult(List<CommerceBOMFolder> commerceBOMFolders) {
        for (CommerceBOMFolder commerceBOMFolder : commerceBOMFolders) {
            if (this.entityCache.getResult(CommerceBOMFolderImpl.class, (Serializable)Long.valueOf(commerceBOMFolder.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceBOMFolder);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceBOMFolderImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceBOMFolder commerceBOMFolder) {
        this.entityCache.removeResult(CommerceBOMFolderImpl.class, (BaseModel)commerceBOMFolder);
    }

    public void clearCache(List<CommerceBOMFolder> commerceBOMFolders) {
        for (CommerceBOMFolder commerceBOMFolder : commerceBOMFolders) {
            this.entityCache.removeResult(CommerceBOMFolderImpl.class, (BaseModel)commerceBOMFolder);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceBOMFolderImpl.class, primaryKey);
        }
    }

    public CommerceBOMFolder create(long commerceBOMFolderId) {
        CommerceBOMFolderImpl commerceBOMFolder = new CommerceBOMFolderImpl();
        commerceBOMFolder.setNew(true);
        commerceBOMFolder.setPrimaryKey(commerceBOMFolderId);
        commerceBOMFolder.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceBOMFolder;
    }

    public CommerceBOMFolder remove(long commerceBOMFolderId) throws NoSuchBOMFolderException {
        return this.remove(Long.valueOf(commerceBOMFolderId));
    }

    public CommerceBOMFolder remove(Serializable primaryKey) throws NoSuchBOMFolderException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceBOMFolder commerceBOMFolder = (CommerceBOMFolder)session.get(CommerceBOMFolderImpl.class, primaryKey);
            if (commerceBOMFolder == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchBOMFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceBOMFolder commerceBOMFolder2 = (CommerceBOMFolder)this.remove((BaseModel)commerceBOMFolder);
            return commerceBOMFolder2;
        }
        catch (NoSuchBOMFolderException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceBOMFolder removeImpl(CommerceBOMFolder commerceBOMFolder) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceBOMFolder)) {
                commerceBOMFolder = (CommerceBOMFolder)session.get(CommerceBOMFolderImpl.class, commerceBOMFolder.getPrimaryKeyObj());
            }
            if (commerceBOMFolder != null) {
                session.delete((Object)commerceBOMFolder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceBOMFolder != null) {
            this.clearCache(commerceBOMFolder);
        }
        return commerceBOMFolder;
    }

    public CommerceBOMFolder updateImpl(CommerceBOMFolder commerceBOMFolder) {
        boolean isNew = commerceBOMFolder.isNew();
        if (!(commerceBOMFolder instanceof CommerceBOMFolderModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceBOMFolder.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceBOMFolder);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceBOMFolder proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceBOMFolder implementation " + commerceBOMFolder.getClass());
        }
        CommerceBOMFolderModelImpl commerceBOMFolderModelImpl = (CommerceBOMFolderModelImpl)commerceBOMFolder;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceBOMFolder.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceBOMFolder.setCreateDate(date);
            } else {
                commerceBOMFolder.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceBOMFolderModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceBOMFolder.setModifiedDate(date);
            } else {
                commerceBOMFolder.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceBOMFolder);
            } else {
                commerceBOMFolder = (CommerceBOMFolder)session.merge((Object)commerceBOMFolder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceBOMFolderImpl.class, (BaseModel)commerceBOMFolderModelImpl, false, true);
        if (isNew) {
            commerceBOMFolder.setNew(false);
        }
        commerceBOMFolder.resetOriginalValues();
        return commerceBOMFolder;
    }

    public CommerceBOMFolder findByPrimaryKey(Serializable primaryKey) throws NoSuchBOMFolderException {
        CommerceBOMFolder commerceBOMFolder = (CommerceBOMFolder)this.fetchByPrimaryKey(primaryKey);
        if (commerceBOMFolder == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchBOMFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceBOMFolder;
    }

    public CommerceBOMFolder findByPrimaryKey(long commerceBOMFolderId) throws NoSuchBOMFolderException {
        return this.findByPrimaryKey(Long.valueOf(commerceBOMFolderId));
    }

    public CommerceBOMFolder fetchByPrimaryKey(long commerceBOMFolderId) {
        return (CommerceBOMFolder)this.fetchByPrimaryKey(Long.valueOf(commerceBOMFolderId));
    }

    public List<CommerceBOMFolder> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceBOMFolder> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceBOMFolder> findAll(int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceBOMFolder> findAll(int start, int end, OrderByComparator<CommerceBOMFolder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEBOMFOLDER);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEBOMFOLDER;
                sql = sql.concat(" ORDER BY commerceBOMFolder.name ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceBOMFolder commerceBOMFolder : this.findAll()) {
            this.remove((BaseModel)commerceBOMFolder);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEBOMFOLDER);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceBOMFolderId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCEBOMFOLDER;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceBOMFolderModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceBOMFolderPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceBOMFolderModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceBOMFolder.class.getName()));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "parentCommerceBOMFolderId"}, true);
        this._finderPathWithoutPaginationFindByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_P", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "parentCommerceBOMFolderId"}, true);
        this._finderPathCountByC_P = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_P", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "parentCommerceBOMFolderId"}, false);
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceBOMFolderImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceBOMFolderModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceBOMFolderModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            CommerceBOMFolderModelImpl commerceBOMFolderModelImpl = (CommerceBOMFolderModelImpl)baseModel;
            long columnBitmask = commerceBOMFolderModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceBOMFolderModelArgumentsResolver._getValue(commerceBOMFolderModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceBOMFolderModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceBOMFolderModelArgumentsResolver._getValue(commerceBOMFolderModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(CommerceBOMFolderModelImpl commerceBOMFolderModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceBOMFolderModelImpl.getColumnOriginalValue(columnName) : commerceBOMFolderModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceBOMFolderModelImpl.getColumnBitmask("name");
        }
    }
}

