/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.service.impl;

import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.service.base.CommerceBOMFolderLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.util.List;

public class CommerceBOMFolderLocalServiceImpl
extends CommerceBOMFolderLocalServiceBaseImpl {
    @ServiceReference(type=Portal.class)
    private Portal _portal;
    @ServiceReference(type=UserFileUploadsSettings.class)
    private UserFileUploadsSettings _userFileUploadsSettings;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceBOMFolder addCommerceBOMFolder(long userId, long parentCommerceBOMFolderId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceBOMFolderId = this.counterLocalService.increment();
        CommerceBOMFolder commerceBOMFolder = this.commerceBOMFolderPersistence.create(commerceBOMFolderId);
        commerceBOMFolder.setCompanyId(user.getCompanyId());
        commerceBOMFolder.setUserId(user.getUserId());
        commerceBOMFolder.setUserName(user.getFullName());
        commerceBOMFolder.setParentCommerceBOMFolderId(parentCommerceBOMFolderId);
        commerceBOMFolder.setName(name);
        this._portal.updateImageId((BaseModel)commerceBOMFolder, logo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        commerceBOMFolder.setTreePath(commerceBOMFolder.buildTreePath());
        commerceBOMFolder = (CommerceBOMFolder)this.commerceBOMFolderPersistence.update((BaseModel)commerceBOMFolder);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), CommerceBOMFolder.class.getName(), commerceBOMFolder.getCommerceBOMFolderId(), false, false, false);
        return commerceBOMFolder;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceBOMFolder deleteCommerceBOMFolder(CommerceBOMFolder commerceBOMFolder) throws PortalException {
        this.commerceBOMFolderApplicationRelLocalService.deleteCommerceBOMFolderApplicationRelsByCommerceBOMFolderId(commerceBOMFolder.getCommerceBOMFolderId());
        this.commerceBOMDefinitionLocalService.deleteCommerceBOMDefinitions(commerceBOMFolder.getCommerceBOMFolderId());
        this.resourceLocalService.deleteResource((AuditedModel)commerceBOMFolder, 4);
        return (CommerceBOMFolder)this.commerceBOMFolderPersistence.remove((BaseModel)commerceBOMFolder);
    }

    @Override
    public CommerceBOMFolder deleteCommerceBOMFolder(long commerceBOMFolderId) throws PortalException {
        CommerceBOMFolder commerceBOMFolder = this.commerceBOMFolderPersistence.findByPrimaryKey(commerceBOMFolderId);
        return this.commerceBOMFolderLocalService.deleteCommerceBOMFolder(commerceBOMFolder);
    }

    public void deleteCommerceBOMFolders(long companyId) throws PortalException {
        List commerceBOMFolders = this.commerceBOMFolderPersistence.findByCompanyId(companyId);
        for (CommerceBOMFolder commerceBOMFolder : commerceBOMFolders) {
            this.commerceBOMFolderLocalService.deleteCommerceBOMFolder(commerceBOMFolder);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceBOMFolder updateCommerceBOMFolder(long commerceBOMFolderId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        CommerceBOMFolder commerceBOMFolder = this.commerceBOMFolderLocalService.getCommerceBOMFolder(commerceBOMFolderId);
        commerceBOMFolder.setName(name);
        this._portal.updateImageId((BaseModel)commerceBOMFolder, logo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        return (CommerceBOMFolder)this.commerceBOMFolderPersistence.update((BaseModel)commerceBOMFolder);
    }
}

