/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.internal.permission;

import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.permission.CommerceBOMFolderPermission;
import com.liferay.commerce.bom.service.CommerceBOMFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceBOMFolderPermission.class})
public class CommerceBOMFolderPermissionImpl
implements CommerceBOMFolderPermission {
    @Reference
    private CommerceBOMFolderLocalService _commerceBOMFolderLocalService;

    public void check(PermissionChecker permissionChecker, CommerceBOMFolder commerceBOMFolder, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceBOMFolder, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceBOMFolder.class.getName(), commerceBOMFolder.getCommerceBOMFolderId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceBOMFolderId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceBOMFolderId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceBOMFolder.class.getName(), commerceBOMFolderId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceBOMFolder commerceBOMFolder, String actionId) {
        return this.contains(permissionChecker, commerceBOMFolder.getCommerceBOMFolderId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceBOMFolderId, String actionId) {
        CommerceBOMFolder commerceBOMFolder = this._commerceBOMFolderLocalService.fetchCommerceBOMFolder(commerceBOMFolderId);
        if (commerceBOMFolder == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceBOMFolder, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceBOMFolderIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceBOMFolderIds)) {
            return false;
        }
        for (long commerceBOMFolderId : commerceBOMFolderIds) {
            if (this.contains(permissionChecker, commerceBOMFolderId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceBOMFolder commerceBOMFolder, String actionId) {
        if (permissionChecker.isCompanyAdmin(commerceBOMFolder.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceBOMFolder.class.getName(), commerceBOMFolder.getCommerceBOMFolderId(), permissionChecker.getUserId(), actionId) && commerceBOMFolder.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceBOMFolder.class.getName(), commerceBOMFolder.getCommerceBOMFolderId(), actionId);
    }
}

