/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.internal.permission;

import com.liferay.commerce.bom.model.CommerceBOMDefinition;
import com.liferay.commerce.bom.permission.CommerceBOMDefinitionPermission;
import com.liferay.commerce.bom.service.CommerceBOMDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceBOMDefinitionPermission.class})
public class CommerceBOMDefinitionPermissionImpl
implements CommerceBOMDefinitionPermission {
    @Reference
    private CommerceBOMDefinitionLocalService _commerceBOMDefinitionLocalService;

    public void check(PermissionChecker permissionChecker, CommerceBOMDefinition commerceBOMDefinition, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceBOMDefinition, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceBOMDefinition.class.getName(), commerceBOMDefinition.getCommerceBOMDefinitionId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceBOMDefinitionId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceBOMDefinitionId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceBOMDefinition.class.getName(), commerceBOMDefinitionId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceBOMDefinition commerceBOMDefinition, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceBOMDefinition.getCommerceBOMDefinitionId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceBOMDefinitionId, String actionId) throws PortalException {
        CommerceBOMDefinition commerceBOMDefinition = this._commerceBOMDefinitionLocalService.fetchCommerceBOMDefinition(commerceBOMDefinitionId);
        if (commerceBOMDefinition == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceBOMDefinition, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceBOMDefinitionIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceBOMDefinitionIds)) {
            return false;
        }
        for (long commerceBOMDefinitionId : commerceBOMDefinitionIds) {
            if (this.contains(permissionChecker, commerceBOMDefinitionId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceBOMDefinition commerceBOMDefinition, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceBOMDefinition.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceBOMDefinition.class.getName(), commerceBOMDefinition.getCommerceBOMDefinitionId(), permissionChecker.getUserId(), actionId) && commerceBOMDefinition.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceBOMDefinition.class.getName(), commerceBOMDefinition.getCommerceBOMDefinitionId(), actionId);
    }
}

