/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.internal.search;

import com.liferay.commerce.bom.model.CommerceBOMDefinition;
import com.liferay.commerce.bom.service.CommerceBOMDefinitionLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceBOMDefinitionIndexer
extends BaseIndexer<CommerceBOMDefinition> {
    public static final String CLASS_NAME = CommerceBOMDefinition.class.getName();
    public static final String FIELD_COMMERCE_BOM_FOLDER_ID = "commerceBOMFolderId";
    private static final Log _log = LogFactoryUtil.getLog(CommerceBOMDefinitionIndexer.class);
    @Reference
    private CommerceBOMDefinitionLocalService _commerceBOMDefinitionLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commerceBOMFolderId = GetterUtil.getLong((Object)searchContext.getAttribute(FIELD_COMMERCE_BOM_FOLDER_ID));
        contextBooleanFilter.addRequiredTerm(FIELD_COMMERCE_BOM_FOLDER_ID, commerceBOMFolderId);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
    }

    protected void doDelete(CommerceBOMDefinition commerceBOMDefinition) throws Exception {
        this.deleteDocument(commerceBOMDefinition.getCompanyId(), commerceBOMDefinition.getCommerceBOMDefinitionId());
    }

    protected Document doGetDocument(CommerceBOMDefinition commerceBOMDefinition) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce BOM definition " + commerceBOMDefinition));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceBOMDefinition);
        document.addText("name", commerceBOMDefinition.getName());
        document.addNumber(FIELD_COMMERCE_BOM_FOLDER_ID, commerceBOMDefinition.getCommerceBOMFolderId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceBOMDefinition + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceBOMDefinition commerceBOMDefinition) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceBOMDefinition.getCompanyId(), this.getDocument(commerceBOMDefinition), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceBOMDefinitionLocalService.getCommerceBOMDefinition(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceBOMDefinitions(companyId);
    }

    protected void reindexCommerceBOMDefinitions(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceBOMDefinitionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceBOMDefinition -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceBOMDefinition)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce BOM definition " + commerceBOMDefinition.getCommerceBOMDefinitionId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

