/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.service.impl;

import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.service.base.CommerceBOMFolderServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import java.util.List;

public class CommerceBOMFolderServiceImpl
extends CommerceBOMFolderServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceBOMFolder> _commerceBOMFolderModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceBOMFolderServiceImpl.class, (String)"_commerceBOMFolderModelResourcePermission", CommerceBOMFolder.class);

    public CommerceBOMFolder addCommerceBOMFolder(long userId, long parentCommerceBOMFolderId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMERCE_BOM_FOLDER");
        return this.commerceBOMFolderLocalService.addCommerceBOMFolder(userId, parentCommerceBOMFolderId, name, logo, logoBytes);
    }

    public void deleteCommerceBOMFolder(long commerceBOMFolderId) throws PortalException {
        _commerceBOMFolderModelResourcePermission.check(this.getPermissionChecker(), commerceBOMFolderId, "DELETE");
        this.commerceBOMFolderLocalService.deleteCommerceBOMFolder(commerceBOMFolderId);
    }

    public CommerceBOMFolder getCommerceBOMFolder(long commerceBOMFolderId) throws PortalException {
        _commerceBOMFolderModelResourcePermission.check(this.getPermissionChecker(), commerceBOMFolderId, "VIEW");
        return this.commerceBOMFolderLocalService.getCommerceBOMFolder(commerceBOMFolderId);
    }

    public List<CommerceBOMFolder> getCommerceBOMFolders(long companyId, int start, int end) {
        return this.commerceBOMFolderPersistence.filterFindByCompanyId(companyId, start, end);
    }

    public List<CommerceBOMFolder> getCommerceBOMFolders(long companyId, long parentCommerceBOMFolderId, int start, int end) {
        return this.commerceBOMFolderPersistence.filterFindByC_P(companyId, parentCommerceBOMFolderId, start, end);
    }

    public int getCommerceBOMFoldersCount(long companyId) {
        return this.commerceBOMFolderPersistence.filterCountByCompanyId(companyId);
    }

    public int getCommerceBOMFoldersCount(long companyId, long parentCommerceBOMFolderId) {
        return this.commerceBOMFolderPersistence.filterCountByC_P(companyId, parentCommerceBOMFolderId);
    }

    public CommerceBOMFolder updateCommerceBOMFolder(long commerceBOMFolderId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        _commerceBOMFolderModelResourcePermission.check(this.getPermissionChecker(), commerceBOMFolderId, "UPDATE");
        return this.commerceBOMFolderLocalService.updateCommerceBOMFolder(commerceBOMFolderId, name, logo, logoBytes);
    }
}

