/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.bom.model.impl;

import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.service.CommerceBOMFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringBundler;

import java.util.ArrayList;
import java.util.List;

/**
 * The extended model base implementation for the CommerceBOMFolder service. Represents a row in the &quot;CommerceBOMFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMFolderImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMFolderImpl
 * @see CommerceBOMFolder
 * @generated
 */
public abstract class CommerceBOMFolderBaseImpl
	extends CommerceBOMFolderModelImpl implements CommerceBOMFolder {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom folder model instance should use the <code>CommerceBOMFolder</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceBOMFolderLocalServiceUtil.addCommerceBOMFolder(this);
		}
		else {
			CommerceBOMFolderLocalServiceUtil.updateCommerceBOMFolder(this);
		}
	}

	@Override
	@SuppressWarnings("unused")
	public String buildTreePath() throws PortalException {
		List<CommerceBOMFolder> commerceBOMFolders =
			new ArrayList<CommerceBOMFolder>();

		CommerceBOMFolder commerceBOMFolder = this;

		while (commerceBOMFolder != null) {
			commerceBOMFolders.add(commerceBOMFolder);

			commerceBOMFolder =
				CommerceBOMFolderLocalServiceUtil.fetchCommerceBOMFolder(
					commerceBOMFolder.getParentCommerceBOMFolderId());
		}

		StringBundler sb = new StringBundler(
			(commerceBOMFolders.size() * 2) + 1);

		sb.append("/");

		for (int i = commerceBOMFolders.size() - 1; i >= 0; i--) {
			commerceBOMFolder = commerceBOMFolders.get(i);

			sb.append(commerceBOMFolder.getCommerceBOMFolderId());
			sb.append("/");
		}

		return sb.toString();
	}

	@Override
	public void updateTreePath(String treePath) {
		CommerceBOMFolder commerceBOMFolder = this;

		commerceBOMFolder.setTreePath(treePath);

		CommerceBOMFolderLocalServiceUtil.updateCommerceBOMFolder(
			commerceBOMFolder);
	}

}