/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.bom.model.impl;

import com.liferay.commerce.bom.model.CommerceBOMEntry;
import com.liferay.commerce.bom.service.CommerceBOMEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceBOMEntry service. Represents a row in the &quot;CommerceBOMEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMEntryImpl
 * @see CommerceBOMEntry
 * @generated
 */
public abstract class CommerceBOMEntryBaseImpl
	extends CommerceBOMEntryModelImpl implements CommerceBOMEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom entry model instance should use the <code>CommerceBOMEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceBOMEntryLocalServiceUtil.addCommerceBOMEntry(this);
		}
		else {
			CommerceBOMEntryLocalServiceUtil.updateCommerceBOMEntry(this);
		}
	}

}