/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.bom.model.impl;

import com.liferay.commerce.bom.model.CommerceBOMDefinition;
import com.liferay.commerce.bom.service.CommerceBOMDefinitionLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceBOMDefinition service. Represents a row in the &quot;CommerceBOMDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMDefinitionImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMDefinitionImpl
 * @see CommerceBOMDefinition
 * @generated
 */
public abstract class CommerceBOMDefinitionBaseImpl
	extends CommerceBOMDefinitionModelImpl implements CommerceBOMDefinition {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom definition model instance should use the <code>CommerceBOMDefinition</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceBOMDefinitionLocalServiceUtil.addCommerceBOMDefinition(
				this);
		}
		else {
			CommerceBOMDefinitionLocalServiceUtil.updateCommerceBOMDefinition(
				this);
		}
	}

}