/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.bom.model.impl;

import com.liferay.commerce.bom.model.CommerceBOMEntry;
import com.liferay.commerce.bom.model.CommerceBOMEntryModel;
import com.liferay.commerce.bom.model.CommerceBOMEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceBOMEntry service. Represents a row in the &quot;CommerceBOMEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceBOMEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceBOMEntryModelImpl
	extends BaseModelImpl<CommerceBOMEntry> implements CommerceBOMEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom entry model instance should use the <code>CommerceBOMEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceBOMEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"commerceBOMEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"number_", Types.INTEGER}, {"CPInstanceUuid", Types.VARCHAR},
		{"CProductId", Types.BIGINT}, {"commerceBOMDefinitionId", Types.BIGINT},
		{"positionX", Types.DOUBLE}, {"positionY", Types.DOUBLE},
		{"radius", Types.DOUBLE}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceBOMEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("number_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("CPInstanceUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceBOMDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("positionX", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("positionY", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("radius", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceBOMEntry (commerceBOMEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,number_ INTEGER,CPInstanceUuid VARCHAR(75) null,CProductId LONG,commerceBOMDefinitionId LONG,positionX DOUBLE,positionY DOUBLE,radius DOUBLE)";

	public static final String TABLE_SQL_DROP = "drop table CommerceBOMEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceBOMEntry.number ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceBOMEntry.number_ ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.bom.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.bom.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.bom.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
		true);

	public static final long COMMERCEBOMDEFINITIONID_COLUMN_BITMASK = 1L;

	public static final long NUMBER_COLUMN_BITMASK = 2L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceBOMEntry toModel(CommerceBOMEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceBOMEntry model = new CommerceBOMEntryImpl();

		model.setCommerceBOMEntryId(soapModel.getCommerceBOMEntryId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setNumber(soapModel.getNumber());
		model.setCPInstanceUuid(soapModel.getCPInstanceUuid());
		model.setCProductId(soapModel.getCProductId());
		model.setCommerceBOMDefinitionId(
			soapModel.getCommerceBOMDefinitionId());
		model.setPositionX(soapModel.getPositionX());
		model.setPositionY(soapModel.getPositionY());
		model.setRadius(soapModel.getRadius());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceBOMEntry> toModels(
		CommerceBOMEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceBOMEntry> models = new ArrayList<CommerceBOMEntry>(
			soapModels.length);

		for (CommerceBOMEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.bom.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.bom.model.CommerceBOMEntry"));

	public CommerceBOMEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceBOMEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceBOMEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceBOMEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceBOMEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceBOMEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceBOMEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceBOMEntry)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceBOMEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceBOMEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceBOMEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceBOMEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceBOMEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceBOMEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceBOMEntry.class.getClassLoader(), CommerceBOMEntry.class,
			ModelWrapper.class);

		try {
			Constructor<CommerceBOMEntry> constructor =
				(Constructor<CommerceBOMEntry>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommerceBOMEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceBOMEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceBOMEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<CommerceBOMEntry, Object>>();
		Map<String, BiConsumer<CommerceBOMEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceBOMEntry, ?>>();

		attributeGetterFunctions.put(
			"commerceBOMEntryId",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCommerceBOMEntryId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceBOMEntryId",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object commerceBOMEntryIdObject) {

					commerceBOMEntry.setCommerceBOMEntryId(
						(Long)commerceBOMEntryIdObject);
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCompanyId();
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object companyIdObject) {

					commerceBOMEntry.setCompanyId((Long)companyIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getUserId();
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object userIdObject) {

					commerceBOMEntry.setUserId((Long)userIdObject);
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getUserName();
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object userNameObject) {

					commerceBOMEntry.setUserName((String)userNameObject);
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCreateDate();
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object createDateObject) {

					commerceBOMEntry.setCreateDate((Date)createDateObject);
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getModifiedDate();
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object modifiedDateObject) {

					commerceBOMEntry.setModifiedDate((Date)modifiedDateObject);
				}

			});
		attributeGetterFunctions.put(
			"number",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getNumber();
				}

			});
		attributeSetterBiConsumers.put(
			"number",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object numberObject) {

					commerceBOMEntry.setNumber((Integer)numberObject);
				}

			});
		attributeGetterFunctions.put(
			"CPInstanceUuid",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCPInstanceUuid();
				}

			});
		attributeSetterBiConsumers.put(
			"CPInstanceUuid",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object CPInstanceUuidObject) {

					commerceBOMEntry.setCPInstanceUuid(
						(String)CPInstanceUuidObject);
				}

			});
		attributeGetterFunctions.put(
			"CProductId",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCProductId();
				}

			});
		attributeSetterBiConsumers.put(
			"CProductId",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object CProductIdObject) {

					commerceBOMEntry.setCProductId((Long)CProductIdObject);
				}

			});
		attributeGetterFunctions.put(
			"commerceBOMDefinitionId",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getCommerceBOMDefinitionId();
				}

			});
		attributeSetterBiConsumers.put(
			"commerceBOMDefinitionId",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry,
					Object commerceBOMDefinitionIdObject) {

					commerceBOMEntry.setCommerceBOMDefinitionId(
						(Long)commerceBOMDefinitionIdObject);
				}

			});
		attributeGetterFunctions.put(
			"positionX",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getPositionX();
				}

			});
		attributeSetterBiConsumers.put(
			"positionX",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object positionXObject) {

					commerceBOMEntry.setPositionX((Double)positionXObject);
				}

			});
		attributeGetterFunctions.put(
			"positionY",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getPositionY();
				}

			});
		attributeSetterBiConsumers.put(
			"positionY",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object positionYObject) {

					commerceBOMEntry.setPositionY((Double)positionYObject);
				}

			});
		attributeGetterFunctions.put(
			"radius",
			new Function<CommerceBOMEntry, Object>() {

				@Override
				public Object apply(CommerceBOMEntry commerceBOMEntry) {
					return commerceBOMEntry.getRadius();
				}

			});
		attributeSetterBiConsumers.put(
			"radius",
			new BiConsumer<CommerceBOMEntry, Object>() {

				@Override
				public void accept(
					CommerceBOMEntry commerceBOMEntry, Object radiusObject) {

					commerceBOMEntry.setRadius((Double)radiusObject);
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommerceBOMEntryId() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setCommerceBOMEntryId(long commerceBOMEntryId) {
		_commerceBOMEntryId = commerceBOMEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public int getNumber() {
		return _number;
	}

	@Override
	public void setNumber(int number) {
		_columnBitmask = -1L;

		_number = number;
	}

	@JSON
	@Override
	public String getCPInstanceUuid() {
		if (_CPInstanceUuid == null) {
			return "";
		}
		else {
			return _CPInstanceUuid;
		}
	}

	@Override
	public void setCPInstanceUuid(String CPInstanceUuid) {
		_CPInstanceUuid = CPInstanceUuid;
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		_CProductId = CProductId;
	}

	@JSON
	@Override
	public long getCommerceBOMDefinitionId() {
		return _commerceBOMDefinitionId;
	}

	@Override
	public void setCommerceBOMDefinitionId(long commerceBOMDefinitionId) {
		_columnBitmask |= COMMERCEBOMDEFINITIONID_COLUMN_BITMASK;

		if (!_setOriginalCommerceBOMDefinitionId) {
			_setOriginalCommerceBOMDefinitionId = true;

			_originalCommerceBOMDefinitionId = _commerceBOMDefinitionId;
		}

		_commerceBOMDefinitionId = commerceBOMDefinitionId;
	}

	public long getOriginalCommerceBOMDefinitionId() {
		return _originalCommerceBOMDefinitionId;
	}

	@JSON
	@Override
	public double getPositionX() {
		return _positionX;
	}

	@Override
	public void setPositionX(double positionX) {
		_positionX = positionX;
	}

	@JSON
	@Override
	public double getPositionY() {
		return _positionY;
	}

	@Override
	public void setPositionY(double positionY) {
		_positionY = positionY;
	}

	@JSON
	@Override
	public double getRadius() {
		return _radius;
	}

	@Override
	public void setRadius(double radius) {
		_radius = radius;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceBOMEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceBOMEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceBOMEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceBOMEntryImpl commerceBOMEntryImpl = new CommerceBOMEntryImpl();

		commerceBOMEntryImpl.setCommerceBOMEntryId(getCommerceBOMEntryId());
		commerceBOMEntryImpl.setCompanyId(getCompanyId());
		commerceBOMEntryImpl.setUserId(getUserId());
		commerceBOMEntryImpl.setUserName(getUserName());
		commerceBOMEntryImpl.setCreateDate(getCreateDate());
		commerceBOMEntryImpl.setModifiedDate(getModifiedDate());
		commerceBOMEntryImpl.setNumber(getNumber());
		commerceBOMEntryImpl.setCPInstanceUuid(getCPInstanceUuid());
		commerceBOMEntryImpl.setCProductId(getCProductId());
		commerceBOMEntryImpl.setCommerceBOMDefinitionId(
			getCommerceBOMDefinitionId());
		commerceBOMEntryImpl.setPositionX(getPositionX());
		commerceBOMEntryImpl.setPositionY(getPositionY());
		commerceBOMEntryImpl.setRadius(getRadius());

		commerceBOMEntryImpl.resetOriginalValues();

		return commerceBOMEntryImpl;
	}

	@Override
	public int compareTo(CommerceBOMEntry commerceBOMEntry) {
		int value = 0;

		if (getNumber() < commerceBOMEntry.getNumber()) {
			value = -1;
		}
		else if (getNumber() > commerceBOMEntry.getNumber()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceBOMEntry)) {
			return false;
		}

		CommerceBOMEntry commerceBOMEntry = (CommerceBOMEntry)object;

		long primaryKey = commerceBOMEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_setModifiedDate = false;

		_originalCommerceBOMDefinitionId = _commerceBOMDefinitionId;

		_setOriginalCommerceBOMDefinitionId = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceBOMEntry> toCacheModel() {
		CommerceBOMEntryCacheModel commerceBOMEntryCacheModel =
			new CommerceBOMEntryCacheModel();

		commerceBOMEntryCacheModel.commerceBOMEntryId = getCommerceBOMEntryId();

		commerceBOMEntryCacheModel.companyId = getCompanyId();

		commerceBOMEntryCacheModel.userId = getUserId();

		commerceBOMEntryCacheModel.userName = getUserName();

		String userName = commerceBOMEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceBOMEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceBOMEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceBOMEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceBOMEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceBOMEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceBOMEntryCacheModel.number = getNumber();

		commerceBOMEntryCacheModel.CPInstanceUuid = getCPInstanceUuid();

		String CPInstanceUuid = commerceBOMEntryCacheModel.CPInstanceUuid;

		if ((CPInstanceUuid != null) && (CPInstanceUuid.length() == 0)) {
			commerceBOMEntryCacheModel.CPInstanceUuid = null;
		}

		commerceBOMEntryCacheModel.CProductId = getCProductId();

		commerceBOMEntryCacheModel.commerceBOMDefinitionId =
			getCommerceBOMDefinitionId();

		commerceBOMEntryCacheModel.positionX = getPositionX();

		commerceBOMEntryCacheModel.positionY = getPositionY();

		commerceBOMEntryCacheModel.radius = getRadius();

		return commerceBOMEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceBOMEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceBOMEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceBOMEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceBOMEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceBOMEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceBOMEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceBOMEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceBOMEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceBOMEntry>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _commerceBOMEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private int _number;
	private String _CPInstanceUuid;
	private long _CProductId;
	private long _commerceBOMDefinitionId;
	private long _originalCommerceBOMDefinitionId;
	private boolean _setOriginalCommerceBOMDefinitionId;
	private double _positionX;
	private double _positionY;
	private double _radius;
	private long _columnBitmask;
	private CommerceBOMEntry _escapedModel;

}