/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.internal.search;

import com.liferay.commerce.bom.model.CommerceBOMFolder;
import com.liferay.commerce.bom.service.CommerceBOMFolderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceBOMFolderIndexer
extends BaseIndexer<CommerceBOMFolder> {
    public static final String CLASS_NAME = CommerceBOMFolder.class.getName();
    public static final String FIELD_PARENT_COMMERCE_BOM_FOLDER_ID = "parentCommerceBOMFolderId";
    private static final Log _log = LogFactoryUtil.getLog(CommerceBOMFolderIndexer.class);
    @Reference
    private CommerceBOMFolderLocalService _commerceBOMFolderLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long parentCommerceBOMFolderId = GetterUtil.getLong((Object)searchContext.getAttribute(FIELD_PARENT_COMMERCE_BOM_FOLDER_ID));
        contextBooleanFilter.addRequiredTerm(FIELD_PARENT_COMMERCE_BOM_FOLDER_ID, parentCommerceBOMFolderId);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
    }

    protected void doDelete(CommerceBOMFolder commerceBOMFolder) throws Exception {
        this.deleteDocument(commerceBOMFolder.getCompanyId(), commerceBOMFolder.getCommerceBOMFolderId());
    }

    protected Document doGetDocument(CommerceBOMFolder commerceBOMFolder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce BOM folder " + commerceBOMFolder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceBOMFolder);
        document.addText("name", commerceBOMFolder.getName());
        document.addNumber(FIELD_PARENT_COMMERCE_BOM_FOLDER_ID, commerceBOMFolder.getParentCommerceBOMFolderId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceBOMFolder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceBOMFolder commerceBOMFolder) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceBOMFolder.getCompanyId(), this.getDocument(commerceBOMFolder), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceBOMFolderLocalService.getCommerceBOMFolder(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceBOMFolders(companyId);
    }

    protected void reindexCommerceBOMFolders(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceBOMFolderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceBOMFolder -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceBOMFolder)});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce BOM folder " + commerceBOMFolder.getCommerceBOMFolderId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

