/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.bom.service.impl;

import com.liferay.commerce.bom.model.CommerceBOMDefinition;
import com.liferay.commerce.bom.service.base.CommerceBOMDefinitionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import java.util.List;

public class CommerceBOMDefinitionLocalServiceImpl
extends CommerceBOMDefinitionLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public CommerceBOMDefinition addCommerceBOMDefinition(long userId, long commerceBOMFolderId, long cpAttachmentFileEntryId, String name, String friendlyUrl) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceBOMDefinitionId = this.counterLocalService.increment();
        CommerceBOMDefinition commerceBOMDefinition = this.commerceBOMDefinitionPersistence.create(commerceBOMDefinitionId);
        commerceBOMDefinition.setCompanyId(user.getCompanyId());
        commerceBOMDefinition.setUserId(user.getUserId());
        commerceBOMDefinition.setUserName(user.getFullName());
        commerceBOMDefinition.setCommerceBOMFolderId(commerceBOMFolderId);
        commerceBOMDefinition.setCPAttachmentFileEntryId(cpAttachmentFileEntryId);
        commerceBOMDefinition.setName(FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)name));
        commerceBOMDefinition.setFriendlyUrl(friendlyUrl);
        commerceBOMDefinition = (CommerceBOMDefinition)this.commerceBOMDefinitionPersistence.update((BaseModel)commerceBOMDefinition);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), CommerceBOMDefinition.class.getName(), commerceBOMDefinition.getCommerceBOMDefinitionId(), false, false, false);
        return commerceBOMDefinition;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceBOMDefinition deleteCommerceBOMDefinition(CommerceBOMDefinition commerceBOMDefinition) throws PortalException {
        this.resourceLocalService.deleteResource((AuditedModel)commerceBOMDefinition, 4);
        return (CommerceBOMDefinition)this.commerceBOMDefinitionPersistence.remove((BaseModel)commerceBOMDefinition);
    }

    @Override
    public CommerceBOMDefinition deleteCommerceBOMDefinition(long commerceBOMDefinitionId) throws PortalException {
        CommerceBOMDefinition commerceBOMDefinition = this.commerceBOMDefinitionPersistence.findByPrimaryKey(commerceBOMDefinitionId);
        return this.commerceBOMDefinitionLocalService.deleteCommerceBOMDefinition(commerceBOMDefinition);
    }

    public void deleteCommerceBOMDefinitions(long commerceBOMFolderId) throws PortalException {
        List commerceBOMDefinitions = this.commerceBOMDefinitionPersistence.findByCommerceBOMFolderId(commerceBOMFolderId);
        for (CommerceBOMDefinition commerceBOMDefinition : commerceBOMDefinitions) {
            this.commerceBOMDefinitionLocalService.deleteCommerceBOMDefinition(commerceBOMDefinition);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceBOMDefinition updateCommerceBOMDefinition(long commerceBOMDefinitionId, long cpAttachmentFileEntryId, String name) throws PortalException {
        CommerceBOMDefinition commerceBOMDefinition = this.commerceBOMDefinitionLocalService.getCommerceBOMDefinition(commerceBOMDefinitionId);
        commerceBOMDefinition.setCPAttachmentFileEntryId(cpAttachmentFileEntryId);
        commerceBOMDefinition.setName(name);
        return (CommerceBOMDefinition)this.commerceBOMDefinitionPersistence.update((BaseModel)commerceBOMDefinition);
    }
}

