/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.bom.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel;
import com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRelModel;
import com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRelSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceBOMFolderApplicationRel service. Represents a row in the &quot;CBOMFolderApplicationRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceBOMFolderApplicationRelModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMFolderApplicationRelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMFolderApplicationRelImpl
 * @see CommerceBOMFolderApplicationRel
 * @see CommerceBOMFolderApplicationRelModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceBOMFolderApplicationRelModelImpl extends BaseModelImpl<CommerceBOMFolderApplicationRel>
	implements CommerceBOMFolderApplicationRelModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom folder application rel model instance should use the {@link CommerceBOMFolderApplicationRel} interface instead.
	 */
	public static final String TABLE_NAME = "CBOMFolderApplicationRel";
	public static final Object[][] TABLE_COLUMNS = {
			{ "CBOMFolderApplicationRelId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceBOMFolderId", Types.BIGINT },
			{ "commerceApplicationModelId", Types.BIGINT }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CBOMFolderApplicationRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceBOMFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceApplicationModelId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE = "create table CBOMFolderApplicationRel (CBOMFolderApplicationRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceBOMFolderId LONG,commerceApplicationModelId LONG)";
	public static final String TABLE_SQL_DROP = "drop table CBOMFolderApplicationRel";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceBOMFolderApplicationRel.commerceBOMFolderApplicationRelId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CBOMFolderApplicationRel.CBOMFolderApplicationRelId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel"),
			true);
	public static final long COMMERCEAPPLICATIONMODELID_COLUMN_BITMASK = 1L;
	public static final long COMMERCEBOMFOLDERID_COLUMN_BITMASK = 2L;
	public static final long COMMERCEBOMFOLDERAPPLICATIONRELID_COLUMN_BITMASK = 4L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceBOMFolderApplicationRel toModel(
		CommerceBOMFolderApplicationRelSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceBOMFolderApplicationRel model = new CommerceBOMFolderApplicationRelImpl();

		model.setCommerceBOMFolderApplicationRelId(soapModel.getCommerceBOMFolderApplicationRelId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceBOMFolderId(soapModel.getCommerceBOMFolderId());
		model.setCommerceApplicationModelId(soapModel.getCommerceApplicationModelId());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceBOMFolderApplicationRel> toModels(
		CommerceBOMFolderApplicationRelSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceBOMFolderApplicationRel> models = new ArrayList<CommerceBOMFolderApplicationRel>(soapModels.length);

		for (CommerceBOMFolderApplicationRelSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel"));

	public CommerceBOMFolderApplicationRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceBOMFolderApplicationRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceBOMFolderApplicationRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceBOMFolderApplicationRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceBOMFolderApplicationRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceBOMFolderApplicationRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceBOMFolderApplicationRelId",
			getCommerceBOMFolderApplicationRelId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceBOMFolderId", getCommerceBOMFolderId());
		attributes.put("commerceApplicationModelId",
			getCommerceApplicationModelId());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceBOMFolderApplicationRelId = (Long)attributes.get(
				"commerceBOMFolderApplicationRelId");

		if (commerceBOMFolderApplicationRelId != null) {
			setCommerceBOMFolderApplicationRelId(commerceBOMFolderApplicationRelId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceBOMFolderId = (Long)attributes.get("commerceBOMFolderId");

		if (commerceBOMFolderId != null) {
			setCommerceBOMFolderId(commerceBOMFolderId);
		}

		Long commerceApplicationModelId = (Long)attributes.get(
				"commerceApplicationModelId");

		if (commerceApplicationModelId != null) {
			setCommerceApplicationModelId(commerceApplicationModelId);
		}
	}

	@JSON
	@Override
	public long getCommerceBOMFolderApplicationRelId() {
		return _commerceBOMFolderApplicationRelId;
	}

	@Override
	public void setCommerceBOMFolderApplicationRelId(
		long commerceBOMFolderApplicationRelId) {
		_commerceBOMFolderApplicationRelId = commerceBOMFolderApplicationRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceBOMFolderId() {
		return _commerceBOMFolderId;
	}

	@Override
	public void setCommerceBOMFolderId(long commerceBOMFolderId) {
		_columnBitmask |= COMMERCEBOMFOLDERID_COLUMN_BITMASK;

		if (!_setOriginalCommerceBOMFolderId) {
			_setOriginalCommerceBOMFolderId = true;

			_originalCommerceBOMFolderId = _commerceBOMFolderId;
		}

		_commerceBOMFolderId = commerceBOMFolderId;
	}

	public long getOriginalCommerceBOMFolderId() {
		return _originalCommerceBOMFolderId;
	}

	@JSON
	@Override
	public long getCommerceApplicationModelId() {
		return _commerceApplicationModelId;
	}

	@Override
	public void setCommerceApplicationModelId(long commerceApplicationModelId) {
		_columnBitmask |= COMMERCEAPPLICATIONMODELID_COLUMN_BITMASK;

		if (!_setOriginalCommerceApplicationModelId) {
			_setOriginalCommerceApplicationModelId = true;

			_originalCommerceApplicationModelId = _commerceApplicationModelId;
		}

		_commerceApplicationModelId = commerceApplicationModelId;
	}

	public long getOriginalCommerceApplicationModelId() {
		return _originalCommerceApplicationModelId;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceBOMFolderApplicationRel.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceBOMFolderApplicationRel toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceBOMFolderApplicationRel)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceBOMFolderApplicationRelImpl commerceBOMFolderApplicationRelImpl = new CommerceBOMFolderApplicationRelImpl();

		commerceBOMFolderApplicationRelImpl.setCommerceBOMFolderApplicationRelId(getCommerceBOMFolderApplicationRelId());
		commerceBOMFolderApplicationRelImpl.setCompanyId(getCompanyId());
		commerceBOMFolderApplicationRelImpl.setUserId(getUserId());
		commerceBOMFolderApplicationRelImpl.setUserName(getUserName());
		commerceBOMFolderApplicationRelImpl.setCreateDate(getCreateDate());
		commerceBOMFolderApplicationRelImpl.setModifiedDate(getModifiedDate());
		commerceBOMFolderApplicationRelImpl.setCommerceBOMFolderId(getCommerceBOMFolderId());
		commerceBOMFolderApplicationRelImpl.setCommerceApplicationModelId(getCommerceApplicationModelId());

		commerceBOMFolderApplicationRelImpl.resetOriginalValues();

		return commerceBOMFolderApplicationRelImpl;
	}

	@Override
	public int compareTo(
		CommerceBOMFolderApplicationRel commerceBOMFolderApplicationRel) {
		long primaryKey = commerceBOMFolderApplicationRel.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceBOMFolderApplicationRel)) {
			return false;
		}

		CommerceBOMFolderApplicationRel commerceBOMFolderApplicationRel = (CommerceBOMFolderApplicationRel)obj;

		long primaryKey = commerceBOMFolderApplicationRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceBOMFolderApplicationRelModelImpl commerceBOMFolderApplicationRelModelImpl =
			this;

		commerceBOMFolderApplicationRelModelImpl._setModifiedDate = false;

		commerceBOMFolderApplicationRelModelImpl._originalCommerceBOMFolderId = commerceBOMFolderApplicationRelModelImpl._commerceBOMFolderId;

		commerceBOMFolderApplicationRelModelImpl._setOriginalCommerceBOMFolderId = false;

		commerceBOMFolderApplicationRelModelImpl._originalCommerceApplicationModelId = commerceBOMFolderApplicationRelModelImpl._commerceApplicationModelId;

		commerceBOMFolderApplicationRelModelImpl._setOriginalCommerceApplicationModelId = false;

		commerceBOMFolderApplicationRelModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceBOMFolderApplicationRel> toCacheModel() {
		CommerceBOMFolderApplicationRelCacheModel commerceBOMFolderApplicationRelCacheModel =
			new CommerceBOMFolderApplicationRelCacheModel();

		commerceBOMFolderApplicationRelCacheModel.commerceBOMFolderApplicationRelId = getCommerceBOMFolderApplicationRelId();

		commerceBOMFolderApplicationRelCacheModel.companyId = getCompanyId();

		commerceBOMFolderApplicationRelCacheModel.userId = getUserId();

		commerceBOMFolderApplicationRelCacheModel.userName = getUserName();

		String userName = commerceBOMFolderApplicationRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceBOMFolderApplicationRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceBOMFolderApplicationRelCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceBOMFolderApplicationRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceBOMFolderApplicationRelCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceBOMFolderApplicationRelCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceBOMFolderApplicationRelCacheModel.commerceBOMFolderId = getCommerceBOMFolderId();

		commerceBOMFolderApplicationRelCacheModel.commerceApplicationModelId = getCommerceApplicationModelId();

		return commerceBOMFolderApplicationRelCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{commerceBOMFolderApplicationRelId=");
		sb.append(getCommerceBOMFolderApplicationRelId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceBOMFolderId=");
		sb.append(getCommerceBOMFolderId());
		sb.append(", commerceApplicationModelId=");
		sb.append(getCommerceApplicationModelId());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(28);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.bom.model.CommerceBOMFolderApplicationRel");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceBOMFolderApplicationRelId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMFolderApplicationRelId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceBOMFolderId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMFolderId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceApplicationModelId</column-name><column-value><![CDATA[");
		sb.append(getCommerceApplicationModelId());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceBOMFolderApplicationRel.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceBOMFolderApplicationRel.class, ModelWrapper.class
		};
	private long _commerceBOMFolderApplicationRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceBOMFolderId;
	private long _originalCommerceBOMFolderId;
	private boolean _setOriginalCommerceBOMFolderId;
	private long _commerceApplicationModelId;
	private long _originalCommerceApplicationModelId;
	private boolean _setOriginalCommerceApplicationModelId;
	private long _columnBitmask;
	private CommerceBOMFolderApplicationRel _escapedModel;
}