/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.bom.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.bom.model.CommerceBOMEntry;
import com.liferay.commerce.bom.model.CommerceBOMEntryModel;
import com.liferay.commerce.bom.model.CommerceBOMEntrySoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceBOMEntry service. Represents a row in the &quot;CommerceBOMEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceBOMEntryModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMEntryImpl
 * @see CommerceBOMEntry
 * @see CommerceBOMEntryModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceBOMEntryModelImpl extends BaseModelImpl<CommerceBOMEntry>
	implements CommerceBOMEntryModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom entry model instance should use the {@link CommerceBOMEntry} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceBOMEntry";
	public static final Object[][] TABLE_COLUMNS = {
			{ "commerceBOMEntryId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "number_", Types.INTEGER },
			{ "CPInstanceUuid", Types.VARCHAR },
			{ "CProductId", Types.BIGINT },
			{ "commerceBOMDefinitionId", Types.BIGINT },
			{ "positionX", Types.DOUBLE },
			{ "positionY", Types.DOUBLE },
			{ "radius", Types.DOUBLE }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceBOMEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("number_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("CPInstanceUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceBOMDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("positionX", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("positionY", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("radius", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceBOMEntry (commerceBOMEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,number_ INTEGER,CPInstanceUuid VARCHAR(75) null,CProductId LONG,commerceBOMDefinitionId LONG,positionX DOUBLE,positionY DOUBLE,radius DOUBLE)";
	public static final String TABLE_SQL_DROP = "drop table CommerceBOMEntry";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceBOMEntry.number ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceBOMEntry.number_ ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.bom.model.CommerceBOMEntry"),
			true);
	public static final long COMMERCEBOMDEFINITIONID_COLUMN_BITMASK = 1L;
	public static final long NUMBER_COLUMN_BITMASK = 2L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceBOMEntry toModel(CommerceBOMEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceBOMEntry model = new CommerceBOMEntryImpl();

		model.setCommerceBOMEntryId(soapModel.getCommerceBOMEntryId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setNumber(soapModel.getNumber());
		model.setCPInstanceUuid(soapModel.getCPInstanceUuid());
		model.setCProductId(soapModel.getCProductId());
		model.setCommerceBOMDefinitionId(soapModel.getCommerceBOMDefinitionId());
		model.setPositionX(soapModel.getPositionX());
		model.setPositionY(soapModel.getPositionY());
		model.setRadius(soapModel.getRadius());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceBOMEntry> toModels(
		CommerceBOMEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceBOMEntry> models = new ArrayList<CommerceBOMEntry>(soapModels.length);

		for (CommerceBOMEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.bom.model.CommerceBOMEntry"));

	public CommerceBOMEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceBOMEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceBOMEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceBOMEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceBOMEntryId", getCommerceBOMEntryId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("number", getNumber());
		attributes.put("CPInstanceUuid", getCPInstanceUuid());
		attributes.put("CProductId", getCProductId());
		attributes.put("commerceBOMDefinitionId", getCommerceBOMDefinitionId());
		attributes.put("positionX", getPositionX());
		attributes.put("positionY", getPositionY());
		attributes.put("radius", getRadius());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceBOMEntryId = (Long)attributes.get("commerceBOMEntryId");

		if (commerceBOMEntryId != null) {
			setCommerceBOMEntryId(commerceBOMEntryId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Integer number = (Integer)attributes.get("number");

		if (number != null) {
			setNumber(number);
		}

		String CPInstanceUuid = (String)attributes.get("CPInstanceUuid");

		if (CPInstanceUuid != null) {
			setCPInstanceUuid(CPInstanceUuid);
		}

		Long CProductId = (Long)attributes.get("CProductId");

		if (CProductId != null) {
			setCProductId(CProductId);
		}

		Long commerceBOMDefinitionId = (Long)attributes.get(
				"commerceBOMDefinitionId");

		if (commerceBOMDefinitionId != null) {
			setCommerceBOMDefinitionId(commerceBOMDefinitionId);
		}

		Double positionX = (Double)attributes.get("positionX");

		if (positionX != null) {
			setPositionX(positionX);
		}

		Double positionY = (Double)attributes.get("positionY");

		if (positionY != null) {
			setPositionY(positionY);
		}

		Double radius = (Double)attributes.get("radius");

		if (radius != null) {
			setRadius(radius);
		}
	}

	@JSON
	@Override
	public long getCommerceBOMEntryId() {
		return _commerceBOMEntryId;
	}

	@Override
	public void setCommerceBOMEntryId(long commerceBOMEntryId) {
		_commerceBOMEntryId = commerceBOMEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public int getNumber() {
		return _number;
	}

	@Override
	public void setNumber(int number) {
		_columnBitmask = -1L;

		_number = number;
	}

	@JSON
	@Override
	public String getCPInstanceUuid() {
		if (_CPInstanceUuid == null) {
			return "";
		}
		else {
			return _CPInstanceUuid;
		}
	}

	@Override
	public void setCPInstanceUuid(String CPInstanceUuid) {
		_CPInstanceUuid = CPInstanceUuid;
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		_CProductId = CProductId;
	}

	@JSON
	@Override
	public long getCommerceBOMDefinitionId() {
		return _commerceBOMDefinitionId;
	}

	@Override
	public void setCommerceBOMDefinitionId(long commerceBOMDefinitionId) {
		_columnBitmask |= COMMERCEBOMDEFINITIONID_COLUMN_BITMASK;

		if (!_setOriginalCommerceBOMDefinitionId) {
			_setOriginalCommerceBOMDefinitionId = true;

			_originalCommerceBOMDefinitionId = _commerceBOMDefinitionId;
		}

		_commerceBOMDefinitionId = commerceBOMDefinitionId;
	}

	public long getOriginalCommerceBOMDefinitionId() {
		return _originalCommerceBOMDefinitionId;
	}

	@JSON
	@Override
	public double getPositionX() {
		return _positionX;
	}

	@Override
	public void setPositionX(double positionX) {
		_positionX = positionX;
	}

	@JSON
	@Override
	public double getPositionY() {
		return _positionY;
	}

	@Override
	public void setPositionY(double positionY) {
		_positionY = positionY;
	}

	@JSON
	@Override
	public double getRadius() {
		return _radius;
	}

	@Override
	public void setRadius(double radius) {
		_radius = radius;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceBOMEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceBOMEntry toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceBOMEntry)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceBOMEntryImpl commerceBOMEntryImpl = new CommerceBOMEntryImpl();

		commerceBOMEntryImpl.setCommerceBOMEntryId(getCommerceBOMEntryId());
		commerceBOMEntryImpl.setCompanyId(getCompanyId());
		commerceBOMEntryImpl.setUserId(getUserId());
		commerceBOMEntryImpl.setUserName(getUserName());
		commerceBOMEntryImpl.setCreateDate(getCreateDate());
		commerceBOMEntryImpl.setModifiedDate(getModifiedDate());
		commerceBOMEntryImpl.setNumber(getNumber());
		commerceBOMEntryImpl.setCPInstanceUuid(getCPInstanceUuid());
		commerceBOMEntryImpl.setCProductId(getCProductId());
		commerceBOMEntryImpl.setCommerceBOMDefinitionId(getCommerceBOMDefinitionId());
		commerceBOMEntryImpl.setPositionX(getPositionX());
		commerceBOMEntryImpl.setPositionY(getPositionY());
		commerceBOMEntryImpl.setRadius(getRadius());

		commerceBOMEntryImpl.resetOriginalValues();

		return commerceBOMEntryImpl;
	}

	@Override
	public int compareTo(CommerceBOMEntry commerceBOMEntry) {
		int value = 0;

		if (getNumber() < commerceBOMEntry.getNumber()) {
			value = -1;
		}
		else if (getNumber() > commerceBOMEntry.getNumber()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceBOMEntry)) {
			return false;
		}

		CommerceBOMEntry commerceBOMEntry = (CommerceBOMEntry)obj;

		long primaryKey = commerceBOMEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceBOMEntryModelImpl commerceBOMEntryModelImpl = this;

		commerceBOMEntryModelImpl._setModifiedDate = false;

		commerceBOMEntryModelImpl._originalCommerceBOMDefinitionId = commerceBOMEntryModelImpl._commerceBOMDefinitionId;

		commerceBOMEntryModelImpl._setOriginalCommerceBOMDefinitionId = false;

		commerceBOMEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceBOMEntry> toCacheModel() {
		CommerceBOMEntryCacheModel commerceBOMEntryCacheModel = new CommerceBOMEntryCacheModel();

		commerceBOMEntryCacheModel.commerceBOMEntryId = getCommerceBOMEntryId();

		commerceBOMEntryCacheModel.companyId = getCompanyId();

		commerceBOMEntryCacheModel.userId = getUserId();

		commerceBOMEntryCacheModel.userName = getUserName();

		String userName = commerceBOMEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceBOMEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceBOMEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceBOMEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceBOMEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceBOMEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceBOMEntryCacheModel.number = getNumber();

		commerceBOMEntryCacheModel.CPInstanceUuid = getCPInstanceUuid();

		String CPInstanceUuid = commerceBOMEntryCacheModel.CPInstanceUuid;

		if ((CPInstanceUuid != null) && (CPInstanceUuid.length() == 0)) {
			commerceBOMEntryCacheModel.CPInstanceUuid = null;
		}

		commerceBOMEntryCacheModel.CProductId = getCProductId();

		commerceBOMEntryCacheModel.commerceBOMDefinitionId = getCommerceBOMDefinitionId();

		commerceBOMEntryCacheModel.positionX = getPositionX();

		commerceBOMEntryCacheModel.positionY = getPositionY();

		commerceBOMEntryCacheModel.radius = getRadius();

		return commerceBOMEntryCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(27);

		sb.append("{commerceBOMEntryId=");
		sb.append(getCommerceBOMEntryId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", number=");
		sb.append(getNumber());
		sb.append(", CPInstanceUuid=");
		sb.append(getCPInstanceUuid());
		sb.append(", CProductId=");
		sb.append(getCProductId());
		sb.append(", commerceBOMDefinitionId=");
		sb.append(getCommerceBOMDefinitionId());
		sb.append(", positionX=");
		sb.append(getPositionX());
		sb.append(", positionY=");
		sb.append(getPositionY());
		sb.append(", radius=");
		sb.append(getRadius());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(43);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.bom.model.CommerceBOMEntry");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceBOMEntryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>number</column-name><column-value><![CDATA[");
		sb.append(getNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>CPInstanceUuid</column-name><column-value><![CDATA[");
		sb.append(getCPInstanceUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>CProductId</column-name><column-value><![CDATA[");
		sb.append(getCProductId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceBOMDefinitionId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMDefinitionId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>positionX</column-name><column-value><![CDATA[");
		sb.append(getPositionX());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>positionY</column-name><column-value><![CDATA[");
		sb.append(getPositionY());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>radius</column-name><column-value><![CDATA[");
		sb.append(getRadius());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceBOMEntry.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceBOMEntry.class, ModelWrapper.class
		};
	private long _commerceBOMEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private int _number;
	private String _CPInstanceUuid;
	private long _CProductId;
	private long _commerceBOMDefinitionId;
	private long _originalCommerceBOMDefinitionId;
	private boolean _setOriginalCommerceBOMDefinitionId;
	private double _positionX;
	private double _positionY;
	private double _radius;
	private long _columnBitmask;
	private CommerceBOMEntry _escapedModel;
}