/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.bom.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.bom.model.CommerceBOMEntry;
import com.liferay.commerce.bom.service.CommerceBOMEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceBOMEntry service. Represents a row in the &quot;CommerceBOMEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMEntryImpl
 * @see CommerceBOMEntry
 * @generated
 */
@ProviderType
public abstract class CommerceBOMEntryBaseImpl extends CommerceBOMEntryModelImpl
	implements CommerceBOMEntry {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom entry model instance should use the {@link CommerceBOMEntry} interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceBOMEntryLocalServiceUtil.addCommerceBOMEntry(this);
		}
		else {
			CommerceBOMEntryLocalServiceUtil.updateCommerceBOMEntry(this);
		}
	}
}