/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.bom.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.bom.model.CommerceBOMDefinition;
import com.liferay.commerce.bom.model.CommerceBOMDefinitionModel;
import com.liferay.commerce.bom.model.CommerceBOMDefinitionSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceBOMDefinition service. Represents a row in the &quot;CommerceBOMDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceBOMDefinitionModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceBOMDefinitionImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMDefinitionImpl
 * @see CommerceBOMDefinition
 * @see CommerceBOMDefinitionModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceBOMDefinitionModelImpl extends BaseModelImpl<CommerceBOMDefinition>
	implements CommerceBOMDefinitionModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce bom definition model instance should use the {@link CommerceBOMDefinition} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceBOMDefinition";
	public static final Object[][] TABLE_COLUMNS = {
			{ "commerceBOMDefinitionId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceBOMFolderId", Types.BIGINT },
			{ "CPAttachmentFileEntryId", Types.BIGINT },
			{ "name", Types.VARCHAR },
			{ "friendlyUrl", Types.VARCHAR }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceBOMDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceBOMFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPAttachmentFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("friendlyUrl", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceBOMDefinition (commerceBOMDefinitionId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceBOMFolderId LONG,CPAttachmentFileEntryId LONG,name VARCHAR(75) null,friendlyUrl VARCHAR(75) null)";
	public static final String TABLE_SQL_DROP = "drop table CommerceBOMDefinition";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceBOMDefinition.name ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceBOMDefinition.name ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMDefinition"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.bom.model.CommerceBOMDefinition"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.bom.model.CommerceBOMDefinition"),
			true);
	public static final long COMMERCEBOMFOLDERID_COLUMN_BITMASK = 1L;
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceBOMDefinition toModel(
		CommerceBOMDefinitionSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceBOMDefinition model = new CommerceBOMDefinitionImpl();

		model.setCommerceBOMDefinitionId(soapModel.getCommerceBOMDefinitionId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceBOMFolderId(soapModel.getCommerceBOMFolderId());
		model.setCPAttachmentFileEntryId(soapModel.getCPAttachmentFileEntryId());
		model.setName(soapModel.getName());
		model.setFriendlyUrl(soapModel.getFriendlyUrl());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceBOMDefinition> toModels(
		CommerceBOMDefinitionSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceBOMDefinition> models = new ArrayList<CommerceBOMDefinition>(soapModels.length);

		for (CommerceBOMDefinitionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.bom.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.bom.model.CommerceBOMDefinition"));

	public CommerceBOMDefinitionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceBOMDefinitionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceBOMDefinitionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceBOMDefinitionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceBOMDefinition.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceBOMDefinition.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceBOMDefinitionId", getCommerceBOMDefinitionId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceBOMFolderId", getCommerceBOMFolderId());
		attributes.put("CPAttachmentFileEntryId", getCPAttachmentFileEntryId());
		attributes.put("name", getName());
		attributes.put("friendlyUrl", getFriendlyUrl());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceBOMDefinitionId = (Long)attributes.get(
				"commerceBOMDefinitionId");

		if (commerceBOMDefinitionId != null) {
			setCommerceBOMDefinitionId(commerceBOMDefinitionId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceBOMFolderId = (Long)attributes.get("commerceBOMFolderId");

		if (commerceBOMFolderId != null) {
			setCommerceBOMFolderId(commerceBOMFolderId);
		}

		Long CPAttachmentFileEntryId = (Long)attributes.get(
				"CPAttachmentFileEntryId");

		if (CPAttachmentFileEntryId != null) {
			setCPAttachmentFileEntryId(CPAttachmentFileEntryId);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String friendlyUrl = (String)attributes.get("friendlyUrl");

		if (friendlyUrl != null) {
			setFriendlyUrl(friendlyUrl);
		}
	}

	@JSON
	@Override
	public long getCommerceBOMDefinitionId() {
		return _commerceBOMDefinitionId;
	}

	@Override
	public void setCommerceBOMDefinitionId(long commerceBOMDefinitionId) {
		_commerceBOMDefinitionId = commerceBOMDefinitionId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceBOMFolderId() {
		return _commerceBOMFolderId;
	}

	@Override
	public void setCommerceBOMFolderId(long commerceBOMFolderId) {
		_columnBitmask |= COMMERCEBOMFOLDERID_COLUMN_BITMASK;

		if (!_setOriginalCommerceBOMFolderId) {
			_setOriginalCommerceBOMFolderId = true;

			_originalCommerceBOMFolderId = _commerceBOMFolderId;
		}

		_commerceBOMFolderId = commerceBOMFolderId;
	}

	public long getOriginalCommerceBOMFolderId() {
		return _originalCommerceBOMFolderId;
	}

	@JSON
	@Override
	public long getCPAttachmentFileEntryId() {
		return _CPAttachmentFileEntryId;
	}

	@Override
	public void setCPAttachmentFileEntryId(long CPAttachmentFileEntryId) {
		_CPAttachmentFileEntryId = CPAttachmentFileEntryId;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		_name = name;
	}

	@JSON
	@Override
	public String getFriendlyUrl() {
		if (_friendlyUrl == null) {
			return "";
		}
		else {
			return _friendlyUrl;
		}
	}

	@Override
	public void setFriendlyUrl(String friendlyUrl) {
		_friendlyUrl = friendlyUrl;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceBOMDefinition.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceBOMDefinition toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceBOMDefinition)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceBOMDefinitionImpl commerceBOMDefinitionImpl = new CommerceBOMDefinitionImpl();

		commerceBOMDefinitionImpl.setCommerceBOMDefinitionId(getCommerceBOMDefinitionId());
		commerceBOMDefinitionImpl.setCompanyId(getCompanyId());
		commerceBOMDefinitionImpl.setUserId(getUserId());
		commerceBOMDefinitionImpl.setUserName(getUserName());
		commerceBOMDefinitionImpl.setCreateDate(getCreateDate());
		commerceBOMDefinitionImpl.setModifiedDate(getModifiedDate());
		commerceBOMDefinitionImpl.setCommerceBOMFolderId(getCommerceBOMFolderId());
		commerceBOMDefinitionImpl.setCPAttachmentFileEntryId(getCPAttachmentFileEntryId());
		commerceBOMDefinitionImpl.setName(getName());
		commerceBOMDefinitionImpl.setFriendlyUrl(getFriendlyUrl());

		commerceBOMDefinitionImpl.resetOriginalValues();

		return commerceBOMDefinitionImpl;
	}

	@Override
	public int compareTo(CommerceBOMDefinition commerceBOMDefinition) {
		int value = 0;

		value = getName().compareTo(commerceBOMDefinition.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceBOMDefinition)) {
			return false;
		}

		CommerceBOMDefinition commerceBOMDefinition = (CommerceBOMDefinition)obj;

		long primaryKey = commerceBOMDefinition.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceBOMDefinitionModelImpl commerceBOMDefinitionModelImpl = this;

		commerceBOMDefinitionModelImpl._setModifiedDate = false;

		commerceBOMDefinitionModelImpl._originalCommerceBOMFolderId = commerceBOMDefinitionModelImpl._commerceBOMFolderId;

		commerceBOMDefinitionModelImpl._setOriginalCommerceBOMFolderId = false;

		commerceBOMDefinitionModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceBOMDefinition> toCacheModel() {
		CommerceBOMDefinitionCacheModel commerceBOMDefinitionCacheModel = new CommerceBOMDefinitionCacheModel();

		commerceBOMDefinitionCacheModel.commerceBOMDefinitionId = getCommerceBOMDefinitionId();

		commerceBOMDefinitionCacheModel.companyId = getCompanyId();

		commerceBOMDefinitionCacheModel.userId = getUserId();

		commerceBOMDefinitionCacheModel.userName = getUserName();

		String userName = commerceBOMDefinitionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceBOMDefinitionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceBOMDefinitionCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceBOMDefinitionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceBOMDefinitionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceBOMDefinitionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceBOMDefinitionCacheModel.commerceBOMFolderId = getCommerceBOMFolderId();

		commerceBOMDefinitionCacheModel.CPAttachmentFileEntryId = getCPAttachmentFileEntryId();

		commerceBOMDefinitionCacheModel.name = getName();

		String name = commerceBOMDefinitionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceBOMDefinitionCacheModel.name = null;
		}

		commerceBOMDefinitionCacheModel.friendlyUrl = getFriendlyUrl();

		String friendlyUrl = commerceBOMDefinitionCacheModel.friendlyUrl;

		if ((friendlyUrl != null) && (friendlyUrl.length() == 0)) {
			commerceBOMDefinitionCacheModel.friendlyUrl = null;
		}

		return commerceBOMDefinitionCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(21);

		sb.append("{commerceBOMDefinitionId=");
		sb.append(getCommerceBOMDefinitionId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceBOMFolderId=");
		sb.append(getCommerceBOMFolderId());
		sb.append(", CPAttachmentFileEntryId=");
		sb.append(getCPAttachmentFileEntryId());
		sb.append(", name=");
		sb.append(getName());
		sb.append(", friendlyUrl=");
		sb.append(getFriendlyUrl());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(34);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.bom.model.CommerceBOMDefinition");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceBOMDefinitionId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMDefinitionId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceBOMFolderId</column-name><column-value><![CDATA[");
		sb.append(getCommerceBOMFolderId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>CPAttachmentFileEntryId</column-name><column-value><![CDATA[");
		sb.append(getCPAttachmentFileEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>name</column-name><column-value><![CDATA[");
		sb.append(getName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>friendlyUrl</column-name><column-value><![CDATA[");
		sb.append(getFriendlyUrl());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceBOMDefinition.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceBOMDefinition.class, ModelWrapper.class
		};
	private long _commerceBOMDefinitionId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceBOMFolderId;
	private long _originalCommerceBOMFolderId;
	private boolean _setOriginalCommerceBOMFolderId;
	private long _CPAttachmentFileEntryId;
	private String _name;
	private String _friendlyUrl;
	private long _columnBitmask;
	private CommerceBOMDefinition _escapedModel;
}