/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.application.model.impl;

import com.liferay.commerce.application.model.CommerceApplicationModel;
import com.liferay.commerce.application.service.CommerceApplicationModelLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceApplicationModel service. Represents a row in the &quot;CommerceApplicationModel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceApplicationModelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceApplicationModelImpl
 * @see CommerceApplicationModel
 * @generated
 */
public abstract class CommerceApplicationModelBaseImpl
	extends CommerceApplicationModelModelImpl
	implements CommerceApplicationModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce application model model instance should use the <code>CommerceApplicationModel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceApplicationModelLocalServiceUtil.
				addCommerceApplicationModel(this);
		}
		else {
			CommerceApplicationModelLocalServiceUtil.
				updateCommerceApplicationModel(this);
		}
	}

}