/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.application.model.impl;

import aQute.bnd.annotation.ProviderType;

/**
 * The extended model implementation for the CommerceApplicationModel service. Represents a row in the &quot;CommerceApplicationModel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * Helper methods and all application logic should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link com.liferay.commerce.application.model.CommerceApplicationModel} interface.
 * </p>
 *
 * @author Luca Pellizzon
 */
@ProviderType
public class CommerceApplicationModelImpl
	extends CommerceApplicationModelBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this class directly. All methods that expect a commerce application model model instance should use the {@link com.liferay.commerce.application.model.CommerceApplicationModel} interface instead.
	 */
	public CommerceApplicationModelImpl() {
	}
}