/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.application.model.impl;

import com.liferay.commerce.application.model.CommerceApplicationModelCProductRel;
import com.liferay.commerce.application.service.CommerceApplicationModelCProductRelLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceApplicationModelCProductRel service. Represents a row in the &quot;CAModelCProductRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceApplicationModelCProductRelImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceApplicationModelCProductRelImpl
 * @see CommerceApplicationModelCProductRel
 * @generated
 */
public abstract class CommerceApplicationModelCProductRelBaseImpl
	extends CommerceApplicationModelCProductRelModelImpl
	implements CommerceApplicationModelCProductRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce application model c product rel model instance should use the <code>CommerceApplicationModelCProductRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceApplicationModelCProductRelLocalServiceUtil.
				addCommerceApplicationModelCProductRel(this);
		}
		else {
			CommerceApplicationModelCProductRelLocalServiceUtil.
				updateCommerceApplicationModelCProductRel(this);
		}
	}

}