/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.application.internal.permission;

import com.liferay.commerce.application.model.CommerceApplicationBrand;
import com.liferay.commerce.application.permission.CommerceApplicationBrandPermission;
import com.liferay.commerce.application.service.CommerceApplicationBrandLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceApplicationBrandPermission.class})
public class CommerceApplicationBrandPermissionImpl
implements CommerceApplicationBrandPermission {
    @Reference
    private CommerceApplicationBrandLocalService _commerceApplicationBrandLocalService;

    public void check(PermissionChecker permissionChecker, CommerceApplicationBrand commerceApplicationBrand, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceApplicationBrand, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceApplicationBrand.class.getName(), commerceApplicationBrand.getCommerceApplicationBrandId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceApplicationBrandId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceApplicationBrandId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceApplicationBrand.class.getName(), commerceApplicationBrandId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceApplicationBrand commerceApplicationBrand, String actionId) {
        return this.contains(permissionChecker, commerceApplicationBrand.getCommerceApplicationBrandId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceApplicationBrandId, String actionId) {
        CommerceApplicationBrand commerceApplicationBrand = this._commerceApplicationBrandLocalService.fetchCommerceApplicationBrand(commerceApplicationBrandId);
        if (commerceApplicationBrand == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceApplicationBrand, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceApplicationBrandIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceApplicationBrandIds)) {
            return false;
        }
        for (long commerceApplicationBrandId : commerceApplicationBrandIds) {
            if (this.contains(permissionChecker, commerceApplicationBrandId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceApplicationBrand commerceApplicationBrand, String actionId) {
        if (permissionChecker.isCompanyAdmin(commerceApplicationBrand.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceApplicationBrand.class.getName(), commerceApplicationBrand.getCommerceApplicationBrandId(), permissionChecker.getUserId(), actionId) && commerceApplicationBrand.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceApplicationBrand.class.getName(), commerceApplicationBrand.getCommerceApplicationBrandId(), actionId);
    }
}

