/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.application.service.impl;

import com.liferay.commerce.application.model.CommerceApplicationBrand;
import com.liferay.commerce.application.service.base.CommerceApplicationBrandLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.util.List;

public class CommerceApplicationBrandLocalServiceImpl
extends CommerceApplicationBrandLocalServiceBaseImpl {
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = (UserFileUploadsSettings)ProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, CommerceApplicationBrandLocalServiceImpl.class, (String)"_userFileUploadsSettings");
    @ServiceReference(type=Portal.class)
    private Portal _portal;

    public CommerceApplicationBrand addCommerceApplicationBrand(long userId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceBOMDefinitionId = this.counterLocalService.increment();
        CommerceApplicationBrand commerceApplicationBrand = this.commerceApplicationBrandPersistence.create(commerceBOMDefinitionId);
        commerceApplicationBrand.setCompanyId(user.getCompanyId());
        commerceApplicationBrand.setUserId(user.getUserId());
        commerceApplicationBrand.setUserName(user.getFullName());
        commerceApplicationBrand.setName(name);
        this._portal.updateImageId((BaseModel)commerceApplicationBrand, logo, logoBytes, "logoId", _userFileUploadsSettings.getImageMaxSize(), _userFileUploadsSettings.getImageMaxHeight(), _userFileUploadsSettings.getImageMaxWidth());
        commerceApplicationBrand = (CommerceApplicationBrand)this.commerceApplicationBrandPersistence.update((BaseModel)commerceApplicationBrand);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), CommerceApplicationBrand.class.getName(), commerceApplicationBrand.getCommerceApplicationBrandId(), false, false, false);
        return commerceApplicationBrand;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceApplicationBrand deleteCommerceApplicationBrand(CommerceApplicationBrand commerceApplicationBrand) throws PortalException {
        this.commerceApplicationModelLocalService.deleteCommerceApplicationModels(commerceApplicationBrand.getCommerceApplicationBrandId());
        this.resourceLocalService.deleteResource((AuditedModel)commerceApplicationBrand, 4);
        return (CommerceApplicationBrand)this.commerceApplicationBrandPersistence.remove((BaseModel)commerceApplicationBrand);
    }

    @Override
    public CommerceApplicationBrand deleteCommerceApplicationBrand(long commerceApplicationBrandId) throws PortalException {
        CommerceApplicationBrand commerceApplicationBrand = this.commerceApplicationBrandPersistence.findByPrimaryKey(commerceApplicationBrandId);
        return this.commerceApplicationBrandLocalService.deleteCommerceApplicationBrand(commerceApplicationBrand);
    }

    public void deleteCommerceApplicationBrands(long companyId) throws PortalException {
        List commerceApplicationBrands = this.commerceApplicationBrandPersistence.findByCompanyId(companyId);
        for (CommerceApplicationBrand commerceApplicationBrand : commerceApplicationBrands) {
            this.commerceApplicationBrandLocalService.deleteCommerceApplicationBrand(commerceApplicationBrand);
        }
    }

    public CommerceApplicationBrand updateCommerceApplicationBrand(long commerceApplicationBrandId, String name, boolean logo, byte[] logoBytes) throws PortalException {
        CommerceApplicationBrand commerceApplicationBrand = this.commerceApplicationBrandLocalService.getCommerceApplicationBrand(commerceApplicationBrandId);
        commerceApplicationBrand.setName(name);
        this._portal.updateImageId((BaseModel)commerceApplicationBrand, logo, logoBytes, "logoId", _userFileUploadsSettings.getImageMaxSize(), _userFileUploadsSettings.getImageMaxHeight(), _userFileUploadsSettings.getImageMaxWidth());
        return (CommerceApplicationBrand)this.commerceApplicationBrandPersistence.update((BaseModel)commerceApplicationBrand);
    }
}

