/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.application.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.application.model.CommerceApplicationBrand;
import com.liferay.commerce.application.model.CommerceApplicationBrandModel;
import com.liferay.commerce.application.model.CommerceApplicationBrandSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceApplicationBrand service. Represents a row in the &quot;CommerceApplicationBrand&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceApplicationBrandModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceApplicationBrandImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceApplicationBrandImpl
 * @see CommerceApplicationBrand
 * @see CommerceApplicationBrandModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceApplicationBrandModelImpl extends BaseModelImpl<CommerceApplicationBrand>
	implements CommerceApplicationBrandModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce application brand model instance should use the {@link CommerceApplicationBrand} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceApplicationBrand";
	public static final Object[][] TABLE_COLUMNS = {
			{ "commerceApplicationBrandId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "name", Types.VARCHAR },
			{ "logoId", Types.BIGINT }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceApplicationBrandId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("logoId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceApplicationBrand (commerceApplicationBrandId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,logoId LONG)";
	public static final String TABLE_SQL_DROP = "drop table CommerceApplicationBrand";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceApplicationBrand.name ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceApplicationBrand.name ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.application.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.application.model.CommerceApplicationBrand"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.application.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.application.model.CommerceApplicationBrand"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.application.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.application.model.CommerceApplicationBrand"),
			true);
	public static final long COMPANYID_COLUMN_BITMASK = 1L;
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceApplicationBrand toModel(
		CommerceApplicationBrandSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceApplicationBrand model = new CommerceApplicationBrandImpl();

		model.setCommerceApplicationBrandId(soapModel.getCommerceApplicationBrandId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setName(soapModel.getName());
		model.setLogoId(soapModel.getLogoId());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceApplicationBrand> toModels(
		CommerceApplicationBrandSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceApplicationBrand> models = new ArrayList<CommerceApplicationBrand>(soapModels.length);

		for (CommerceApplicationBrandSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.application.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.application.model.CommerceApplicationBrand"));

	public CommerceApplicationBrandModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceApplicationBrandId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceApplicationBrandId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceApplicationBrandId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceApplicationBrand.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceApplicationBrand.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceApplicationBrandId",
			getCommerceApplicationBrandId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("name", getName());
		attributes.put("logoId", getLogoId());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceApplicationBrandId = (Long)attributes.get(
				"commerceApplicationBrandId");

		if (commerceApplicationBrandId != null) {
			setCommerceApplicationBrandId(commerceApplicationBrandId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		Long logoId = (Long)attributes.get("logoId");

		if (logoId != null) {
			setLogoId(logoId);
		}
	}

	@JSON
	@Override
	public long getCommerceApplicationBrandId() {
		return _commerceApplicationBrandId;
	}

	@Override
	public void setCommerceApplicationBrandId(long commerceApplicationBrandId) {
		_commerceApplicationBrandId = commerceApplicationBrandId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		_name = name;
	}

	@JSON
	@Override
	public long getLogoId() {
		return _logoId;
	}

	@Override
	public void setLogoId(long logoId) {
		_logoId = logoId;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceApplicationBrand.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceApplicationBrand toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceApplicationBrand)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceApplicationBrandImpl commerceApplicationBrandImpl = new CommerceApplicationBrandImpl();

		commerceApplicationBrandImpl.setCommerceApplicationBrandId(getCommerceApplicationBrandId());
		commerceApplicationBrandImpl.setCompanyId(getCompanyId());
		commerceApplicationBrandImpl.setUserId(getUserId());
		commerceApplicationBrandImpl.setUserName(getUserName());
		commerceApplicationBrandImpl.setCreateDate(getCreateDate());
		commerceApplicationBrandImpl.setModifiedDate(getModifiedDate());
		commerceApplicationBrandImpl.setName(getName());
		commerceApplicationBrandImpl.setLogoId(getLogoId());

		commerceApplicationBrandImpl.resetOriginalValues();

		return commerceApplicationBrandImpl;
	}

	@Override
	public int compareTo(CommerceApplicationBrand commerceApplicationBrand) {
		int value = 0;

		value = getName().compareTo(commerceApplicationBrand.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceApplicationBrand)) {
			return false;
		}

		CommerceApplicationBrand commerceApplicationBrand = (CommerceApplicationBrand)obj;

		long primaryKey = commerceApplicationBrand.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceApplicationBrandModelImpl commerceApplicationBrandModelImpl = this;

		commerceApplicationBrandModelImpl._originalCompanyId = commerceApplicationBrandModelImpl._companyId;

		commerceApplicationBrandModelImpl._setOriginalCompanyId = false;

		commerceApplicationBrandModelImpl._setModifiedDate = false;

		commerceApplicationBrandModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceApplicationBrand> toCacheModel() {
		CommerceApplicationBrandCacheModel commerceApplicationBrandCacheModel = new CommerceApplicationBrandCacheModel();

		commerceApplicationBrandCacheModel.commerceApplicationBrandId = getCommerceApplicationBrandId();

		commerceApplicationBrandCacheModel.companyId = getCompanyId();

		commerceApplicationBrandCacheModel.userId = getUserId();

		commerceApplicationBrandCacheModel.userName = getUserName();

		String userName = commerceApplicationBrandCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceApplicationBrandCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceApplicationBrandCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceApplicationBrandCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceApplicationBrandCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceApplicationBrandCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceApplicationBrandCacheModel.name = getName();

		String name = commerceApplicationBrandCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceApplicationBrandCacheModel.name = null;
		}

		commerceApplicationBrandCacheModel.logoId = getLogoId();

		return commerceApplicationBrandCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(17);

		sb.append("{commerceApplicationBrandId=");
		sb.append(getCommerceApplicationBrandId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", name=");
		sb.append(getName());
		sb.append(", logoId=");
		sb.append(getLogoId());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(28);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.application.model.CommerceApplicationBrand");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceApplicationBrandId</column-name><column-value><![CDATA[");
		sb.append(getCommerceApplicationBrandId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>name</column-name><column-value><![CDATA[");
		sb.append(getName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>logoId</column-name><column-value><![CDATA[");
		sb.append(getLogoId());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceApplicationBrand.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceApplicationBrand.class, ModelWrapper.class
		};
	private long _commerceApplicationBrandId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private long _logoId;
	private long _columnBitmask;
	private CommerceApplicationBrand _escapedModel;
}