/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml.dsig;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.KeyInfo;
import com.rsa.certj.xml.NodeListImpl;
import com.rsa.certj.xml.ParserHandler;
import com.rsa.certj.xml.Transformer;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.dsig.Reference;
import com.rsa.certj.xml.dsig.VerificationInfo;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLSignature
implements Cloneable,
Serializable {
    public static final int SIGNATURE_MASK = 14;
    public static final int DETACHED_SIGNATURE = 8;
    public static final int ENVELOPING_SIGNATURE = 4;
    public static final int ENVELOPED_SIGNATURE = 2;
    public static final String DEFAULT_DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String DEFAULT_MAC_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String DSA_SIGNATURE_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String RSA_SIGNATURE_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String[] SUPPORTED_MAC_ALGORITHMS;
    public static final String[] SUPPORTED_SIGNATURE_ALGORITHMS;
    public static final String DEFAULT_XML_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String[] SUPPORTED_XML_NAMESPACES;
    public static final String[] SUPPORTED_DIGEST_ALGORITHMS;
    private int a;
    private String b;
    private String c;
    private Vector d = null;
    private Vector e = null;
    private Vector f = null;
    private String g;
    private String h;
    private Certificate[] i = null;
    private int j = -1;
    private JSAFE_PublicKey k = null;
    private byte[] l = null;
    private Node m = null;
    private Document n = null;
    private Node o = null;
    private Element p = null;
    private int q;
    private String r;
    private int s = 0;
    public boolean useTemplate = false;
    protected boolean commentXPointer = false;
    public boolean foundET = false;

    public XMLSignature() {
    }

    public XMLSignature(String string) throws XMLException {
        if (string == null) {
            throw new XMLException("Can't read file: file is null");
        }
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                throw new XMLException("Can't intialize the XMLSignature object:\n" + malformedURLException.getMessage() + "\n or " + iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new XMLException("Can't initialize the XMLSignature object:\n" + iOException.getMessage());
        }
        this.a(new InputSource(inputStream));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLException("Can't initialize the XMLSignature object:\n" + iOException.getMessage());
        }
    }

    private void a(InputSource inputSource) throws XMLException {
        try {
            if (ParserHandler.SYSTEM_ID != null) {
                inputSource.setSystemId(ParserHandler.SYSTEM_ID);
            }
            if (ParserHandler.PUBLIC_ID != null) {
                inputSource.setPublicId(ParserHandler.PUBLIC_ID);
            }
            this.n = ParserHandler.parseXML(inputSource);
            this.o = this.n;
        }
        catch (Exception exception) {
            throw new XMLException("Can't parse the XML document\n" + exception.getMessage());
        }
    }

    public XMLSignature(File file) throws XMLException {
        if (file == null) {
            throw new XMLException("Can't read file: file is null");
        }
        InputSource inputSource = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            inputSource = new InputSource(fileInputStream);
        }
        catch (IOException iOException) {
            throw new XMLException("Can't intialize the XMLSignature object:\n" + iOException.getMessage());
        }
        this.a(inputSource);
    }

    public XMLSignature(InputStream inputStream) throws XMLException {
        if (inputStream == null) {
            throw new XMLException("Can't read inputStream: inputStream is null");
        }
        InputSource inputSource = new InputSource(inputStream);
        this.a(inputSource);
    }

    protected Node getOriginalDataNode() {
        return this.o;
    }

    protected void setOriginalDataNode(Node node) {
        this.o = node;
    }

    public void setSignedInfo(Node node) {
        this.m = node;
    }

    protected Node getSignedInfo() {
        return this.m;
    }

    public void setSignatureType(int n) {
        this.a = n;
    }

    public int getSignatureType() {
        return this.a;
    }

    public void setSignatureID(String string) {
        this.b = string;
    }

    public String getSignatureID() {
        return this.b;
    }

    public void setNamespacePrefix(String string) {
        if (!this.useTemplate) {
            this.c = string;
        }
    }

    public String getNamespacePrefix() {
        return this.c;
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray != null) {
            this.i = new Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                this.i[i] = certificateArray[i];
            }
        }
    }

    public void setKey(JSAFE_PublicKey jSAFE_PublicKey) {
        this.k = jSAFE_PublicKey;
    }

    public void addReference(Reference reference) {
        if (reference != null) {
            if (this.d == null) {
                this.d = new Vector();
            }
            this.d.addElement(reference);
        }
    }

    public void setReferences(Reference[] referenceArray) {
        if (referenceArray != null) {
            if (this.d == null) {
                this.d = new Vector(referenceArray.length);
            } else {
                this.d.ensureCapacity(referenceArray.length);
                this.d.removeAllElements();
            }
            for (int i = 0; i < referenceArray.length; ++i) {
                this.d.addElement(referenceArray[i]);
            }
        }
    }

    public Reference[] getReferences() {
        Object[] objectArray = null;
        if (this.d != null) {
            objectArray = new Reference[this.d.size()];
            this.d.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setHMACOutputLen(int n) {
        this.q = n;
    }

    public int getHMACOutputLen() {
        return this.q;
    }

    public void setKeyInfos(KeyInfo[] keyInfoArray) {
        if (keyInfoArray != null) {
            if (this.f == null) {
                this.f = new Vector(keyInfoArray.length);
            } else {
                this.f.removeAllElements();
            }
            for (int i = 0; i < keyInfoArray.length; ++i) {
                this.f.addElement(keyInfoArray[i]);
            }
        }
    }

    public void addKeyInfo(KeyInfo keyInfo) {
        if (this.f == null) {
            this.f = new Vector();
        }
        this.f.addElement(keyInfo);
    }

    public KeyInfo[] getKeyInfos() {
        Object[] objectArray = null;
        if (this.f != null) {
            objectArray = new KeyInfo[this.f.size()];
            this.f.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setSignatureMethod(String string) throws XMLException {
        if (string != null) {
            for (int i = 0; i < SUPPORTED_SIGNATURE_ALGORITHMS.length; ++i) {
                if (!string.equals(SUPPORTED_SIGNATURE_ALGORITHMS[i])) continue;
                this.h = string;
                if (this.r == null) {
                    this.r = string.substring(0, string.indexOf("#") + 1);
                }
                return;
            }
            throw new XMLException("Unsupported signature method");
        }
    }

    public String getSignatureMethod() {
        return this.h;
    }

    public void setCanonicalizationMethod(String string) throws XMLException {
        if (string != null) {
            int n;
            for (n = 0; n < Transformer.C14N_LIST.length; ++n) {
                if (!string.equals(Transformer.C14N_LIST[n])) continue;
                this.g = string;
                return;
            }
            for (n = 0; n < Transformer.C14N_WITH_COMMENTS_LIST.length; ++n) {
                if (!string.equals(Transformer.C14N_WITH_COMMENTS_LIST[n])) continue;
                this.g = string;
                return;
            }
            throw new XMLException("Not supported canonicalization aglorithm");
        }
    }

    public String getCanonicalizationMethod() {
        return this.g;
    }

    public void setSignatureValue(byte[] byArray) {
        if (byArray != null) {
            this.l = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.l, 0, byArray.length);
        }
    }

    public byte[] getSignatureValue() {
        return this.l;
    }

    public void setXMLObjects(Element[] elementArray) {
        if (elementArray != null) {
            if (this.e == null) {
                this.e = new Vector(elementArray.length);
            } else {
                this.e.removeAllElements();
            }
            for (int i = 0; i < elementArray.length; ++i) {
                this.e.addElement(elementArray[i]);
            }
        }
    }

    public void addXMLObject(Element element) {
        if (this.e == null) {
            this.e = new Vector();
        }
        this.e.addElement(element);
    }

    public Element[] getXMLObjects() {
        Object[] objectArray = null;
        if (this.e != null) {
            objectArray = new Element[this.e.size()];
            this.e.copyInto(objectArray);
        }
        return objectArray;
    }

    public Element getXMLObjectByID(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        if (this.e != null) {
            for (n = 0; n < this.e.size(); ++n) {
                if (this.e.elementAt(n) == null || !((Element)this.e.elementAt(n)).getAttribute("Id").equals(string)) continue;
                return (Element)this.e.elementAt(n);
            }
            return null;
        }
        return null;
    }

    public void includeCommentsForXPointer(boolean bl) {
        this.commentXPointer = bl;
    }

    public void sign(CertJ certJ) throws XMLException {
        if (certJ == null) {
            throw new XMLException("Can't sign the document: certj is null");
        }
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            if (this.i == null || this.k == null) {
                this.a(certJ);
            }
            if (this.i == null && this.k == null) {
                throw new XMLException("Can't sign: No certificates or key available");
            }
            DatabaseService databaseService = (DatabaseService)certJ.bindServices(1);
            if (this.k != null && this.i == null) {
                jSAFE_PrivateKey = databaseService.selectPrivateKeyByPublicKey(this.k);
            } else if (this.k == null && this.i.length >= 1) {
                int n = 0;
                JSAFE_PrivateKey jSAFE_PrivateKey2 = null;
                for (int i = 0; i < this.i.length; ++i) {
                    jSAFE_PrivateKey = databaseService.selectPrivateKeyByCertificate(this.i[i]);
                    if (jSAFE_PrivateKey == null) continue;
                    ++n;
                    jSAFE_PrivateKey2 = jSAFE_PrivateKey;
                }
                if (n != 1) {
                    throw new XMLException("Private key not set, can't choose the right certificate");
                }
                jSAFE_PrivateKey = jSAFE_PrivateKey2;
            } else {
                jSAFE_PrivateKey = databaseService.selectPrivateKeyByPublicKey(this.k);
            }
            this.sign(certJ, (JSAFE_Key)jSAFE_PrivateKey, certJ.getRandomObject(), certJ.getDevice());
        }
        catch (CertJException certJException) {
            throw new XMLException("Can't sign the XML document:\n" + certJException.getMessage());
        }
    }

    public void sign(JSAFE_Key jSAFE_Key, JSAFE_SecureRandom jSAFE_SecureRandom, String string) throws XMLException {
        this.sign(null, jSAFE_Key, jSAFE_SecureRandom, string);
    }

    public void sign(CertJ certJ, JSAFE_Key jSAFE_Key, JSAFE_SecureRandom jSAFE_SecureRandom, String string) throws XMLException {
        if (jSAFE_Key == null) {
            throw new XMLException("Error in signing: signKey not set");
        }
        if (string == null) {
            throw new XMLException("Error in signing: device not set");
        }
        byte[] byArray = null;
        byArray = this.generateSignedInfo();
        this.a(jSAFE_Key, jSAFE_SecureRandom, string, byArray, certJ);
    }

    public byte[] generateSignedInfo() throws XMLException {
        Object object;
        String string = this.c;
        string = string == null ? "" : string + ":";
        if (this.useTemplate) {
            if (this.n == null) {
                throw new XMLException("Error in Template signing:No signature document available");
            }
            this.b();
            if (this.f != null) {
                object = (Element)this.p.getElementsByTagNameNS(this.r, "SignatureValue").item(0);
                this.p.insertBefore(ParserHandler.generateKeyInfo(this, this.n), object.getNextSibling());
            }
            this.a(this.n, true);
        } else {
            if (this.h == null) {
                throw new XMLException("Error in signing: signature method not set");
            }
            if (this.d == null) {
                throw new XMLException("Error in signing: References not set");
            }
            switch (this.a & 0xE) {
                case 4: {
                    if (this.n == null) {
                        throw new XMLException("Error in generating signature element:root document not available");
                    }
                    if (this.o != null && this.o != this.n) {
                        throw new XMLException("Error in signing:Can't specify more than one root document");
                    }
                    this.p = ParserHandler.generateSignatureElement(this, this.n);
                    if (this.e != null) {
                        for (int i = 0; i < this.e.size(); ++i) {
                            if (this.e.elementAt(i) == null) continue;
                            this.p.appendChild((Element)this.e.elementAt(i));
                        }
                    }
                    if (this.o != null) {
                        Element element = this.n.createElementNS(this.r, string + "Object");
                        for (int i = 0; i < this.d.size(); ++i) {
                            if (this.d.elementAt(i) == null) continue;
                            Reference reference = (Reference)this.d.elementAt(i);
                            if (reference.getURI() == null) {
                                reference.setURI("");
                            }
                            if (reference.getURI().indexOf("#") == -1) {
                                element.setAttribute("Id", reference.getURI());
                                break;
                            }
                            element.setAttribute("Id", reference.getURI().substring(1));
                            break;
                        }
                        element.setAttribute("xmlns", "");
                        element.appendChild(this.n.getDocumentElement());
                        this.p.appendChild(element);
                    }
                    this.n.appendChild(this.p);
                    if (this.o == null) {
                        this.o = this.n;
                    }
                    this.a(this.n, false);
                    break;
                }
                case 2: {
                    if (this.n == null) {
                        throw new XMLException("Error in generating signature element:Root document not available");
                    }
                    if (this.o != null && this.o != this.n) {
                        throw new XMLException("Error in generating signature element:Can't specify more than more root");
                    }
                    this.p = ParserHandler.generateSignatureElement(this, this.n);
                    if (this.e != null) {
                        for (int i = 0; i < this.e.size(); ++i) {
                            if (this.e.elementAt(i) == null) continue;
                            this.p.appendChild((Element)this.e.elementAt(i));
                        }
                    }
                    if (this.n.getDocumentElement() != null) {
                        this.n.getDocumentElement().appendChild(this.p);
                    }
                    if (this.o == null) {
                        this.o = this.n;
                    }
                    this.a(this.n, false);
                    break;
                }
                case 8: {
                    if (this.n != null && this.n == this.o) {
                        this.n = new DocumentImpl();
                    } else if (this.n == null) {
                        this.n = new DocumentImpl();
                    }
                    this.p = ParserHandler.generateSignatureElement(this, this.n);
                    if (this.e != null) {
                        for (int i = 0; i < this.e.size(); ++i) {
                            if (this.e.elementAt(i) == null) continue;
                            this.p.appendChild((Element)this.e.elementAt(i));
                        }
                    }
                    this.n.appendChild(this.p);
                    if (this.o == null) {
                        this.o = this.n;
                    }
                    this.a(this.o, false);
                    break;
                }
                default: {
                    throw new XMLException("Unknown signature algorithm:" + this.a);
                }
            }
        }
        if (this.m == null && (object = this.p.getElementsByTagNameNS(this.r, "SignedInfo")).getLength() != 0) {
            this.m = object.item(0);
        }
        return this.getCanonicalizedSignedInfo();
    }

    public byte[] getCanonicalizedSignedInfo() throws XMLException {
        byte[] byArray = null;
        if (this.g == null) {
            throw new XMLException("Canonicalization method required");
        }
        byArray = this.g.indexOf("#") != -1 ? ParserHandler.nodeToByteArray(this.m, true, true, null) : ParserHandler.nodeToByteArray(this.m, true, false, null);
        return byArray;
    }

    public void setSignatureValueElement(byte[] byArray) throws XMLException {
        this.setSignatureValue(byArray);
        this.a();
    }

    private void a() throws XMLException {
        if (this.l == null) {
            throw new XMLException("No signature value provided.");
        }
        if (this.p == null) {
            this.b();
        }
        NodeList nodeList = this.p.getElementsByTagNameNS(this.r, "SignatureValue");
        Node node = null;
        if (nodeList.getLength() == 0) {
            node = this.p.getOwnerDocument().createElementNS(this.r, "SignatureValue");
            this.p.appendChild(node);
        } else {
            node = nodeList.item(0);
        }
        node.appendChild(this.p.getOwnerDocument().createTextNode(new String(Base64Transformer.encodeBase64(this.l, 0, this.l.length))));
    }

    private void b() throws XMLException {
        Object object;
        Object object2;
        NodeList nodeList = this.n.getElementsByTagNameNS("*", "Signature");
        if (nodeList.getLength() == 0) {
            throw new XMLException("This document does not contain XML signature.");
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = (Element)nodeList.item(i);
            String string = object2.getPrefix();
            string = string == null ? "" : ":" + string;
            object = object2.getAttribute("xmlns" + string);
            if (!((String)object).equals(SUPPORTED_XML_NAMESPACES[0]) && !((String)object).equals(SUPPORTED_XML_NAMESPACES[1])) continue;
            nodeListImpl.add((Node)object2);
        }
        if (nodeListImpl.getLength() == 0) {
            throw new XMLException("No valid template is found.");
        }
        Element element = null;
        object2 = null;
        for (int i = 0; i < nodeListImpl.getLength(); ++i) {
            element = (Element)nodeListImpl.item(i);
            if (element.hasAttribute("Id")) {
                object2 = element.getAttributes().getNamedItem("Id").getNodeValue();
            }
            if ((object = element.getElementsByTagNameNS("*", "SignatureValue")).getLength() != 1) continue;
            Node node = object.item(0).getFirstChild();
            if (node == null) {
                if (ParserHandler.TEMPLATE_ID == null) {
                    this.p = element;
                    break;
                }
                if (ParserHandler.TEMPLATE_ID == null || object2 == null || !((String)object2).equals(ParserHandler.TEMPLATE_ID)) continue;
                this.p = element;
                break;
            }
            if (node.getNodeType() != 3) continue;
            int n = 0;
            try {
                byte[] byArray = node.getNodeValue().getBytes();
                n = Base64Transformer.decodeBase64Data(byArray, 0, byArray.length).length;
            }
            catch (XMLException xMLException) {
                throw new XMLException("The template has an invalid <SignatureValue> element:" + xMLException.getMessage());
            }
            if (ParserHandler.TEMPLATE_ID == null && n == 0) {
                this.p = element;
                break;
            }
            if (ParserHandler.TEMPLATE_ID == null || object2 == null || n != 0 || !((String)object2).equals(ParserHandler.TEMPLATE_ID)) continue;
            this.p = element;
            break;
        }
        if (this.p == null) {
            throw new XMLException("A given file does not contain an empty signature template or an invalid template id is set.");
        }
        String string = this.p.getPrefix();
        if (string == null) {
            string = "";
        } else {
            this.c = string;
            string = ":" + string;
        }
        if (this.p.hasAttribute("xmlns" + string)) {
            this.r = this.p.getAttribute("xmlns" + string);
        }
        if (this.p.hasAttribute("Id")) {
            this.b = this.p.getAttribute("Id");
        }
        ParserHandler.parseSignedInfo(this, this.p);
        this.a = ParserHandler.checkSignatureType(this);
    }

    private void a(Node node, boolean bl) throws XMLException {
        for (int i = 0; i < this.d.size(); ++i) {
            Object object;
            if (this.d.elementAt(i) == null) continue;
            Reference reference = (Reference)this.d.elementAt(i);
            if (bl && (object = reference.getTransforms()) != null) {
                for (int j = 0; j < ((Transformer[])object).length; ++j) {
                    Transformer transformer = object[j];
                    String string = transformer.getTransformAlgorithm();
                    boolean bl2 = string.equals(Transformer.ENVELOPED_SIGNATURE_LIST[0]);
                    boolean bl3 = string.equals(Transformer.ENVELOPED_SIGNATURE_LIST[1]);
                    if (!bl2 && !bl3) continue;
                    this.foundET = true;
                }
            }
            if (reference.getDigestValue() != null) continue;
            object = this.getNamespacePrefix();
            object = object == null ? "" : (String)object + ":";
            reference.commentXPointer = this.commentXPointer;
            reference.makeDigestValue(node, false, (String)object, this.getXMLNamespace());
        }
    }

    private void a(JSAFE_Key jSAFE_Key, JSAFE_SecureRandom jSAFE_SecureRandom, String string, byte[] byArray, CertJ certJ) throws XMLException {
        JSAFE_Signature jSAFE_Signature;
        block16: {
            jSAFE_Signature = null;
            try {
                String string2 = this.h.substring(this.h.indexOf("#") + 1);
                if (string2.equals("dsa-sha1")) {
                    if (jSAFE_SecureRandom == null) {
                        throw new XMLException("Error in DSA signing:SecureRandom not set");
                    }
                    jSAFE_Signature = JSAFE_Signature.getInstance((String)"SHA1/DSA", (String)string);
                    if (certJ == null) {
                        jSAFE_Signature.signInit((JSAFE_PrivateKey)jSAFE_Key, (SecureRandom)jSAFE_SecureRandom);
                    } else {
                        jSAFE_Signature.signInit((JSAFE_PrivateKey)jSAFE_Key, null, (SecureRandom)jSAFE_SecureRandom, certJ.getPKCS11Sessions());
                    }
                    jSAFE_Signature.signUpdate(byArray, 0, byArray.length);
                    byte[] byArray2 = jSAFE_Signature.signFinal();
                    try {
                        this.l = this.b(byArray2);
                        break block16;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new XMLException("Error in signing XML document:\n" + aSN_Exception.getMessage());
                    }
                }
                if (string2.equals("rsa-sha1")) {
                    jSAFE_Signature = JSAFE_Signature.getInstance((String)"SHA1/RSA/PKCS1Block01Pad", (String)string);
                    if (certJ == null) {
                        jSAFE_Signature.signInit((JSAFE_PrivateKey)jSAFE_Key, (SecureRandom)jSAFE_SecureRandom);
                    } else {
                        jSAFE_Signature.signInit((JSAFE_PrivateKey)jSAFE_Key, null, (SecureRandom)jSAFE_SecureRandom, certJ.getPKCS11Sessions());
                    }
                    jSAFE_Signature.signUpdate(byArray, 0, byArray.length);
                    this.l = new byte[jSAFE_Signature.getSignatureSize()];
                    jSAFE_Signature.signFinal(this.l, 0);
                    break block16;
                }
                if (string2.equals("hmac-sha1")) {
                    JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance((String)"HMAC/SHA1", (String)string);
                    jSAFE_MAC.macInit((JSAFE_SecretKey)jSAFE_Key, (SecureRandom)jSAFE_SecureRandom);
                    jSAFE_MAC.macUpdate(byArray, 0, byArray.length);
                    if (this.q < 0 || this.q % 8 != 0 || this.q / 8 > 20) {
                        throw new XMLException("Error in signing: Wrong HMAC output length: " + this.q);
                    }
                    if (this.q != 0) {
                        this.l = new byte[this.q / 8];
                        byte[] byArray3 = new byte[jSAFE_MAC.getMACSize()];
                        jSAFE_MAC.macFinal(byArray3, 0);
                        System.arraycopy(byArray3, 0, this.l, 0, this.q / 8);
                    } else {
                        this.l = new byte[jSAFE_MAC.getMACSize()];
                        jSAFE_MAC.macFinal(this.l, 0);
                    }
                    jSAFE_MAC.clearSensitiveData();
                    break block16;
                }
                throw new XMLException("Error in signing:Unsupported signatureMethod");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Error in signing XML document:\n" + jSAFE_Exception.getMessage());
            }
        }
        if (jSAFE_Signature != null) {
            jSAFE_Signature.clearSensitiveData();
        }
        this.a();
    }

    public VerificationInfo verify(CertJ certJ, CertPathCtx certPathCtx) throws XMLException {
        JSAFE_PublicKey jSAFE_PublicKey;
        block21: {
            jSAFE_PublicKey = null;
            this.j = -1;
            try {
                if (certJ == null) {
                    throw new XMLException("Can't verify signature: certj not available");
                }
                if (this.i == null && this.k == null) {
                    this.a(certJ);
                }
                if (this.i == null && this.k != null) {
                    jSAFE_PublicKey = this.k;
                    break block21;
                }
                if (this.i != null && this.k == null) {
                    if (certPathCtx == null) {
                        if (this.i[0] != null) {
                            jSAFE_PublicKey = this.i[0].getSubjectPublicKey(certJ.getDevice());
                            this.j = 0;
                        }
                        break block21;
                    }
                    int n = 0;
                    for (n = 0; n < this.i.length; ++n) {
                        if (this.i[n] == null || !certJ.verifyCertPath(certPathCtx, this.i[n])) continue;
                        jSAFE_PublicKey = this.i[n].getSubjectPublicKey(certJ.getDevice());
                        this.j = n;
                        break block21;
                    }
                    break block21;
                }
                if (this.i == null || this.k == null) break block21;
                int n = 0;
                for (n = 0; n < this.i.length; ++n) {
                    if (certPathCtx != null) {
                        if (this.i[n] != null && certJ.verifyCertPath(certPathCtx, this.i[n])) {
                            if (this.i[n].getSubjectPublicKey(certJ.getDevice()).equals(this.k)) {
                                jSAFE_PublicKey = this.k;
                            } else if (certJ.validateCertificate(certPathCtx, this.i[n], this.k)) {
                                jSAFE_PublicKey = this.k;
                            }
                        }
                    } else if (this.i[n] != null) {
                        if (this.i[n].getSubjectPublicKey(certJ.getDevice()).equals(this.k)) {
                            jSAFE_PublicKey = this.k;
                        } else if (this.i[n].verifyCertificateSignature(certJ.getDevice(), this.k, (SecureRandom)certJ.getRandomObject())) {
                            jSAFE_PublicKey = this.k;
                        }
                    }
                    if (jSAFE_PublicKey == null) continue;
                    this.j = n;
                    break;
                }
            }
            catch (CertificateException certificateException) {
                throw new XMLException("Error in verifying certificate:\n" + certificateException.getMessage());
            }
            catch (CertJException certJException) {
                throw new XMLException("Error in verifying certificate:\n" + certJException.getMessage());
            }
        }
        return this.verify(certJ, (JSAFE_Key)jSAFE_PublicKey, certJ.getDevice());
    }

    public VerificationInfo verify(JSAFE_Key jSAFE_Key, String string) throws XMLException {
        return this.verify(null, jSAFE_Key, string);
    }

    public VerificationInfo verify(CertJ certJ, JSAFE_Key jSAFE_Key, String string) throws XMLException {
        int n;
        if (this.g == null) {
            throw new XMLException("Canonicalization require");
        }
        VerificationInfo verificationInfo = new VerificationInfo();
        if (this.l == null) {
            throw new XMLException("Error in verify: no signature value present");
        }
        if (jSAFE_Key == null) {
            throw new XMLException("Error in verify: verify key is null");
        }
        if (string == null) {
            throw new XMLException("Error in verify: device not set");
        }
        if (this.d == null) {
            throw new XMLException("Can't verify: no references present");
        }
        int[] nArray = new int[]{};
        int[] nArray2 = null;
        String[] stringArray = new String[]{};
        String[] stringArray2 = null;
        StringBuffer stringBuffer = null;
        boolean bl = true;
        for (int i = 0; i < this.d.size(); ++i) {
            if (this.d.elementAt(i) == null) continue;
            stringBuffer = new StringBuffer();
            if (((Reference)this.d.elementAt(i)).verify(this, stringBuffer)) continue;
            bl = false;
            nArray2 = new int[nArray.length];
            stringArray2 = new String[stringArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray2[n] = nArray[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            }
            nArray = new int[nArray2.length + 1];
            stringArray = new String[stringArray.length + 1];
            for (n = 0; n < nArray2.length; ++n) {
                nArray[n] = nArray2[n];
                stringArray[n] = stringArray2[n];
            }
            nArray[nArray2.length] = i;
            stringArray[stringArray2.length] = new String(stringBuffer);
        }
        if (nArray.length > 0) {
            verificationInfo.setFailedReferenceIndexes(nArray);
            verificationInfo.setDescriptions(stringArray);
        }
        byte[] byArray = null;
        byArray = this.g.indexOf("#") != -1 ? ParserHandler.nodeToByteArray(this.m, true, true, null) : ParserHandler.nodeToByteArray(this.m, true, false, null);
        n = this.a(certJ, jSAFE_Key, string, byArray, 0, byArray.length);
        if (n != 0 && bl) {
            verificationInfo.setStatus(0);
        }
        if (n == 0 && !bl) {
            verificationInfo.setStatus(3);
        }
        if (n != 0 && !bl) {
            verificationInfo.setStatus(2);
        }
        if (n == 0 && bl) {
            verificationInfo.setStatus(1);
        }
        return verificationInfo;
    }

    private boolean a(CertJ certJ, JSAFE_Key jSAFE_Key, String string, byte[] byArray, int n, int n2) throws XMLException {
        boolean bl;
        block16: {
            if (jSAFE_Key == null) {
                return false;
            }
            String string2 = this.h.substring(this.h.indexOf("#") + 1);
            try {
                if (string2.equals("dsa-sha1")) {
                    JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)"SHA1/DSA", (String)string);
                    if (certJ == null) {
                        jSAFE_Signature.verifyInit((JSAFE_PublicKey)jSAFE_Key, null);
                    } else {
                        jSAFE_Signature.verifyInit((JSAFE_PublicKey)jSAFE_Key, null, null, certJ.getPKCS11Sessions());
                    }
                    jSAFE_Signature.verifyUpdate(byArray, n, n2);
                    byte[] byArray2 = null;
                    try {
                        byArray2 = this.a(this.l);
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new XMLException("Can't verify signature:\n" + aSN_Exception.getMessage());
                    }
                    bl = jSAFE_Signature.verifyFinal(byArray2, 0, byArray2.length);
                    jSAFE_Signature.clearSensitiveData();
                    break block16;
                }
                if (string2.equals("rsa-sha1")) {
                    JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)"SHA1/RSA/PKCS1Block01Pad", (String)string);
                    if (certJ == null) {
                        jSAFE_Signature.verifyInit((JSAFE_PublicKey)jSAFE_Key, null);
                    } else {
                        jSAFE_Signature.verifyInit((JSAFE_PublicKey)jSAFE_Key, null, null, certJ.getPKCS11Sessions());
                    }
                    jSAFE_Signature.verifyUpdate(byArray, n, n2);
                    bl = jSAFE_Signature.verifyFinal(this.l, 0, this.l.length);
                    jSAFE_Signature.clearSensitiveData();
                    break block16;
                }
                if (string2.equals("hmac-sha1")) {
                    JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance((String)"HMAC/SHA1", (String)string);
                    jSAFE_MAC.verifyInit((JSAFE_SecretKey)jSAFE_Key, null);
                    jSAFE_MAC.verifyUpdate(byArray, n, n2);
                    if (this.q != 0) {
                        if (this.q < 0 || this.q % 8 != 0 || this.q / 8 > 20) {
                            throw new XMLException("Error in signing:Wrong HMAC output length: " + this.q);
                        }
                        jSAFE_MAC.macInit((JSAFE_SecretKey)jSAFE_Key, null);
                        jSAFE_MAC.macUpdate(byArray, n, n2);
                        byte[] byArray3 = new byte[jSAFE_MAC.getMACSize()];
                        jSAFE_MAC.macFinal(byArray3, 0);
                        for (int i = 0; i < this.l.length; ++i) {
                            if (this.l[i] == byArray3[i]) continue;
                            jSAFE_MAC.clearSensitiveData();
                            return false;
                        }
                        bl = true;
                    } else {
                        bl = jSAFE_MAC.verifyFinal(this.l, 0, this.l.length);
                    }
                    jSAFE_MAC.clearSensitiveData();
                    break block16;
                }
                return false;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Can't verify signature:\n" + jSAFE_Exception.getMessage());
            }
        }
        return bl;
    }

    public Certificate getVerifyingCert() throws CloneNotSupportedException {
        if (this.i != null && this.j != -1 && this.i[this.j] instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)this.i[this.j];
            return (Certificate)x509Certificate.clone();
        }
        return null;
    }

    public void setSignatureElement(Element element) {
        this.p = element;
    }

    public Element getSignatureElement() {
        return this.p;
    }

    public void setXMLNamespace(String string) throws XMLException {
        if (string != null) {
            for (int i = 0; i < SUPPORTED_XML_NAMESPACES.length; ++i) {
                if (!string.equals(SUPPORTED_XML_NAMESPACES[i])) continue;
                this.r = string;
                return;
            }
            throw new XMLException("Not suppored XML namespace value:" + string);
        }
    }

    public String getXMLNamespace() {
        return this.r;
    }

    public void setDocument(Document document) {
        this.n = document;
    }

    public void setDocument(Document document, boolean bl) {
        this.n = document;
        this.useTemplate = bl;
        if (bl) {
            this.c = null;
        }
    }

    public boolean useTemplate() {
        return this.useTemplate;
    }

    public Document getDocument() {
        return this.n;
    }

    public void setFlags(int n) {
        this.s = n;
    }

    public int getFlags() {
        return this.s;
    }

    private void a(CertJ certJ) throws XMLException {
        try {
            if (this.f != null) {
                for (int i = 0; i < this.f.size(); ++i) {
                    if (this.f.elementAt(i) == null) continue;
                    if (((KeyInfo)this.f.elementAt(i)).hasCertificate()) {
                        Certificate[] certificateArray = new Certificate[]{};
                        if (this.i != null) {
                            certificateArray = new Certificate[this.i.length];
                            System.arraycopy(this.i, 0, certificateArray, 0, this.i.length);
                        }
                        Certificate[] certificateArray2 = ((KeyInfo)this.f.elementAt(i)).getCertificates(certJ);
                        this.i = new Certificate[certificateArray.length + certificateArray2.length];
                        System.arraycopy(certificateArray, 0, this.i, 0, certificateArray.length);
                        System.arraycopy(certificateArray2, 0, this.i, certificateArray.length, certificateArray2.length);
                    }
                    if (!((KeyInfo)this.f.elementAt(i)).hasKey()) continue;
                    this.k = ((KeyInfo)this.f.elementAt(i)).getKey();
                }
            }
        }
        catch (CertJException certJException) {
            throw new XMLException("Error in retrieving certificates/publicKey:\n" + certJException.getMessage());
        }
    }

    private byte[] a(byte[] byArray) throws ASN_Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0, true, 0, byArray, 0, 20, true);
        IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, byArray, 20, 20, true);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
        ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
        aSN1Template.derEncodeInit();
        byte[] byArray2 = new byte[48];
        int n = aSN1Template.derEncode(byArray2, 0);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private byte[] b(byte[] byArray) throws ASN_Exception {
        byte[] byArray2 = new byte[40];
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0);
        IntegerContainer integerContainer2 = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
        ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
        int n = integerContainer.dataOffset + integerContainer.dataLen - 1;
        int n2 = integerContainer2.dataOffset + integerContainer2.dataLen - 1;
        int n3 = 39;
        while (n3 >= 20) {
            if (n2 >= integerContainer2.dataOffset) {
                byArray2[n3] = integerContainer2.data[n2];
            }
            --n3;
            --n2;
        }
        n3 = 19;
        while (n3 >= 0) {
            if (n >= integerContainer.dataOffset) {
                byArray2[n3] = integerContainer.data[n];
            }
            --n3;
            --n;
        }
        return byArray2;
    }

    static {
        String[] stringArray = new String[2];
        stringArray[0] = DEFAULT_MAC_ALGORITHM;
        stringArray[1] = "http://www.w3.org/2000/07/xmldsig#hmac-sha1";
        SUPPORTED_MAC_ALGORITHMS = stringArray;
        String[] stringArray2 = new String[6];
        stringArray2[0] = DSA_SIGNATURE_ALGORITHM;
        stringArray2[1] = "http://www.w3.org/2000/07/xmldsig#dsa-sha1";
        stringArray2[2] = RSA_SIGNATURE_ALGORITHM;
        stringArray2[3] = "http://www.w3.org/2000/07/xmldsig#rsa-sha1";
        stringArray2[4] = DEFAULT_MAC_ALGORITHM;
        stringArray2[5] = "http://www.w3.org/2000/07/xmldsig#hmac-sha1";
        SUPPORTED_SIGNATURE_ALGORITHMS = stringArray2;
        String[] stringArray3 = new String[2];
        stringArray3[0] = DEFAULT_XML_NAMESPACE;
        stringArray3[1] = "http://www.w3.org/2000/07/xmldsig#";
        SUPPORTED_XML_NAMESPACES = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[0] = DEFAULT_DIGEST_ALGORITHM;
        stringArray4[1] = "http://www.w3.org/2000/07/xmldsig#sha1";
        SUPPORTED_DIGEST_ALGORITHMS = stringArray4;
    }
}

