/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml.dsig;

import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.NodeListImpl;
import com.rsa.certj.xml.ParserHandler;
import com.rsa.certj.xml.Transformer;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.XPATHTransformer;
import com.rsa.certj.xml.XPointerHandler;
import com.rsa.certj.xml.dsig.EnvelopedTransformer;
import com.rsa.certj.xml.dsig.Manifest;
import com.rsa.certj.xml.dsig.XMLSignature;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class Reference
implements Cloneable,
Serializable {
    public static final String SIGNATURE_PROPERTY_TYPE = "SignatureProperties";
    public static final String MANIFEST_TYPE = "Manifest";
    public static final String OBJECT_TYPE = "Object";
    public static final String REFERENCE_TYPE = "Reference";
    private String a;
    private String b = null;
    private byte[] c = null;
    private Vector d = null;
    private String e = null;
    private Node f = null;
    protected boolean commentXPointer = false;
    private String g = null;
    private Manifest h = null;

    public Reference() {
    }

    public Reference(String string) {
        this.a = string;
    }

    public Reference(String string, String string2, Transformer[] transformerArray) {
        this.a = string;
        this.b = string2;
        if (transformerArray != null && transformerArray.length > 0) {
            this.d = new Vector(transformerArray.length);
            for (int i = 0; i < transformerArray.length; ++i) {
                this.d.addElement(transformerArray[i]);
            }
        }
    }

    public Reference(String string, String string2, Transformer[] transformerArray, String string3) {
        this(string, string2, transformerArray);
        this.e = string3;
    }

    public Reference(String string, String string2, Transformer[] transformerArray, String string3, Manifest manifest) {
        this(string, string2, transformerArray, string3);
        this.h = manifest;
    }

    protected Reference(String string, String string2, byte[] byArray, Transformer[] transformerArray, String string3) {
        this(string, string2, transformerArray, string3);
        if (byArray != null) {
            this.c = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.c, 0, byArray.length);
        }
    }

    public void setReferenceType(String string) {
        this.e = string;
    }

    public String getReferenceType() {
        return this.e;
    }

    public void setURI(String string) {
        this.a = string;
    }

    public String getURI() {
        return this.a;
    }

    public void addTransform(Transformer transformer) {
        if (transformer != null) {
            if (this.d == null) {
                this.d = new Vector();
            }
            this.d.addElement(transformer);
        }
    }

    public void setTransform(Transformer[] transformerArray) {
        if (transformerArray != null && transformerArray.length > 0) {
            if (this.d == null) {
                this.d = new Vector(transformerArray.length);
            } else {
                this.d.ensureCapacity(transformerArray.length);
                this.d.removeAllElements();
            }
            for (int i = 0; i < transformerArray.length; ++i) {
                this.d.addElement(transformerArray[i]);
            }
        } else if (this.d != null) {
            this.d.removeAllElements();
        }
    }

    public Transformer getTransform(int n) {
        if (this.d == null) {
            return null;
        }
        if (n < 0 || n >= this.d.size()) {
            return null;
        }
        return (Transformer)this.d.elementAt(n);
    }

    public int getTransformCount() {
        if (this.d == null) {
            return 0;
        }
        return this.d.size();
    }

    public Transformer[] getTransforms() {
        Object[] objectArray = null;
        if (this.d != null) {
            objectArray = new Transformer[this.d.size()];
            this.d.copyInto(objectArray);
        }
        return objectArray;
    }

    public void setDigestMethod(String string) {
        this.b = string;
    }

    public String getDigestMethod() {
        return this.b;
    }

    protected void setDigestValue(byte[] byArray) {
        if (byArray != null) {
            this.c = byArray;
        }
    }

    public byte[] getDigestValue() {
        return this.c;
    }

    protected Node getReferenceNode() {
        return this.f;
    }

    protected void setReferenceNode(Node node) {
        this.f = node;
    }

    public String getReferenceID() {
        return this.g;
    }

    public void setReferenceID(String string) {
        this.g = string;
    }

    public void setManifest(Manifest manifest) {
        if (this.e != MANIFEST_TYPE) {
            this.e = MANIFEST_TYPE;
        }
        this.h = manifest;
    }

    public Manifest getManifest() {
        return this.h;
    }

    public void parseReference(Element element, String string) throws XMLException {
        String string2;
        NodeList nodeList;
        int n;
        Object object;
        if (element == null) {
            throw new XMLException("Error in parsing reference: reference is null");
        }
        this.f = element;
        if (element.hasAttribute("URI")) {
            this.a = element.getAttribute("URI");
        }
        if (element.hasAttribute("Type")) {
            this.e = element.getAttribute("Type");
        }
        if (element.hasAttribute("Id")) {
            this.g = element.getAttribute("Id");
        }
        if (this.a == null) {
            this.a = "";
        }
        if (this.e != null && (this.e.equals(MANIFEST_TYPE) || this.e.endsWith(MANIFEST_TYPE))) {
            object = null;
            object = this.a.startsWith("#") ? Reference.resolveId(element.getOwnerDocument(), this.a.substring(1)) : Reference.resolveId(element.getOwnerDocument(), this.a);
            if (object != null) {
                this.h = new Manifest();
                this.h.parseManifest((Element)object, string);
            }
        }
        if ((object = element.getElementsByTagNameNS(string, "Transforms")).getLength() > 0 && (n = (nodeList = ((Element)object.item(0)).getElementsByTagNameNS(string, "Transform")).getLength()) > 0) {
            if (this.d == null) {
                this.d = new Vector(n);
            } else {
                this.d.ensureCapacity(n);
                this.d.removeAllElements();
            }
            block0: for (int i = 0; i < n; ++i) {
                Node node;
                int n2;
                if (!((Element)nodeList.item(i)).hasAttribute("Algorithm")) {
                    throw new XMLException("Error in reading reference: No transform algorithm available");
                }
                string2 = ((Element)nodeList.item(i)).getAttribute("Algorithm");
                this.d.insertElementAt(Transformer.getInstance(string2), i);
                for (n2 = 0; n2 < Transformer.XPATH_LIST.length; ++n2) {
                    if (!string2.equals(Transformer.XPATH_LIST[n2])) continue;
                    node = (Element)nodeList.item(i);
                    NodeList nodeList2 = node.getElementsByTagNameNS(string, "XPath");
                    if (nodeList2.getLength() == 0) break;
                    XPATHTransformer xPATHTransformer = (XPATHTransformer)this.d.elementAt(i);
                    xPATHTransformer.setXPathExpression(nodeList2.item(0));
                    break;
                }
                for (n2 = 0; n2 < Transformer.ENVELOPED_SIGNATURE_LIST.length; ++n2) {
                    if (!string2.equals(Transformer.ENVELOPED_SIGNATURE_LIST[n2])) continue;
                    node = nodeList.item(i);
                    if (node == null) continue block0;
                    ((EnvelopedTransformer)this.d.elementAt(i)).setEnvelopedExpNode(node);
                    continue block0;
                }
            }
        }
        if ((nodeList = element.getElementsByTagNameNS(string, "DigestMethod")).getLength() == 0) {
            throw new XMLException("Error in reading reference: Digest method not available.");
        }
        this.b = ((Element)nodeList.item(0)).getAttribute("Algorithm");
        NodeList nodeList3 = element.getElementsByTagNameNS(string, "DigestValue");
        if (nodeList3.getLength() == 0) {
            throw new XMLException("Error in reading reference: DigestValue not available");
        }
        NodeList nodeList4 = nodeList3.item(0).getChildNodes();
        if (nodeList4.getLength() > 0) {
            string2 = nodeList4.item(0).getNodeValue();
            this.c = Base64Transformer.decodeBase64Data(string2.getBytes(), 0, string2.getBytes().length);
        }
    }

    public Element generateReferenceElement(XMLSignature xMLSignature, Document document) throws XMLException {
        Object object;
        if (this.d != null) {
            for (int i = 0; i < this.d.size(); ++i) {
                if (!(this.d.elementAt(i) instanceof EnvelopedTransformer) || xMLSignature.getSignatureType() == 2) continue;
                throw new XMLException("Wrong usage: Signature type is not EnvelopedSignature butcontaining an EnvelopedTransformer");
            }
        }
        String string = xMLSignature.getXMLNamespace();
        String string2 = xMLSignature.getNamespacePrefix();
        string2 = string2 == null ? "" : string2 + ":";
        Element element = document.createElementNS(string, string2 + REFERENCE_TYPE);
        if (this.a != null) {
            element.setAttribute("URI", this.a);
        } else {
            element.setAttribute("URI", "");
        }
        if (this.g != null) {
            element.setAttribute("Id", this.g);
        }
        if (this.e != null) {
            this.a(element, string);
        }
        element.appendChild(document.createTextNode("\n      "));
        if (this.d != null && this.d.size() > 0) {
            this.a(document, element, string);
        }
        if (this.b == null) {
            throw new XMLException("Error in generating Reference: DigestMethod not set");
        }
        Element element2 = document.createElementNS(string, string2 + "DigestMethod");
        element2.setAttribute("Algorithm", this.b);
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n      "));
        Element element3 = document.createElementNS(string, string2 + "DigestValue");
        element.appendChild(element3);
        if (this.c != null) {
            object = Base64Transformer.encodeBase64(this.c, 0, this.c.length);
            element3.appendChild(document.createTextNode(new String((byte[])object, 0, ((byte[])object).length)));
        }
        element.appendChild(document.createTextNode("\n    "));
        if (this.h != null) {
            object = document.createElementNS(string, string2 + OBJECT_TYPE);
            Element element4 = this.h.generateManifestElement(xMLSignature, document);
            object.appendChild(element4);
            xMLSignature.addXMLObject((Element)object);
        }
        this.f = element;
        return element;
    }

    private void a(Document document, Element element, String string) throws XMLException {
        String string2 = element.getPrefix();
        string2 = string2 == null ? "" : string2 + ":";
        Element element2 = document.createElementNS(string, string2 + "Transforms");
        element.appendChild(element2);
        element.appendChild(document.createTextNode("\n      "));
        Element element3 = null;
        for (int i = 0; i < this.d.size(); ++i) {
            Transformer transformer;
            int n;
            element3 = document.createElementNS(string, string2 + "Transform");
            element3.setAttribute("Algorithm", ((Transformer)this.d.elementAt(i)).getTransformAlgorithm());
            for (n = 0; n < Transformer.ENVELOPED_SIGNATURE_LIST.length; ++n) {
                transformer = (Transformer)this.d.elementAt(i);
                if (!transformer.getTransformAlgorithm().equals(Transformer.ENVELOPED_SIGNATURE_LIST[n])) continue;
                ((EnvelopedTransformer)transformer).setEnvelopedExpNode(element3);
                break;
            }
            for (n = 0; n < Transformer.XPATH_LIST.length; ++n) {
                Object object;
                transformer = (Transformer)this.d.elementAt(i);
                if (!transformer.getTransformAlgorithm().equals(Transformer.XPATH_LIST[n])) continue;
                Element element4 = document.createElementNS(string, string2 + "XPath");
                XPATHTransformer xPATHTransformer = (XPATHTransformer)transformer;
                Node node = xPATHTransformer.getXPathExpression();
                if (node == null && xPATHTransformer.getXPathExpressionAsString() == null) {
                    throw new XMLException("Error in generating Transform element:XPath expression not set");
                }
                if (node != null && node.getChildNodes().getLength() > 0) {
                    object = node.getAttributes();
                    for (int j = 0; j < object.getLength(); ++j) {
                        if (!object.item(j).getNodeName().equals("xmlns") && !object.item(j).getNodeName().startsWith("xmlns:")) continue;
                        element4.setAttribute(object.item(j).getNodeName(), object.item(j).getNodeValue());
                    }
                    if (node.getFirstChild() != null) {
                        String string3 = node.getFirstChild().getNodeValue();
                        element4.appendChild(document.createTextNode(string3));
                        xPATHTransformer.setXPathExpression(string3);
                    }
                } else {
                    object = xPATHTransformer.getXPathExpressionAsString();
                    element4.setAttribute("xmlns", string);
                    if (object != null) {
                        element4.appendChild(document.createTextNode((String)object));
                    }
                }
                xPATHTransformer.setXPathExpression(element4);
                element3.appendChild(element4);
                break;
            }
            element2.appendChild(element3);
            element2.appendChild(i == this.d.size() - 1 ? document.createTextNode("\n      ") : document.createTextNode("\n        "));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(Element element, String string) throws XMLException {
        if (this.e.equals(MANIFEST_TYPE) || this.e.equals(SIGNATURE_PROPERTY_TYPE) || this.e.equals(OBJECT_TYPE) || this.e.equals(REFERENCE_TYPE)) {
            element.setAttribute("Type", string.concat(this.e));
            return;
        } else {
            if (this.e.indexOf("#") == -1) throw new XMLException("Error in generating reference element:Unknown reference type");
            String string2 = this.e.substring(this.e.indexOf("#") + 1);
            if (!string2.equals(MANIFEST_TYPE) && !string2.equals(SIGNATURE_PROPERTY_TYPE) && !string2.equals(OBJECT_TYPE) && !string2.equals(REFERENCE_TYPE)) throw new XMLException("Error in generating reference element:Unknown reference type");
            element.setAttribute("Type", this.e);
        }
    }

    public boolean verifyManifest(XMLSignature xMLSignature, StringBuffer[] stringBufferArray) throws XMLException {
        if (this.h == null) {
            return true;
        }
        return this.h.verify(xMLSignature, stringBufferArray);
    }

    public boolean verify(XMLSignature xMLSignature, StringBuffer stringBuffer) throws XMLException {
        if (xMLSignature == null) {
            throw new XMLException("Error in verifying reference: signature is null");
        }
        if (this.b == null || this.c == null) {
            throw new XMLException("Error in verifying reference:DigestMethod/DigestValue not available");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            String string;
            document = xMLSignature.getDocument();
            if (this.d != null) {
                for (int i = 0; i < this.d.size(); ++i) {
                    Object e = this.d.elementAt(i);
                    if (!(e instanceof EnvelopedTransformer) || xMLSignature.getSignatureType() == 2) continue;
                    throw new XMLException("Wrong usage: Signature type is not EnvelopedSignature butcontaining an EnvelopedTransformer");
                }
            }
            string = (string = xMLSignature.getNamespacePrefix()) == null ? "" : string + ":";
            this.commentXPointer = xMLSignature.commentXPointer;
            byArray = this.makeDigestValue(document, true, string, xMLSignature.getXMLNamespace());
            if (byArray.length != this.c.length) {
                if (stringBuffer != null) {
                    stringBuffer.append("Length of digest value not matched");
                }
                return false;
            }
            for (int i = 0; i < this.c.length; ++i) {
                if (this.c[i] == byArray[i]) continue;
                if (stringBuffer != null) {
                    stringBuffer.append("Digest value not matched");
                }
                return false;
            }
            if (stringBuffer != null) {
                stringBuffer.append("Reference validation succeeds");
            }
            return true;
        }
        catch (XMLException xMLException) {
            if (stringBuffer != null) {
                stringBuffer.append(xMLException.getMessage());
            }
            return false;
        }
    }

    protected byte[] makeDigestValue(Node node, boolean bl, String string, String string2) throws XMLException {
        Object object;
        boolean bl2 = false;
        InputStream inputStream = null;
        byte[] byArray = new byte[]{};
        Node node2 = null;
        byte[] byArray2 = null;
        NodeList nodeList = null;
        if (this.a == null) {
            throw new XMLException("Error in generating digest value: URI not set");
        }
        if (this.e != null) {
            this.a(node, string, string2);
        }
        try {
            int n = this.a.indexOf(35);
            if (n != -1) {
                Object object2;
                if (n == 0) {
                    if (this.a.startsWith("#xpointer")) {
                        nodeList = XPointerHandler.processXPointer(node, this.a);
                        bl2 = this.commentXPointer;
                    } else {
                        node2 = this.e != null ? this.a(node, this.e, this.a, string2) : Reference.resolveId(node, this.a.substring(1));
                        object2 = null;
                        if (this.d != null) {
                            object2 = ((Transformer)this.d.elementAt(0)).getTransformAlgorithm();
                        }
                        if (Transformer.BASE64_LIST[0].equals(object2) || Transformer.BASE64_LIST[1].equals(object2)) {
                            byArray = node2.getFirstChild().getNodeValue().getBytes();
                        } else {
                            nodeList = XPATHTransformer.toNodeset(node2, null, false);
                        }
                    }
                } else {
                    inputStream = new URL(this.a.substring(0, n)).openStream();
                    object2 = new InputSource(inputStream);
                    object = ParserHandler.parseXML((InputSource)object2);
                    node2 = Reference.resolveId((Node)object, this.a.substring(n + 1));
                    nodeList = XPATHTransformer.toNodeset(node2, null, true);
                    inputStream.close();
                }
            } else if (this.a.length() == 0) {
                nodeList = XPATHTransformer.toNodeset(node, null, false);
            } else {
                byArray = Reference.readURI(this.a);
            }
        }
        catch (XMLException xMLException) {
            throw new XMLException("Error in retrieving data by URI: " + this.a + ":\n " + xMLException.getMessage());
        }
        catch (IOException iOException) {
            throw new XMLException("Error in retrieving data by URI: " + this.a + ":\n " + iOException.getMessage());
        }
        if (byArray.length == 0 && nodeList == null) {
            throw new XMLException("Can't retrieve data by URI: " + this.a);
        }
        if (nodeList == null) {
            if (this.d != null && this.d.size() > 0) {
                byte[] byArray3 = null;
                for (int i = 0; i < this.d.size(); ++i) {
                    byArray3 = ((Transformer)this.d.elementAt(i)).performTransformation(byArray, 0, byArray.length);
                    byArray = new byte[byArray3.length];
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                }
            }
            byArray2 = this.a(byArray);
        } else {
            NodeList nodeList2 = null;
            if (this.d != null && this.d.size() > 0) {
                for (int i = 0; i < this.d.size(); ++i) {
                    int n;
                    object = (Transformer)this.d.elementAt(i);
                    for (n = 0; n < Transformer.C14N_WITH_COMMENTS_LIST.length; ++n) {
                        if (!((Transformer)object).getTransformAlgorithm().equals(Transformer.C14N_WITH_COMMENTS_LIST[n])) continue;
                        bl2 = true;
                        break;
                    }
                    nodeList2 = ((Transformer)object).performTransformation(nodeList);
                    nodeList = new NodeListImpl();
                    if (nodeList2 == null) continue;
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        ((NodeListImpl)nodeList).add(nodeList2.item(n));
                    }
                }
            }
            byArray = ParserHandler.nodeToByteArray(nodeList, true, bl2, null);
            byArray2 = this.a(byArray);
        }
        if (!bl) {
            this.c = byArray2;
            this.a(string, string2);
        }
        return byArray2;
    }

    private void a(Node node, String string, String string2) throws XMLException {
        String string3 = null;
        string3 = this.e.indexOf("#") != -1 ? this.e.substring(this.e.indexOf("#") + 1) : this.e;
        if (!(string3.equals(SIGNATURE_PROPERTY_TYPE) || string3.equals(MANIFEST_TYPE) || string3.equals(OBJECT_TYPE) || string3.equals(REFERENCE_TYPE))) {
            throw new XMLException("Error: Unknown reference type: " + this.e);
        }
        if (string3.equals(MANIFEST_TYPE) && this.h != null) {
            this.h.processReferences(node, string, string2);
        }
    }

    private void a(String string, String string2) throws XMLException {
        Document document;
        byte[] byArray = Base64Transformer.encodeBase64(this.c, 0, this.c.length);
        NodeList nodeList = ((Element)this.f).getElementsByTagNameNS(string2, "DigestValue");
        Node node = null;
        if (nodeList.getLength() == 0) {
            document = this.f.getOwnerDocument();
            node = document.createElementNS(string2, string + "DigestValue");
            this.f.appendChild(node);
        } else {
            node = nodeList.item(0);
        }
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
        document = this.f.getOwnerDocument();
        node.appendChild(document.createTextNode(new String(byArray, 0, byArray.length)));
    }

    private Node a(Node node, String string, String string2, String string3) throws XMLException {
        if (node == null) {
            throw new XMLException("Can't generate digest value on data object: data is null");
        }
        String string4 = null;
        string4 = string.indexOf("#") != -1 ? string.substring(string.indexOf("#") + 1) : this.e;
        NodeList nodeList = null;
        if (node.getNodeType() == 9) {
            nodeList = ((Document)node).getElementsByTagNameNS(string3, string4);
        } else if (node.getNodeType() == 1) {
            nodeList = ((Element)node).getElementsByTagNameNS(string3, string4);
        } else {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = Reference.resolveId(nodeList.item(i), this.a.substring(1));
            if (element == null) continue;
            return element;
        }
        return null;
    }

    protected static byte[] readURI(String string) throws XMLException {
        Object object;
        InputStream inputStream = null;
        byte[] byArray = new byte[]{};
        try {
            inputStream = new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            object = new String(System.getProperty("user.dir")).concat(System.getProperty("file.separator")).concat(string);
            try {
                inputStream = new FileInputStream((String)object);
            }
            catch (IOException iOException) {
                throw new XMLException("Error in reading " + string + ":\n" + iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new XMLException("Error in reading " + string + ":\n" + iOException.getMessage());
        }
        try {
            int n;
            int n2 = 0;
            while ((n2 = inputStream.available()) >= 0 && (n = inputStream.read((byte[])(object = (Object)new byte[n2 + 1]))) >= 0) {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = new byte[byArray2.length + n];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                System.arraycopy(object, 0, byArray, byArray2.length, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLException("Error in reading URI " + string + ":\n" + iOException.getMessage());
        }
        return byArray;
    }

    private byte[] a(byte[] byArray) throws XMLException {
        byte[] byArray2 = null;
        if (this.b == null) {
            throw new XMLException("Error in generating digest value: DigestMethod not set");
        }
        for (int i = 0; i < XMLSignature.SUPPORTED_DIGEST_ALGORITHMS.length; ++i) {
            if (!this.b.equals(XMLSignature.SUPPORTED_DIGEST_ALGORITHMS[i])) continue;
            try {
                JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)"SHA1", (String)"Java/Native");
                jSAFE_MessageDigest.digestInit();
                byArray2 = new byte[jSAFE_MessageDigest.getDigestSize()];
                jSAFE_MessageDigest.digestUpdate(byArray, 0, byArray.length);
                jSAFE_MessageDigest.digestFinal(byArray2, 0);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Error in generating digest value:\n" + jSAFE_Exception.getMessage());
            }
            return byArray2;
        }
        throw new XMLException("Not supported digest method: " + this.b);
    }

    public static Element resolveId(Node node, String string) throws XMLException {
        Object object;
        Object object2;
        Object object3;
        String string2 = new String("//*");
        NodeIterator nodeIterator = null;
        try {
            object3 = new XPathContext();
            object2 = new PrefixResolverDefault(node);
            XPath xPath = new XPath(string2, null, (PrefixResolver)object2, 0);
            object = xPath.execute((XPathContext)object3, node, (PrefixResolver)object2);
            nodeIterator = object.nodeset();
        }
        catch (TransformerException transformerException) {
            throw new XMLException("Internal Error:\n" + transformerException.getMessage());
        }
        if (nodeIterator != null) {
            object3 = null;
            while ((object3 = (Element)nodeIterator.nextNode()) != null) {
                object2 = object3.getAttributes();
                for (int i = 0; i < object2.getLength(); ++i) {
                    object = object2.item(i);
                    if (object.getNodeName() == null || !object.getNodeName().equalsIgnoreCase("id") || object.getNodeValue() == null || !object.getNodeValue().equals(string)) continue;
                    return object3;
                }
            }
            return null;
        }
        return null;
    }
}

