/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.KeyInfo;
import com.rsa.certj.xml.ParserHandler;
import com.rsa.certj.xml.XMLException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class X509Data
extends KeyInfo
implements Cloneable,
Serializable {
    private Vector a = null;
    private X500Name b = null;
    private byte[] c = null;
    private X500Name d = null;
    private SubjectKeyID e = null;
    private X509CRL f = null;

    public X509Data() {
    }

    public X509Data(X500Name x500Name, byte[] byArray, X500Name x500Name2, SubjectKeyID subjectKeyID, X509Certificate[] x509CertificateArray, X509CRL x509CRL) {
        this.b = x500Name;
        this.c = byArray;
        this.d = x500Name2;
        this.e = subjectKeyID;
        if (x509CertificateArray != null) {
            this.a = new Vector(x509CertificateArray.length);
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                this.a.addElement(x509CertificateArray[i]);
            }
        }
        this.f = x509CRL;
    }

    public int getKeyInfoType() {
        return 2;
    }

    public String getKeyInfoName() {
        return "X509Data";
    }

    public Element generateKeyInfo(Document document, String string, String string2) throws XMLException {
        Object object;
        Object object2;
        Element element;
        if (document == null) {
            throw new XMLException("Error in generating X509Data element: root document not available");
        }
        Element element2 = document.createElementNS(string, string2 + "X509Data");
        element2.appendChild(document.createTextNode("\n      "));
        if (this.b != null) {
            if (this.c == null) {
                throw new XMLException("Error in generating X509Data element: Serial number and issuer name must be present together");
            }
            element = document.createElementNS(string, string2 + "X509IssuerSerial");
            element2.appendChild(element);
            element2.appendChild(document.createTextNode("\n      "));
            object2 = document.createElementNS(string, string2 + "X509IssuerName");
            object2.appendChild(document.createTextNode(this.b.toString()));
            object = document.createElementNS(string, string2 + "X509SerialNumber");
            object.appendChild(document.createTextNode(ParserHandler.byteArrayToIntString(this.c, 0, this.c.length)));
            element.appendChild(document.createTextNode("\n        "));
            element.appendChild((Node)object2);
            element.appendChild(document.createTextNode("\n        "));
            element.appendChild((Node)object);
            element.appendChild(document.createTextNode("\n      "));
        }
        if (this.d != null) {
            element = document.createElementNS(string, string2 + "X509SubjectName");
            element.appendChild(document.createTextNode(this.d.toString()));
            element2.appendChild(element);
            element2.appendChild(document.createTextNode("\n      "));
        }
        if (this.e != null) {
            element = document.createElementNS(string, string2 + "X509SKI");
            object2 = this.e.getKeyID();
            if (object2 != null) {
                object = Base64Transformer.encodeBase64(object2, 0, ((byte[])object2).length);
                element.appendChild(document.createTextNode(new String((byte[])object)));
            }
            element2.appendChild(element);
            element2.appendChild(document.createTextNode("\n      "));
        }
        try {
            if (this.f != null) {
                element = document.createElementNS(string, string2 + "X509CRL");
                object2 = new byte[this.f.getDERLen(0)];
                this.f.getDEREncoding((byte[])object2, 0, 0);
                object = Base64Transformer.encodeBase64(object2, 0, ((byte[])object2).length);
                element.appendChild(document.createTextNode(new String((byte[])object)));
                element2.appendChild(element);
                element2.appendChild(document.createTextNode("\n      "));
            }
            if (this.a != null && this.a.size() > 0) {
                for (int i = 0; i < this.a.size(); ++i) {
                    object2 = document.createElementNS(string, string2 + "X509Certificate");
                    if (this.a.elementAt(i) == null) continue;
                    object = (X509Certificate)this.a.elementAt(i);
                    byte[] byArray = new byte[((X509Certificate)object).getDERLen(0)];
                    ((X509Certificate)object).getDEREncoding(byArray, 0, 0);
                    byte[] byArray2 = Base64Transformer.encodeBase64(byArray, 0, byArray.length);
                    object2.appendChild(document.createTextNode(new String(byArray2)));
                    element2.appendChild((Node)object2);
                    element2.appendChild(i == this.a.size() - 1 ? document.createTextNode("\n    ") : document.createTextNode("\n      "));
                }
            }
        }
        catch (CertificateException certificateException) {
            throw new XMLException("Error in generating X509Data element:Can't load X509Certificate data: " + certificateException.getMessage());
        }
        return element2;
    }

    public void parseKeyInfo(Element element, String string) throws XMLException {
        NodeList nodeList = null;
        if (element != null) {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                NodeList nodeList2 = element.getElementsByTagNameNS(string, "X509CRL");
                if (nodeList2.getLength() > 0 && (nodeList = nodeList2.item(0).getChildNodes()).getLength() > 0) {
                    object5 = nodeList.item(0).getNodeValue();
                    object4 = Base64Transformer.decodeBase64Data(((String)object5).getBytes(), 0, ((String)object5).getBytes().length);
                    this.f = new X509CRL((byte[])object4, 0, 0);
                }
                if ((object5 = element.getElementsByTagNameNS(string, "X509SubjectName")).getLength() > 0 && (nodeList = object5.item(0).getChildNodes()).getLength() > 0) {
                    object4 = nodeList.item(0).getNodeValue();
                    object4 = ((String)object4).replace('\n', ' ');
                    object4 = this.a((String)object4);
                    this.d = new X500Name((String)object4);
                }
                if ((object4 = element.getElementsByTagNameNS(string, "X509SKI")).getLength() > 0 && (nodeList = object4.item(0).getChildNodes()).getLength() > 0) {
                    object3 = nodeList.item(0).getNodeValue();
                    object2 = Base64Transformer.decodeBase64Data(((String)object3).getBytes(), 0, ((String)object3).getBytes().length);
                    this.e = new SubjectKeyID((byte[])object2, 0, ((Object)object2).length, false);
                }
                if ((object3 = element.getElementsByTagNameNS(string, "X509IssuerName")).getLength() > 0) {
                    object2 = element.getElementsByTagNameNS(string, "X509SerialNumber");
                    if (object2.getLength() == 0) {
                        throw new XMLException("IssuerName and serial number both are needed");
                    }
                    nodeList = object2.item(0).getChildNodes();
                    if (nodeList.getLength() > 0) {
                        this.c = ParserHandler.intStringToByteArray(nodeList.item(0).getNodeValue());
                    }
                    if ((nodeList = object3.item(0).getChildNodes()).getLength() > 0) {
                        object = nodeList.item(0).getNodeValue();
                        object = ((String)object).replace('\n', ' ');
                        object = this.a((String)object);
                        this.b = new X500Name((String)object);
                    }
                }
                if ((object2 = element.getElementsByTagNameNS(string, "X509Certificate")).getLength() > 0) {
                    if (this.a == null) {
                        this.a = new Vector(object2.getLength());
                    } else {
                        this.a.ensureCapacity(object2.getLength());
                        this.a.removeAllElements();
                    }
                }
                object = null;
                byte[] byArray = null;
                String string2 = null;
                for (int i = 0; i < object2.getLength(); ++i) {
                    nodeList = object2.item(i).getChildNodes();
                    if (nodeList.getLength() <= 0 || (string2 = nodeList.item(0).getNodeValue()) == null || (byArray = Base64Transformer.decodeBase64Data(string2.getBytes(), 0, string2.getBytes().length)) == null) continue;
                    object = new X509Certificate(byArray, 0, 0);
                    this.a.insertElementAt(object, i);
                }
            }
            catch (Exception exception) {
                throw new XMLException("Error in loading X509Certificate: " + exception.getMessage());
            }
        }
    }

    private String a(String string) {
        int n = 0;
        for (int i = string.length(); i >= 0; --i) {
            if (string.substring(i - 1, i).equals(" ")) continue;
            n = i;
            return string.substring(0, n);
        }
        return string.substring(0, n);
    }

    public void setX509SubjectName(X500Name x500Name) {
        this.d = x500Name;
    }

    public void setX509IssuerSerial(X500Name x500Name, byte[] byArray) {
        this.b = x500Name;
        this.c = byArray;
    }

    public void setX509SKI(SubjectKeyID subjectKeyID) {
        this.e = subjectKeyID;
    }

    public void setX509CRL(X509CRL x509CRL) {
        this.f = x509CRL;
    }

    public void setKey(JSAFE_PublicKey jSAFE_PublicKey) throws XMLException {
        throw new XMLException("X509Data should not store key");
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray != null) {
            if (this.a == null) {
                this.a = new Vector(certificateArray.length);
            } else {
                this.a.ensureCapacity(certificateArray.length);
                this.a.removeAllElements();
            }
            for (int i = 0; i < certificateArray.length; ++i) {
                this.a.addElement(certificateArray[i]);
            }
        }
    }

    public Certificate[] getCertificates(CertJ certJ) throws XMLException {
        Object[] objectArray = null;
        if (this.a == null) {
            if (certJ == null) {
                throw new XMLException("Can't retrieve certificates: certj object is null");
            }
            try {
                int n;
                DatabaseService databaseService = (DatabaseService)certJ.bindServices(1);
                if (this.f != null) {
                    databaseService.insertCRL(this.f);
                }
                Vector vector = new Vector();
                if (this.b != null && this.c == null || this.c != null && this.b == null) {
                    throw new XMLException("Serial number and issuer name must be present at the same time");
                }
                if (this.b != null) {
                    databaseService.selectCertificateByIssuerAndSerialNumber(this.b, this.c, vector);
                }
                if (this.d != null) {
                    if (vector.size() == 0) {
                        databaseService.selectCertificateBySubject(this.d, vector);
                    } else {
                        for (n = 0; n < vector.size(); ++n) {
                            if (!((X509Certificate)vector.elementAt(n)).compareSubjectName(this.d)) continue;
                            if (this.a == null) {
                                this.a = new Vector();
                            }
                            this.a.addElement(vector.elementAt(n));
                        }
                    }
                }
                if (this.e != null) {
                    X509V3Extensions x509V3Extensions = null;
                    if (vector.size() == 0) {
                        x509V3Extensions = new X509V3Extensions(1);
                        x509V3Extensions.addV3Extension(this.e);
                        databaseService.selectCertificateByExtensions(null, x509V3Extensions, vector);
                    } else {
                        for (int i = 0; i < vector.size(); ++i) {
                            byte[] byArray;
                            byte[] byArray2;
                            SubjectKeyID subjectKeyID;
                            x509V3Extensions = ((X509Certificate)vector.elementAt(i)).getExtensions();
                            if (x509V3Extensions == null || (subjectKeyID = (SubjectKeyID)x509V3Extensions.getExtensionByType(14)) == null || !CertJUtils.byteArraysEqual(byArray2 = subjectKeyID.getKeyID(), byArray = this.e.getKeyID())) continue;
                            if (this.a == null) {
                                this.a = new Vector();
                            }
                            this.a.addElement(vector.elementAt(i));
                        }
                    }
                }
                if (vector.size() == 0) {
                    throw new XMLException("Can't retrieve certificate.");
                }
                if (this.a == null) {
                    this.a = new Vector(vector.size());
                    for (n = 0; n < vector.size(); ++n) {
                        this.a.addElement(vector.elementAt(n));
                    }
                    objectArray = new X509Certificate[this.a.size()];
                    this.a.copyInto(objectArray);
                    return objectArray;
                }
            }
            catch (CertJException certJException) {
                throw new XMLException("Can't retrieve certificate: " + certJException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new XMLException("Can't retrieve certificate: " + certificateException.getMessage());
            }
        }
        objectArray = new X509Certificate[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public X509CRL getX509CRL() {
        return this.f;
    }

    public SubjectKeyID getX509SKI() {
        return this.e;
    }

    public X500Name getX509SubjectName() {
        return this.d;
    }

    public X500Name getX509IssuerName() {
        return this.b;
    }

    public byte[] getSerialNum() {
        return this.c;
    }

    public boolean hasKey() {
        return false;
    }

    public JSAFE_PublicKey getKey() {
        return null;
    }

    public boolean hasCertificate() {
        return this.a != null || this.c != null && this.b != null || this.e != null || this.d != null;
    }

    public Object clone() throws CloneNotSupportedException {
        X509Data x509Data = (X509Data)super.clone();
        if (this.b != null) {
            x509Data.b = (X500Name)this.b.clone();
        }
        if (this.c != null) {
            x509Data.c = (byte[])this.c.clone();
        }
        if (this.d != null) {
            x509Data.d = (X500Name)this.d.clone();
        }
        if (this.e != null) {
            x509Data.e = (SubjectKeyID)this.e.clone();
        }
        if (this.a != null) {
            x509Data.a = new Vector(this.a.size());
            for (int i = 0; i < this.a.size(); ++i) {
                x509Data.a.addElement(((X509Certificate)this.a.elementAt(i)).clone());
            }
        }
        if (this.f != null) {
            x509Data.f = (X509CRL)this.f.clone();
        }
        return x509Data;
    }
}

