/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.KeyInfo;
import com.rsa.certj.xml.ParserHandler;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.dsig.Reference;
import com.rsa.certj.xml.dsig.XMLSignature;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RetrievalMethod
extends KeyInfo
implements Cloneable,
Serializable {
    private JSAFE_PublicKey a = null;
    private Certificate[] b = null;
    private String c = null;
    private String d = null;
    private KeyInfo e = null;

    public RetrievalMethod() {
    }

    public RetrievalMethod(String string) {
        this.c = string;
    }

    public RetrievalMethod(String string, String string2) {
        this.c = string;
        this.d = string2;
    }

    public int getKeyInfoType() {
        return 3;
    }

    public String getKeyInfoName() {
        return "RetrievalMethod";
    }

    public Element generateKeyInfo(Document document, String string, String string2) throws XMLException {
        if (document == null) {
            throw new XMLException("Error in genrating RetrievalMethod: root document not available");
        }
        if (this.c == null) {
            throw new XMLException("Error in genrating RetrievalMethod: URI not set");
        }
        Element element = document.createElementNS(string, string2 + "RetrievalMethod");
        element.setAttribute("URI", this.c);
        if (this.d != null) {
            element.setAttribute("Type", this.d);
        }
        return element;
    }

    public void parseKeyInfo(Element element, String string) throws XMLException {
        if (element == null) {
            throw new XMLException("Error in parsing retrievalMethod: KeyInfo element is null");
        }
        Attr attr = element.getAttributeNode("URI");
        Attr attr2 = element.getAttributeNode("Type");
        if (attr != null) {
            this.c = attr.getNodeValue();
        }
        if (attr2 != null) {
            this.d = attr2.getNodeValue();
        }
        this.a(element, string);
    }

    private void a(Node node, String string) throws XMLException {
        if (this.c == null) {
            throw new XMLException("Error in reading RetrievalMethod: URI is required");
        }
        Element element = this.a(node);
        if (element == null) {
            if (this.b == null) {
                throw new XMLException("Error in reading RetreivalMethod:Can't get KeyInfo from:" + this.c);
            }
            return;
        }
        if (string == null) {
            string = element.getNamespaceURI();
        }
        if (!XMLSignature.SUPPORTED_XML_NAMESPACES[0].equals(string) && !XMLSignature.SUPPORTED_XML_NAMESPACES[1].equals(string)) {
            throw new XMLException("Error in reading RetrievalMethod:unsupported namespace.");
        }
        String string2 = null;
        if (this.d == null) {
            string2 = element.getNodeName();
            if (string2.equals("X509Certificate")) {
                try {
                    this.b = new X509Certificate[1];
                    byte[] byArray = element.getChildNodes().item(0).getNodeValue().getBytes();
                    byte[] byArray2 = Base64Transformer.decodeBase64Data(byArray, 0, byArray.length);
                    this.b[0] = new X509Certificate(byArray2, 0, 0);
                }
                catch (CertificateException certificateException) {
                    throw new XMLException("Error in parsing RetrievalMethod:Can't retrieve certificate: " + certificateException.getMessage());
                }
            } else {
                this.e = KeyInfo.getInstance(string2);
                if (this.e == null) {
                    throw new XMLException("Unsupported keyInfo type");
                }
                this.e.parseKeyInfo(element, string);
            }
        } else if (this.d.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
            try {
                if (element.getNodeName().equals("X509Certificate")) {
                    this.b = new X509Certificate[1];
                    byte[] byArray = element.getChildNodes().item(0).getNodeValue().getBytes();
                    byte[] byArray3 = Base64Transformer.decodeBase64Data(byArray, 0, byArray.length);
                    this.b[0] = new X509Certificate(byArray3, 0, 0);
                }
                NodeList nodeList = element.getElementsByTagName("X509Certificate");
                if (nodeList.getLength() == 0) {
                    throw new XMLException("No keyInfo data available");
                }
                this.b = new X509Certificate[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    byte[] byArray = nodeList.item(i).getChildNodes().item(0).getNodeValue().getBytes();
                    byte[] byArray4 = Base64Transformer.decodeBase64Data(byArray, 0, byArray.length);
                    this.b[i] = new X509Certificate(byArray4, 0, 0);
                }
            }
            catch (CertificateException certificateException) {
                throw new XMLException("Error in parsing RetrievalMethod:Can't retrieve certificate: " + certificateException.getMessage());
            }
        } else if (this.d.equals("http://www.w3.org/2000/09/xmldsig#X509Data") || this.d.equals("http://www.w3.org/2000/09/xmldsig#PGPData") || this.d.equals("http://www.w3.org/2000/09/xmldsig#SPKIData") || this.d.equals("http://www.w3.org/2000/09/xmldsig#MgmtData")) {
            string2 = this.d.substring(this.d.indexOf("#") + 1);
            this.e = KeyInfo.getInstance(string2);
            if (this.e == null) {
                throw new XMLException("Not supported KeyInfo type referred by RetrievalMethod");
            }
            this.e.parseKeyInfo(element, string);
        } else {
            throw new XMLException("Wrong keyInfo type in RetrievalMethod");
        }
    }

    private Element a(Node node) throws XMLException {
        InputStream inputStream = null;
        Document document = null;
        try {
            if (this.c.equals("")) {
                if (node == null) {
                    return null;
                }
                return (Element)((Object)node.getOwnerDocument());
            }
            if (this.c.indexOf("#") < 0) {
                Element element = null;
                URL uRL = new URL(this.c);
                inputStream = uRL.openStream();
                InputSource inputSource = new InputSource(inputStream);
                try {
                    element = ParserHandler.parseXML(inputSource).getDocumentElement();
                }
                catch (XMLException xMLException) {
                    inputStream.close();
                    inputStream = uRL.openStream();
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    this.b = new X509Certificate[1];
                    try {
                        this.b[0] = new X509Certificate(byArray, 0, 0);
                    }
                    catch (CertificateException certificateException) {
                        throw new XMLException(certificateException.getMessage());
                    }
                }
                inputStream.close();
                return element;
            }
            if (this.c.indexOf("#") == 0) {
                if (node == null) {
                    return null;
                }
                document = node.getOwnerDocument();
                return Reference.resolveId(document, this.c.substring(this.c.indexOf("#") + 1));
            }
            String string = this.c.substring(0, this.c.indexOf("#"));
            URL uRL = new URL(string);
            inputStream = uRL.openConnection().getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            document = ParserHandler.parseXML(inputSource);
            inputStream.close();
            return Reference.resolveId(document, this.c.substring(this.c.indexOf("#") + 1));
        }
        catch (Exception exception) {
            throw new XMLException("Internal Error: " + exception.getMessage());
        }
    }

    public void setURI(String string) {
        this.c = string;
    }

    public void setType(String string) {
        this.d = string;
    }

    public Certificate[] getCertificates(CertJ certJ) throws XMLException {
        if (this.b == null) {
            if (this.e == null) {
                this.a(null, null);
            }
            if (this.e == null) {
                return null;
            }
            this.b = this.e.getCertificates(certJ);
        }
        return this.b;
    }

    public JSAFE_PublicKey getKey() throws XMLException {
        if (this.a == null) {
            if (this.e == null) {
                this.a(null, null);
            }
            if (this.e == null) {
                return null;
            }
            this.a = this.e.getKey();
        }
        return this.a;
    }

    public boolean hasKey() throws XMLException {
        if (this.a == null) {
            if (this.e == null) {
                this.a(null, null);
            }
            if (this.e != null) {
                return this.e.hasKey();
            }
            return false;
        }
        return true;
    }

    public boolean hasCertificate() throws XMLException {
        if (this.b == null) {
            if (this.e == null) {
                this.a(null, null);
            }
            if (this.b != null) {
                return true;
            }
            if (this.e != null) {
                return this.e.hasCertificate();
            }
            return false;
        }
        return true;
    }

    public void setKey(JSAFE_PublicKey jSAFE_PublicKey) throws XMLException {
        throw new XMLException("RetrievalMethod should not store a key directly");
    }

    public void setCertificates(Certificate[] certificateArray) throws XMLException {
        throw new XMLException("RetrievalMethod should not store certificates directly");
    }

    public Object clone() throws CloneNotSupportedException {
        RetrievalMethod retrievalMethod = (RetrievalMethod)super.clone();
        if (this.c != null) {
            retrievalMethod.c = this.c;
        }
        if (this.d != null) {
            retrievalMethod.d = this.d;
        }
        return retrievalMethod;
    }
}

