/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.KeyInfo;
import com.rsa.certj.xml.XMLException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyValue
extends KeyInfo
implements Cloneable,
Serializable {
    private JSAFE_PublicKey a = null;

    public KeyValue() {
    }

    public KeyValue(JSAFE_PublicKey jSAFE_PublicKey) {
        this.a = jSAFE_PublicKey;
    }

    public int getKeyInfoType() {
        return 1;
    }

    public String getKeyInfoName() {
        return "KeyValue";
    }

    public Element generateKeyInfo(Document document, String string, String string2) throws XMLException {
        if (this.a == null) {
            throw new XMLException("Error in generating KeyValue element:Public key not set");
        }
        Element element = document.createElementNS(string, string2 + "KeyValue");
        element.appendChild(document.createTextNode("\n    "));
        byte[][] byArray = null;
        if ("DSA".equals(this.a.getAlgorithm())) {
            Element element2 = document.createElementNS(string, string2 + "DSAKeyValue");
            element2.appendChild(document.createTextNode("\n        "));
            try {
                byArray = this.a.getKeyData("DSAPublicKey");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Error in generating KeyValue element: " + jSAFE_Exception.getMessage());
            }
            if (byArray != null && byArray[0] != null && byArray[1] != null && byArray[2] != null && byArray[3] != null) {
                Element element3 = document.createElementNS(string, string2 + "P");
                String string3 = new String(Base64Transformer.encodeBase64(byArray[0], 0, byArray[0].length));
                element3.appendChild(document.createTextNode(string3));
                element2.appendChild(element3);
                element2.appendChild(document.createTextNode("\n        "));
                Element element4 = document.createElementNS(string, string2 + "Q");
                String string4 = new String(Base64Transformer.encodeBase64(byArray[1], 0, byArray[1].length));
                element4.appendChild(document.createTextNode(string4));
                element2.appendChild(element4);
                element2.appendChild(document.createTextNode("\n        "));
                Element element5 = document.createElementNS(string, string2 + "G");
                String string5 = new String(Base64Transformer.encodeBase64(byArray[2], 0, byArray[2].length));
                element5.appendChild(document.createTextNode(string5));
                element2.appendChild(element5);
                element2.appendChild(document.createTextNode("\n        "));
                Element element6 = document.createElementNS(string, string2 + "Y");
                String string6 = new String(Base64Transformer.encodeBase64(byArray[3], 0, byArray[3].length));
                element6.appendChild(document.createTextNode(string6));
                element2.appendChild(element6);
                element2.appendChild(document.createTextNode("\n      "));
                element.appendChild(element2);
                element.appendChild(document.createTextNode("\n    "));
            }
        } else if (this.a.getAlgorithm().equals("RSA")) {
            try {
                byArray = this.a.getKeyData("RSAPublicKey");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Error in generating KeyValue element: " + jSAFE_Exception.getMessage());
            }
            Element element7 = document.createElementNS(string, string2 + "RSAKeyValue");
            element7.appendChild(document.createTextNode("\n        "));
            if (byArray != null && byArray[0] != null && byArray[1] != null) {
                Element element8 = document.createElementNS(string, string2 + "Modulus");
                String string7 = new String(Base64Transformer.encodeBase64(byArray[0], 0, byArray[0].length));
                element8.appendChild(document.createTextNode(string7));
                element7.appendChild(element8);
                element7.appendChild(document.createTextNode("\n        "));
                Element element9 = document.createElementNS(string, string2 + "Exponent");
                String string8 = new String(Base64Transformer.encodeBase64(byArray[1], 0, byArray[1].length));
                element9.appendChild(document.createTextNode(string8));
                element7.appendChild(element9);
                element7.appendChild(document.createTextNode("\n      "));
            }
            element.appendChild(element7);
            element.appendChild(document.createTextNode("\n    "));
        } else {
            throw new XMLException("Error in generating KeyValue element:Unsupported key type");
        }
        return element;
    }

    public void parseKeyInfo(Element element, String string) throws XMLException {
        block16: {
            if (element == null) {
                throw new XMLException("KeyValue is empty");
            }
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            for (n = 0; n < nodeList.getLength() && nodeList.item(n).getNodeType() != 1; ++n) {
            }
            if (nodeList.item(n) == null) {
                throw new XMLException("KeyValue has no child");
            }
            String string2 = nodeList.item(n).getNodeName();
            Object object = null;
            try {
                if (string2.endsWith("DSAKeyValue")) {
                    NodeList nodeList2 = element.getElementsByTagNameNS(string, "P");
                    NodeList nodeList3 = element.getElementsByTagNameNS(string, "Q");
                    NodeList nodeList4 = element.getElementsByTagNameNS(string, "G");
                    NodeList nodeList5 = element.getElementsByTagNameNS(string, "Y");
                    if (nodeList2.getLength() == 0 || nodeList3.getLength() == 0 || nodeList4.getLength() == 0 || nodeList5.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue: One of the parameters not set in DSAKey element: P/Q/G/Y");
                    }
                    NodeList nodeList6 = nodeList2.item(0).getChildNodes();
                    if (nodeList6.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue element: Content of P not set");
                    }
                    String string3 = nodeList6.item(0).getNodeValue();
                    nodeList6 = nodeList3.item(0).getChildNodes();
                    if (nodeList6.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue element: Content of Q not set");
                    }
                    String string4 = nodeList6.item(0).getNodeValue();
                    nodeList6 = nodeList4.item(0).getChildNodes();
                    if (nodeList6.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue element: Content of G not set");
                    }
                    String string5 = nodeList6.item(0).getNodeValue();
                    nodeList6 = nodeList5.item(0).getChildNodes();
                    if (nodeList6.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue element: Content of Y not set");
                    }
                    String string6 = nodeList6.item(0).getNodeValue();
                    object = new byte[4][];
                    object[0] = Base64Transformer.decodeBase64Data(string3.getBytes(), 0, string3.getBytes().length);
                    object[1] = Base64Transformer.decodeBase64Data(string4.getBytes(), 0, string4.getBytes().length);
                    object[2] = Base64Transformer.decodeBase64Data(string5.getBytes(), 0, string5.getBytes().length);
                    object[3] = Base64Transformer.decodeBase64Data(string6.getBytes(), 0, string6.getBytes().length);
                    this.a = JSAFE_PublicKey.getInstance((String)"DSA", (String)"Java");
                    this.a.setKeyData("DSAPublicKey", object);
                    break block16;
                }
                if (string2.endsWith("RSAKeyValue")) {
                    this.a = JSAFE_PublicKey.getInstance((String)"RSA", (String)"Java");
                    NodeList nodeList7 = element.getElementsByTagNameNS(string, "Modulus");
                    if (nodeList7.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue:Modulus missed in RSAKey element");
                    }
                    NodeList nodeList8 = nodeList7.item(0).getChildNodes();
                    if (nodeList8.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue:Modulus content not set in RSAKey element");
                    }
                    String string7 = nodeList8.item(0).getNodeValue();
                    NodeList nodeList9 = element.getElementsByTagNameNS(string, "Exponent");
                    if (nodeList9.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue:Exponent missed in RSAKey element");
                    }
                    nodeList8 = nodeList9.item(0).getChildNodes();
                    if (nodeList8.getLength() == 0) {
                        throw new XMLException("Error in reading KeyValue:Exponent content not set in RSAKey element");
                    }
                    String string8 = nodeList8.item(0).getNodeValue();
                    object = new byte[2][];
                    object[0] = Base64Transformer.decodeBase64Data(string7.getBytes(), 0, string7.getBytes().length);
                    object[1] = Base64Transformer.decodeBase64Data(string8.getBytes(), 0, string8.getBytes().length);
                    this.a.setKeyData("RSAPublicKey", object);
                    break block16;
                }
                throw new XMLException("Error in reading KeyValue:Unsupported key type");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new XMLException("Error in parsing KeyValue:" + jSAFE_Exception.getMessage());
            }
        }
    }

    public void setKey(JSAFE_PublicKey jSAFE_PublicKey) {
        this.a = jSAFE_PublicKey;
    }

    public void setCertificates(Certificate[] certificateArray) throws XMLException {
        throw new XMLException("KeyValue should not contain certificates");
    }

    public JSAFE_PublicKey getKey() {
        return this.a;
    }

    public boolean hasCertificate() {
        return false;
    }

    public boolean hasKey() {
        return true;
    }

    public Certificate[] getCertificates(CertJ certJ) {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        KeyValue keyValue = (KeyValue)super.clone();
        if (this.a != null) {
            keyValue.a = (JSAFE_PublicKey)this.a.clone();
        }
        return keyValue;
    }
}

