/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.CertJ;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.xml.Cah;
import com.rsa.certj.xml.XMLException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class Canonicalizer {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String S_XMLNS = "xmlns";
    private static final String a = "UTF-8";

    private Canonicalizer() {
    }

    public static byte[] canonicalizeNodeset(Node node, boolean bl) throws XMLException {
        if (node == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, a);
            if (node.getNodeType() == 9) {
                Canonicalizer.a(null, null, node, null, bl, false, outputStreamWriter);
            } else {
                Canonicalizer.a(node, null, node, null, bl, true, outputStreamWriter);
            }
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new XMLException("Can't canonicalize input: " + iOException.getMessage());
        }
    }

    public static byte[] canonicalizeNodeset(NodeList nodeList, boolean bl) throws XMLException {
        if (nodeList == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, a);
            Canonicalizer.a(nodeList, bl, outputStreamWriter);
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new XMLException("Can't canonicalize input: " + iOException.getMessage());
        }
    }

    private static void a(NodeList nodeList, boolean bl, Writer writer) throws IOException, XMLException {
        Vector<Object> vector = new Vector<Object>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            Object object;
            Hashtable<String, Node> hashtable;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 2) {
                vector.addElement(node2);
                if (node2.getNodeType() != 1) continue;
                hashtable = null;
                if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS)) {
                    hashtable = Canonicalizer.collectAncestorsXMLPrefix(node2);
                }
                object = null;
                if (i + 1 < nodeList.getLength()) {
                    object = nodeList.item(i + 1);
                    if (object.getNodeType() == 2 && ((Attr)object).getOwnerElement() == node2) {
                        if (hashtable == null) {
                            hashtable = new Hashtable<String, Node>();
                        }
                        ++i;
                        while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && node2 == ((Attr)node).getOwnerElement()) {
                            hashtable.put(node.getNodeName(), node);
                            ++i;
                        }
                        --i;
                    }
                    if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && hashtable != null && hashtable.containsKey(S_XMLNS) && ((Attr)hashtable.get(S_XMLNS)).getNodeValue().length() == 0) {
                        hashtable.remove(S_XMLNS);
                    }
                    vector.addElement(new Cah(node2, hashtable));
                    continue;
                }
                if (hashtable == null) continue;
                vector.addElement(new Cah(node2, hashtable));
                continue;
            }
            hashtable = ((Attr)node2).getOwnerElement();
            object = new Hashtable();
            while (i < nodeList.getLength() && (node = nodeList.item(i)).getNodeType() == 2 && hashtable == ((Attr)node).getOwnerElement()) {
                ((Hashtable)object).put(node.getNodeName(), node);
                ++i;
            }
            vector.addElement(new Cah((Node)((Object)hashtable), (Hashtable)object));
            --i;
        }
        Stack stack = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            Canonicalizer.a(stack, vector, i, bl, writer);
        }
    }

    private static void a(Stack stack, Vector vector, int n, boolean bl, Writer writer) throws IOException, XMLException {
        Node node;
        Object e = vector.elementAt(n);
        if (e == null) {
            return;
        }
        if (e instanceof Cah) {
            vector.setElementAt(null, n);
            ((Cah)e).a(null, writer);
            return;
        }
        Node node2 = (Node)e;
        short s = node2.getNodeType();
        if (s == 9) {
            return;
        }
        if (s != 1) {
            Canonicalizer.a(null, null, node2, null, bl, true, writer);
            return;
        }
        writer.write("<");
        writer.write(node2.getNodeName());
        Cah cah = stack.empty() ? null : (Cah)stack.peek();
        Cah cah2 = null;
        int n2 = n + 1;
        if (n2 >= vector.size() || vector.elementAt(n2) instanceof Node) {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && (node = node2.getParentNode()) != null && node.getNodeType() != 9 && cah != null && cah.b() != null && cah.b().containsKey(S_XMLNS)) {
                writer.write(" xmlns=\"\"");
            }
        } else {
            cah2 = (Cah)vector.elementAt(n2);
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ211_COMPATIBILITY_XMLNS) && cah2 != null && cah2.b() != null && !cah2.b().containsKey(S_XMLNS) && (node = node2.getParentNode()) != null && node.getNodeType() != 9 && cah != null && cah.b() != null && cah.b().containsKey(S_XMLNS)) {
                writer.write(" xmlns=\"\"");
            }
            if (cah2 != null) {
                cah2.a(cah, writer);
            }
            vector.setElementAt(null, n2);
        }
        writer.write(">");
        stack.push(cah2);
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == null) {
                ++n2;
                continue;
            }
            if (!Canonicalizer.a(vector.elementAt(n2), node2)) break;
            Canonicalizer.a(stack, vector, n2, bl, writer);
            vector.setElementAt(null, n2++);
        }
        stack.pop();
        writer.write("</");
        writer.write(node2.getNodeName());
        writer.write(">");
    }

    private static boolean a(Object object, Node node) throws XMLException {
        if (object == null || node == null) {
            throw new XMLException("Can't find out which is ancestor");
        }
        Node node2 = null;
        node2 = object instanceof Cah ? ((Cah)object).a() : (Node)object;
        while (node2 != node) {
            if ((node2 = node2.getNodeType() == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode()) != null) continue;
            return false;
        }
        return true;
    }

    private static void a(Node node, Stack stack, Node node2, Node node3, boolean bl, boolean bl2, Writer writer) throws IOException, XMLException {
        if (node2 == null) {
            return;
        }
        if (node3 == node2) {
            return;
        }
        switch (node2.getNodeType()) {
            case 1: {
                if (stack == null) {
                    stack = new Stack();
                }
                writer.write("<");
                writer.write(node2.getNodeName());
                Canonicalizer.a(node, stack, (Element)node2, bl2, writer);
                writer.write(">");
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    Canonicalizer.a(node, stack, node4, node3, bl, bl2, writer);
                }
                stack.pop();
                writer.write("</");
                writer.write(node2.getNodeName());
                writer.write(">");
                break;
            }
            case 3: 
            case 4: {
                String string = node2.getNodeValue();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '<') {
                        writer.write("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        writer.write("&gt;");
                        continue;
                    }
                    if (c == '&') {
                        writer.write("&amp;");
                        continue;
                    }
                    if (c == '\r') {
                        writer.write("&#xD;");
                        continue;
                    }
                    writer.write(c);
                }
                break;
            }
            case 5: 
            case 9: {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    Canonicalizer.a(node, stack, node5, node3, bl, bl2, writer);
                }
                break;
            }
            case 7: {
                Canonicalizer.a(node2, writer);
                break;
            }
            case 8: {
                Canonicalizer.a(node2, writer, bl);
                break;
            }
            case 10: {
                break;
            }
            case 2: {
                Canonicalizer.canonicalizeAttribute((Attr)node2, writer);
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new XMLException("Invalid Node Type: " + node2.getNodeType());
            }
        }
    }

    private static boolean a(Node node, Element element) throws XMLException {
        if (node == element) {
            return true;
        }
        block5: for (Node node2 = element.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            switch (node2.getNodeType()) {
                case 9: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    continue block5;
                }
            }
            throw new XMLException("Unexpected node type: " + node2.getNodeType());
        }
        return true;
    }

    private static void a(Node node, Stack stack, Element element, boolean bl, Writer writer) throws IOException, XMLException {
        Object object;
        String[] stringArray;
        Hashtable hashtable;
        Hashtable hashtable2 = Canonicalizer.collectNSNodesInAncestors(element, false);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            hashtable2.put(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i));
        }
        if (bl && (hashtable = Canonicalizer.collectAncestorsXMLPrefix(element)) != null) {
            stringArray = hashtable.elements();
            while (stringArray.hasMoreElements()) {
                object = (Attr)stringArray.nextElement();
                hashtable2.put(object.getNodeName(), object);
            }
        }
        Hashtable hashtable3 = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable2);
        n = hashtable2.size();
        stringArray = new String[n];
        object = new int[n];
        Attr[] attrArray = new Attr[n];
        int n2 = 0;
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            object[n2] = n2;
            attrArray[n2] = attr;
            stringArray[n2] = Canonicalizer.createSortedString(attr, element);
            ++n2;
        }
        Canonicalizer.heapSort((int[])object, stringArray, n);
        for (int i = 0; i < n; ++i) {
            Attr attr;
            Attr attr2 = attrArray[object[i]];
            String string = attr2.getNodeName();
            if (string.equals("xmlns:xml")) continue;
            if (string.equals(S_XMLNS) && attr2.getNodeValue().length() == 0) {
                if (Canonicalizer.a(node, element)) continue;
                boolean bl2 = false;
                for (int j = stack.size() - 1; j >= 0; --j) {
                    Hashtable hashtable4 = (Hashtable)stack.elementAt(j);
                    Attr attr3 = (Attr)hashtable4.get(S_XMLNS);
                    if (attr3 == null || attr3.getNodeValue().length() <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
            }
            if ((string.equals(S_XMLNS) || string.startsWith("xmlns:")) && hashtable3 != null && (attr = (Attr)hashtable3.get(string)) != null && attr.getNodeValue().equals(attr2.getNodeValue())) continue;
            Canonicalizer.canonicalizeAttribute(attr2, writer);
        }
    }

    private static void a(Node node, Writer writer, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            return;
        }
        if (node.getParentNode().getNodeType() == 9) {
            Node node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl2 = true;
            } else {
                bl3 = true;
            }
        }
        if (bl3) {
            writer.write("\n");
        }
        writer.write("<!--");
        writer.write(node.getNodeValue());
        writer.write("-->");
        if (bl2) {
            writer.write("\n");
        }
    }

    private static void a(Node node, Writer writer) throws IOException {
        Node node2;
        boolean bl = false;
        boolean bl2 = false;
        if (node.getParentNode().getNodeType() == 9) {
            node2 = node;
            while ((node2 = node2.getPreviousSibling()) != null && node2.getNodeType() != 1) {
            }
            if (node2 == null) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        node2 = (ProcessingInstruction)node;
        if (bl2) {
            writer.write("\n");
        }
        writer.write("<?");
        writer.write(node2.getTarget());
        if (node2.getData() != null && node2.getData().length() > 0) {
            writer.write(" ");
            String string = node2.getData();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\r') continue;
                if (i > n) {
                    writer.write(string, n, i - n);
                }
                writer.write("&#xD;");
                n = i + 1;
            }
            if (n < string.length()) {
                writer.write(string, n, string.length() - n);
            }
        }
        writer.write("?>");
        if (bl) {
            writer.write("\n");
        }
    }

    protected static void canonicalizeAttribute(Attr attr, Writer writer) throws IOException, XMLException {
        String string = attr.getNodeName();
        boolean bl = string.equals(S_XMLNS) || string.startsWith("xmlns:");
        writer.write(" ");
        writer.write(string);
        writer.write("=\"");
        String string2 = attr.getNodeValue();
        boolean bl2 = false;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c == '\"') {
                writer.write("&quot;");
                continue;
            }
            if (c == '\t') {
                writer.write("&#x9;");
                continue;
            }
            if (c == '\n') {
                writer.write("&#xA;");
                continue;
            }
            if (c == '\r') {
                writer.write("&#xD;");
                continue;
            }
            if (bl) {
                if (c == ':') {
                    bl2 = true;
                } else if (c == '/' && !bl2) {
                    throw new XMLException("No relative URI: " + string2 + " allowed");
                }
            }
            writer.write(c);
        }
        if (string2.length() > 0 && bl && !bl2) {
            throw new XMLException("No relative URI: " + string2 + " allowed");
        }
        writer.write("\"");
    }

    protected static Hashtable collectNSNodesInAncestors(Node node, boolean bl) {
        Object object;
        Node node2 = node;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Document document = node.getOwnerDocument();
        if (bl) {
            hashtable.put("xmlns:xml", (Object)new AttrHelper(node, document, "xmlns:xml", XML_NAMESPACE));
        } else {
            object = document.createAttribute("xmlns:xml");
            object.setNodeValue(XML_NAMESPACE);
            hashtable.put("xmlns:xml", object);
        }
        do {
            if ((object = node2.getAttributes()) == null) continue;
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Attr attr = (Attr)object.item(i);
                String string = attr.getNodeName();
                if (!string.equals(S_XMLNS) && !string.startsWith("xmlns:") || hashtable.containsKey(string)) continue;
                if (node2 == node) {
                    hashtable.put(string, attr);
                    continue;
                }
                if (bl) {
                    object2 = new AttrHelper(node, document, string, attr.getNodeValue());
                    hashtable.put(string, object2);
                    continue;
                }
                object2 = document.createAttribute(string);
                object2.setNodeValue(attr.getNodeValue());
                hashtable.put(string, object2);
            }
        } while ((node2 = node2.getParentNode()) != null);
        return hashtable;
    }

    protected static Hashtable collectAncestorsXMLPrefix(Node node) {
        String string;
        Attr attr;
        int n;
        int n2;
        NamedNodeMap namedNodeMap;
        Hashtable<String, Attr> hashtable = null;
        Node node2 = node;
        while ((node2 = node2.getParentNode()) != null) {
            namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)namedNodeMap.item(n);
                string = attr.getNodeName();
                if (!string.startsWith("xml:") || hashtable != null && hashtable.containsKey(string)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Attr>();
                }
                hashtable.put(string, attr);
            }
        }
        if (hashtable != null && (namedNodeMap = node.getAttributes()) != null) {
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)namedNodeMap.item(n);
                string = attr.getNodeName();
                if (!string.startsWith("xml:") || !hashtable.containsKey(string)) continue;
                hashtable.remove(string);
            }
        }
        return hashtable;
    }

    protected static String createSortedString(Attr attr, Node node) throws XMLException {
        String string = null;
        if (attr == null) {
            return null;
        }
        if (attr.getNodeType() == 2) {
            String string2 = attr.getNodeName();
            if (string2.equals(S_XMLNS)) {
                return "\u0000";
            }
            int n = string2.indexOf(58);
            if (n <= 0) {
                return "\u0001" + string2;
            }
            String string3 = string2.substring(0, n).intern();
            if (string3.equals(S_XMLNS)) {
                return "\u0000" + string2.substring(n + 1);
            }
            String string4 = Canonicalizer.getNSForPrefix(string3, node);
            string = string4 == null || string4.length() == 0 ? "\u0001" + string2 : string4 + "\u0001" + string2.substring(n + 1);
        } else {
            throw new XMLException("Requires an Attr node.");
        }
        return string;
    }

    protected static String getNSForPrefix(String string, Node node) {
        short s;
        if (string == null) {
            return null;
        }
        if (string.equals("xml")) {
            return XML_NAMESPACE;
        }
        if (string.equals(S_XMLNS)) {
            return string;
        }
        String string2 = string.length() == 0 ? S_XMLNS : "xmlns:" + string;
        Node node2 = node;
        do {
            Attr attr;
            Attr attr2 = attr = node2.getAttributes().getLength() == 0 ? null : ((Element)node2).getAttributeNode(string2);
            if (attr != null) {
                return attr.getNodeValue();
            }
            do {
                if ((node2 = node2.getParentNode()) != null) continue;
                return string2 == S_XMLNS ? "" : null;
            } while ((s = node2.getNodeType()) == 5);
        } while (s == 1);
        return string2 == S_XMLNS ? "" : null;
    }

    protected static void heapSort(int[] nArray, String[] stringArray, int n) {
        int n2;
        for (n2 = n / 2; n2 >= 0; --n2) {
            Canonicalizer.a(nArray, stringArray, n, n2);
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            int n3 = nArray[0];
            nArray[0] = nArray[n2];
            nArray[n2] = n3;
            Canonicalizer.a(nArray, stringArray, n2, 0);
        }
    }

    private static void a(int[] nArray, String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && 0 > stringArray[nArray[n3]].compareTo(stringArray[nArray[n3 + 1]])) {
                n3 = 2 * n2 + 2;
            }
            if (0 > Canonicalizer.a(stringArray[nArray[n2]], stringArray[nArray[n3]])) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
                Canonicalizer.a(nArray, stringArray, n, n3);
            }
        }
    }

    private static int a(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = n2 < (n = string2.length()) ? n2 : n;
        int n4 = 0;
        int n5 = 0;
        while (n3-- != 0) {
            char c;
            char c2;
            if ((c2 = string.charAt(n4++)) == (c = string2.charAt(n5++))) continue;
            return c2 - c;
        }
        return n2 - n;
    }

    private static class AttrHelper
    extends AttrImpl {
        private Element a;

        AttrHelper(Node node, Document document, String string, String string2) {
            super((CoreDocumentImpl)((DocumentImpl)document), string);
            this.setValue(string2);
            this.a = (Element)node;
        }

        public Element getOwnerElement() {
            return this.a;
        }
    }
}

