/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.spi.pki.PKIException;

public class PKIStatusInfo {
    public static final int PKI_STATUS_GRANTED = 0;
    public static final int PKI_STATUS_GRANTED_MODS = 1;
    public static final int PKI_STATUS_REJECTED = 2;
    public static final int PKI_STATUS_WAITING = 3;
    public static final int PKI_STATUS_WARNING_REVOCATION = 4;
    public static final int PKI_REVOCATION = 5;
    public static final int PKI_STATUS_REVOCATION = 5;
    public static final int PKI_STATUS_WARNING_KEY_UPDATE = 6;
    public static final int PKI_FAIL_BAD_ALG = Integer.MIN_VALUE;
    public static final int PKI_FAIL_BAD_MESSAGE_CHECK = 0x40000000;
    public static final int PKI_FAIL_BAD_REQUEST = 0x20000000;
    public static final int PKI_FAIL_BAD_TIME = 0x10000000;
    public static final int PKI_FAIL_BAD_CERT_ID = 0x8000000;
    public static final int PKI_FAIL_BAD_DATA_FORMAT = 0x4000000;
    public static final int PKI_FAIL_WRONG_AUTHORITY = 0x2000000;
    public static final int PKI_FAIL_INCORRECT_DATA = 0x1000000;
    public static final int PKI_FAIL_MISSING_TIMESTAMP = 0x800000;
    public static final int PKI_FAIL_BAD_POP = 0x400000;
    public static final int PKI_FAIL_SERVER_ERROR = 0x200000;
    public static final int PKI_FAIL_REMOTE_SERVER_ERROR = 0x100000;
    public static final int PKI_FAIL_CERT_REVOKED = 524288;
    public static final int PKI_FAIL_CERT_CONFIRMED = 262144;
    public static final int PKI_FAIL_WRONG_INTEGRITY = 131072;
    public static final int PKI_FAIL_BAD_RECIPIENT_NONCE = 65536;
    public static final int PKI_FAIL_TIME_NOT_AVALIABLE = 32768;
    public static final int PKI_FAIL_UNACCEPTED_POLICY = 16384;
    public static final int PKI_FAIL_UNACCEPTED_EXTENSION = 8192;
    public static final int PKI_FAIL_ADD_INFO_NOT_AVAILABLE = 4096;
    public static final int PKI_FAIL_BAD_SENDER_NONCE = 2048;
    public static final int PKI_FAIL_BAD_CERT_TEMPLATE = 1024;
    public static final int PKI_FAIL_SIGNER_NOT_TRUSTED = 512;
    public static final int PKI_FAIL_TRANSACTION_ID_IN_USE = 256;
    public static final int PKI_FAIL_UNSUPPORTED_VERSION = 128;
    private int a;
    private int b = 0;
    private String[] c = null;
    private int d = 0;
    private ASN1Template e = null;

    public PKIStatusInfo(byte[] byArray, int n, int n2) throws PKIException {
        ASN1Container aSN1Container;
        IntegerContainer integerContainer = null;
        OfContainer ofContainer = null;
        BitStringContainer bitStringContainer = null;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            integerContainer = new IntegerContainer(0);
            ofContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(3072));
            bitStringContainer = new BitStringContainer(65536);
            EndContainer endContainer = new EndContainer();
            aSN1Container = new ASN1Container[]{sequenceContainer, integerContainer, ofContainer, bitStringContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1Container);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKIException("PKIStatusInfo.PKIStatusInfo: decoding PKIStatusInfo faild(" + aSN_Exception.getMessage() + ").");
        }
        try {
            this.a = integerContainer.getValueAsInt();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKIException("CertResponse.CertResponse: unable to get PKIStatusInfo.status as int(" + aSN_Exception.getMessage() + ").");
        }
        if (ofContainer.dataPresent) {
            int n3 = ofContainer.getContainerCount();
            this.c = new String[n3];
            for (int i = 0; i < n3; ++i) {
                try {
                    aSN1Container = ofContainer.containerAt(i);
                    UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{uTF8StringContainer};
                    ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray);
                    if (uTF8StringContainer.dataPresent && uTF8StringContainer.dataLen != 0) {
                        this.c[i] = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        continue;
                    }
                    this.c[i] = null;
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new PKIException("PKIStatusInfo.PKIStatusInfo: unable to extract and decode a component of statuString(" + aSN_Exception.getMessage() + ").");
                }
            }
        }
        if (bitStringContainer.dataPresent) {
            this.b = this.a(bitStringContainer);
        }
    }

    public PKIStatusInfo(int n, int n2, String[] stringArray, int n3) {
        this.a = n;
        this.b = n2;
        this.c = stringArray;
        this.d = n3;
    }

    public int getStatus() {
        return this.a;
    }

    public int getFailInfo() {
        return this.b;
    }

    public String[] getStatusStrings() {
        if (this.c == null) {
            return null;
        }
        return (String[])this.c.clone();
    }

    public int getFailInfoAux() {
        return this.d;
    }

    public int getDERLen(int n) throws PKIException {
        try {
            Object object;
            OfContainer ofContainer;
            SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.a);
            if (this.c == null) {
                ofContainer = new OfContainer(65536, false, 0, 12288, null);
            } else {
                ofContainer = new OfContainer(65536, true, 0, 12288, (ASN1Container)new UTF8StringContainer(0));
                for (int i = 0; i < this.c.length; ++i) {
                    object = this.c[i].getBytes();
                    try {
                        ofContainer.addContainer((ASN1Container)new UTF8StringContainer(0, true, 0, object, 0, ((byte[])object).length));
                        continue;
                    }
                    catch (ASN_Exception aSN_Exception) {
                        throw new PKIException("PKIStatusInfo.getDERLen: failed to add an element of statusString(" + aSN_Exception.getMessage() + ").");
                    }
                }
            }
            BitStringContainer bitStringContainer = this.b == 0 ? new BitStringContainer(65536, false, 0, 0, 0, false) : new BitStringContainer(65536, true, 0, this.b, 32, false);
            object = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, ofContainer, bitStringContainer, (ASN1Container)object};
            this.e = new ASN1Template(aSN1ContainerArray);
            return this.e.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            this.e = null;
            throw new PKIException("PKIStatusInfo.getDERLen: failed to encode PKIStatusInfo(" + aSN_Exception.getMessage() + ").");
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws PKIException {
        if (byArray == null) {
            throw new PKIException("PKIStatus.getDEREncoding: der should not be null.");
        }
        if (n < 0) {
            throw new PKIException("PKIStatus.getDEREncoding: offset should not be a negative number.");
        }
        if (this.e == null && byArray.length - n < this.getDERLen(n2)) {
            throw new PKIException("PKIStatus.getDEREncoding: der is too small to hold the DER-encoding. Use getDERLen to find out how big it should be.");
        }
        try {
            int n3 = this.e.derEncode(byArray, n);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKIException("PKIStatus.getDEREncoding: unable to encode PKIStatusInfo(" + aSN_Exception.getMessage() + ").");
        }
        finally {
            this.e = null;
        }
    }

    private int a(BitStringContainer bitStringContainer) {
        int n;
        int n2 = 0;
        for (n = 0; n < bitStringContainer.dataLen; ++n) {
            n2 = (n2 << 8) + bitStringContainer.data[bitStringContainer.dataOffset + n];
        }
        for (n = 0; n < 4 - bitStringContainer.dataLen; ++n) {
            n2 <<= 8;
        }
        return n2;
    }
}

