/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.path;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class CertPathCtx {
    public static final int PF_IGNORE_SIGNATURE = 1;
    public static final int PF_IGNORE_VALIDATION_TIME = 2;
    public static final int PF_IGNORE_REVOCATION = 4;
    public static final int PF_IGNORE_NAME_CHAINING = 8;
    public static final int PF_IGNORE_NAME_CONSTRAINTS = 16;
    public static final int PF_IGNORE_BASIC_CONSTRAINTS = 32;
    public static final int PF_IGNORE_KEY_USAGE = 64;
    public static final int PF_IGNORE_CRITICALITY = 128;
    public static final int PF_IGNORE_UID_CHAINING = 256;
    public static final int PF_IGNORE_KEY_ID_CHAINING = 512;
    public static final int PF_IGNORE_CRL_DP = 1024;
    public static final int PF_IGNORE_AIA = 2048;
    public static final int PF_IGNORE_CRL_NUMBER = 4096;
    public static final int PF_IGNORE_DELTA_CRL = 8192;
    public static final int PF_IGNORE_CRL_IDP = 16384;
    public static final int PF_INITIAL_EXPLICIT_POLICY = 32768;
    public static final int PF_INITIAL_POLICY_MAPPING_INHIBIT = 65536;
    public static final int PF_INITIAL_ANY_POLICY_INHIBIT = 131072;
    public static final int PF_IGNORE_OBSOLETE_CRL = 262144;
    private int a;
    private Certificate[] b;
    private byte[][] c;
    private Date d;
    private DatabaseService e;
    private Map f = new HashMap();

    public CertPathCtx(int n, Certificate[] certificateArray, byte[][] byArray, Date date, DatabaseService databaseService) {
        this.a = n;
        this.b = certificateArray;
        this.d = date;
        this.e = databaseService;
        this.c = byArray == null ? (Object)new byte[][]{X509V3Extension.ANY_POLICY_OID} : byArray;
    }

    public int getPathOptions() {
        return this.a;
    }

    public Certificate[] getTrustedCerts() {
        if (this.b == null) {
            return null;
        }
        return (Certificate[])this.b.clone();
    }

    public byte[][] getPolicies() {
        if (this.c == null) {
            return null;
        }
        return (byte[][])this.c.clone();
    }

    public Date getValidationTime() {
        return this.d;
    }

    public DatabaseService getDatabase() {
        return this.e;
    }

    public boolean isFlagRaised(int n) {
        return (n & this.getPathOptions()) != 0;
    }

    public void setAttribute(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.f.put(object, object2);
    }

    public Object getAttribute(Object object) {
        return this.f.get(object);
    }

    public void removeAttribute(Object object) {
        this.f.remove(object);
    }
}

