/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.util.Vector;

public final class OCSPutil {
    private OCSPutil() {
    }

    public static String getAIALocation(X509Certificate x509Certificate) {
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions == null) {
            return null;
        }
        try {
            AuthorityInfoAccess authorityInfoAccess = (AuthorityInfoAccess)x509V3Extensions.getExtensionByType(100);
            if (authorityInfoAccess == null) {
                return null;
            }
            for (int i = 0; i < authorityInfoAccess.getAccessDescriptionCount(); ++i) {
                GeneralName generalName;
                byte[] byArray = authorityInfoAccess.getAccessMethod(i);
                if (!CertJUtils.byteArraysEqual(byArray, AuthorityInfoAccess.ID_AD_OCSP) || (generalName = authorityInfoAccess.getAccessLocation(i)).getGeneralNameType() != 7) continue;
                return (String)generalName.getGeneralName();
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] makeDataDigest(CertJ certJ, String string, byte[] byArray, int n, int n2) throws InvalidParameterException {
        byte[] byArray2 = null;
        try {
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)string, (String)certJ.getDevice());
            byArray2 = new byte[jSAFE_MessageDigest.getDigestSize()];
            jSAFE_MessageDigest.digestInit();
            jSAFE_MessageDigest.digestUpdate(byArray, n, n2);
            jSAFE_MessageDigest.digestFinal(byArray2, 0);
        }
        catch (Exception exception) {
            throw new InvalidParameterException("makeDataDigest:" + exception.toString());
        }
        return byArray2;
    }

    public static byte[] extractKeyDER(byte[] byArray, int n) throws ASN_Exception {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(65280);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, bitStringContainer, endContainer};
        ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        byte[] byArray2 = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, byArray2, 0, bitStringContainer.dataLen);
        return byArray2;
    }

    public static int selectCertificateByKeyHash(CertJ certJ, DatabaseService databaseService, byte[] byArray, int n, int n2, Vector vector) throws DatabaseException, NoServiceException, CertificateException, InvalidParameterException {
        int n3 = 0;
        boolean bl = true;
        while (databaseService.hasMoreCertificates()) {
            byte[] byArray2;
            byte[] byArray3;
            Certificate certificate;
            if (bl) {
                certificate = databaseService.firstCertificate();
                bl = false;
            } else {
                certificate = databaseService.nextCertificate();
            }
            if (!CertJUtils.byteArraysEqual(byArray3 = OCSPutil.makeDataDigest(certJ, "SHA1", byArray2 = certificate.getSubjectPublicKeyBER(), 0, 0), byArray)) continue;
            vector.addElement(certificate);
            ++n3;
        }
        return n3;
    }
}

