/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.EnumeratedContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.ExtendedKeyUsage;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.revocation.ocsp.OCSPCertID;
import com.rsa.certj.provider.revocation.ocsp.OCSPEvidence;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequest;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.provider.revocation.ocsp.OCSPRevocationInfo;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_Signature;
import java.util.Date;
import java.util.Vector;

public final class OCSPResponse {
    private CertJ a;
    private DatabaseService b;
    private byte[] c;
    private String d;
    private OCSPCertID[] e;
    private X509Certificate f;
    private X509Certificate g;
    private X509Certificate h;
    private X509Certificate i;
    private Vector j;
    private Date k;
    private long l;
    private int m;
    private CertRevocationInfo[] n;
    private X509V3Extensions o;
    private boolean p;
    private static final int q = 0;
    private static final int r = 1;
    private static final int s = 2;
    private static final int t = 3;
    private static final int u = 5;
    private static final int v = 6;
    private static final int w = 0;
    private static final int x = 0;

    protected OCSPResponse(CertJ certJ, OCSPResponderInternal oCSPResponderInternal, X509Certificate x509Certificate) {
        this.a = certJ;
        this.f = x509Certificate;
        this.h = oCSPResponderInternal.getResponderCert();
        this.m = oCSPResponderInternal.getTimeTolerance();
        this.b = oCSPResponderInternal.getDatabase();
        this.g = oCSPResponderInternal.getResponderCACert(x509Certificate);
        this.p = (oCSPResponderInternal.getFlags() & 8) != 0;
    }

    protected CertRevocationInfo getRevocationInfo(OCSPCertID oCSPCertID) throws NotSupportedException {
        if (this.e == null) {
            return null;
        }
        byte[] byArray = oCSPCertID.encode();
        for (int i = 0; i < this.e.length; ++i) {
            if (!CertJUtils.byteArraysEqual(this.e[i].encode(), byArray)) continue;
            return this.n[i];
        }
        return null;
    }

    protected byte[] getNonce() {
        return this.c;
    }

    private void a(int n) throws CertStatusException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                throw new CertStatusException("OCSP_STATUS_MALFORMED_REQUEST");
            }
            case 2: {
                throw new CertStatusException("OCSP_STATUS_INTERNAL_ERROR");
            }
            case 3: {
                throw new CertStatusException("OCSP_STATUS_TRY_LATER");
            }
            case 5: {
                throw new CertStatusException("OCSP_STATUS_SIG_REQUIRED");
            }
            case 6: {
                throw new CertStatusException("OCSP_STATUS_UNAUTHORIZED");
            }
            default: {
                throw new CertStatusException("OCSP_STATUS UNKNOWN!!!");
            }
        }
    }

    private boolean a(Certificate certificate, String string, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        boolean bl = false;
        try {
            String string2 = this.a.getDevice();
            JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)string, (String)string2);
            jSAFE_Signature.verifyInit(certificate.getSubjectPublicKey(string2), null, null, this.a.getPKCS11Sessions());
            jSAFE_Signature.verifyUpdate(byArray, n, n2);
            bl = jSAFE_Signature.verifyFinal(byArray2, n3, n4);
            jSAFE_Signature.clearSensitiveData();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected void decode(CertPathCtx certPathCtx, byte[] byArray, OCSPRequest oCSPRequest) throws ASN_Exception, NoServiceException, CertStatusException, InvalidParameterException {
        int n = 0;
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EnumeratedContainer enumeratedContainer = new EnumeratedContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(10563584);
        SequenceContainer sequenceContainer2 = new SequenceContainer(0xA10000);
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, enumeratedContainer, encodedContainer, endContainer};
        ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, oIDContainer, octetStringContainer, endContainer};
        Date date = certPathCtx.getValidationTime();
        this.l = date == null ? System.currentTimeMillis() : date.getTime();
        ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
        n = enumeratedContainer.getValueAsInt();
        this.a(n);
        if (!encodedContainer.dataPresent) {
            throw new CertStatusException("OCSPResponse: missing status=OK responseBytes!");
        }
        ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
        if (!CertJUtils.byteArraysEqual(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen, OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC)) {
            throw new CertStatusException("!ID_PKIX_OCSP_BASIC");
        }
        this.a(certPathCtx, octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
    }

    private void a(CertPathCtx certPathCtx, byte[] byArray, int n, int n2) throws ASN_Exception, NoServiceException, CertStatusException {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(65280);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        OfContainer ofContainer = new OfContainer(0xA10000, 12288, (ASN1Container)new EncodedContainer(12288));
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, bitStringContainer, ofContainer, endContainer};
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        EncodedContainer encodedContainer3 = new EncodedContainer(65536);
        ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, oIDContainer, encodedContainer3, endContainer};
        ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        ASN1.berDecode((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (ASN1Container[])aSN1ContainerArray2);
        try {
            JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (String)"Java");
            this.d = jSAFE_Signature.getDigestAlgorithm() + "/" + jSAFE_Signature.getSignatureAlgorithm() + "/" + jSAFE_Signature.getPaddingScheme();
            if (this.b != null) {
                for (int i = 0; i < ofContainer.getContainerCount(); ++i) {
                    ASN1Container aSN1Container = ofContainer.containerAt(i);
                    X509Certificate x509Certificate = new X509Certificate(aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen);
                    this.b.insertCertificate(x509Certificate);
                }
            }
            this.b(certPathCtx, encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
        }
        catch (CertStatusException certStatusException) {
            throw certStatusException;
        }
        catch (Exception exception) {
            throw new CertStatusException(exception.getMessage());
        }
        if (!this.a(certPathCtx, (ASN1Container)encodedContainer, (ASN1Container)bitStringContainer)) {
            throw new CertStatusException("Unable to verify identity of responder");
        }
    }

    private void b(CertPathCtx certPathCtx, byte[] byArray, int n, int n2) throws ASN_Exception, NoServiceException, CertStatusException, NotSupportedException {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        IntegerContainer integerContainer = new IntegerContainer(0xA20000);
        EncodedContainer encodedContainer = new EncodedContainer(65280);
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
        EncodedContainer encodedContainer2 = new EncodedContainer(130816);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, genTimeContainer, ofContainer, encodedContainer2, endContainer};
        ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        if (integerContainer.dataPresent && integerContainer.getValueAsInt() != 0) {
            throw new CertStatusException("0 != " + integerContainer.getValueAsInt());
        }
        this.a(certPathCtx.getDatabase(), encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
        this.k = new Date(genTimeContainer.theTime.getTime());
        this.a(ofContainer, this.k, this.m);
        try {
            if (encodedContainer2.dataPresent) {
                this.o = new X509V3Extensions(encodedContainer2.data, encodedContainer2.dataOffset, 0xA00001, 5);
                int n3 = this.o.getExtensionCount();
                for (int i = 0; i < n3; ++i) {
                    X509V3Extension x509V3Extension = this.o.getExtensionByIndex(i);
                    int n4 = x509V3Extension.getExtensionType();
                    if (x509V3Extension.getCriticality()) {
                        if (n4 == 120) continue;
                        throw new CertStatusException("unknown critical OCSP response extension");
                    }
                    if (n4 != 120) continue;
                    OCSPNonce oCSPNonce = (OCSPNonce)x509V3Extension;
                    this.c = oCSPNonce.getNonceValue();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw new CertStatusException(certificateException.getMessage());
        }
    }

    private void a(DatabaseService databaseService, byte[] byArray, int n, int n2) throws ASN_Exception, NoServiceException, CertStatusException {
        block7: {
            EndContainer endContainer = new EndContainer();
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(10498049);
            EncodedContainer encodedContainer2 = new EncodedContainer(10551042);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, encodedContainer2, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.j = new Vector();
            try {
                if (encodedContainer.dataPresent) {
                    X500Name x500Name = new X500Name(encodedContainer.data, encodedContainer.dataOffset, 0xA00001);
                    databaseService.selectCertificateBySubject(x500Name, this.j);
                    break block7;
                }
                if (encodedContainer2.dataPresent) {
                    OctetStringContainer octetStringContainer = new OctetStringContainer(0xA00002);
                    ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{octetStringContainer};
                    ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray2);
                    OCSPutil.selectCertificateByKeyHash(this.a, databaseService, octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen, this.j);
                    break block7;
                }
                throw new CertStatusException("unknown ResponderID CHOICE");
            }
            catch (CertificateException certificateException) {
                throw new CertStatusException(certificateException.getMessage());
            }
            catch (NameException nameException) {
                throw new CertStatusException(nameException.getMessage());
            }
            catch (DatabaseException databaseException) {
                throw new CertStatusException(databaseException.getMessage());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new CertStatusException(invalidParameterException.getMessage());
            }
        }
    }

    private OCSPRevocationInfo a(byte[] byArray, int n, CertRevocationInfo certRevocationInfo) throws ASN_Exception, NotSupportedException {
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(0x800500);
        EncodedContainer encodedContainer2 = new EncodedContainer(8400897);
        EncodedContainer encodedContainer3 = new EncodedContainer(8389890);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
        OCSPRevocationInfo oCSPRevocationInfo = null;
        ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        if (encodedContainer.dataPresent) {
            certRevocationInfo.setStatus(0);
        } else if (encodedContainer2.dataPresent) {
            SequenceContainer sequenceContainer = new SequenceContainer(0x800001);
            GenTimeContainer genTimeContainer = new GenTimeContainer(0);
            EncodedContainer encodedContainer4 = new EncodedContainer(10616576);
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, genTimeContainer, encodedContainer4, endContainer};
            ASN1.berDecode((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            oCSPRevocationInfo = new OCSPRevocationInfo(genTimeContainer.theTime.getTime());
            if (encodedContainer4.dataPresent) {
                EnumeratedContainer enumeratedContainer = new EnumeratedContainer(0xA0FF00);
                ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{enumeratedContainer};
                ASN1.berDecode((byte[])encodedContainer4.data, (int)encodedContainer4.dataOffset, (ASN1Container[])aSN1ContainerArray3);
                oCSPRevocationInfo.setReasonCode(enumeratedContainer.getValueAsInt());
            }
            certRevocationInfo.setStatus(1);
        } else if (encodedContainer3.dataPresent) {
            certRevocationInfo.setStatus(2);
        } else {
            throw new NotSupportedException("CertStatus");
        }
        return oCSPRevocationInfo;
    }

    private boolean a(long l, int n, OCSPEvidence oCSPEvidence) {
        long l2 = oCSPEvidence.getThisUpdate().getTime() - (long)(n * 1000);
        if (l < l2) {
            return false;
        }
        Date date = oCSPEvidence.getNextUpdate();
        return date == null || l <= date.getTime() + (long)(n * 1000);
    }

    private void a(OfContainer ofContainer, Date date, int n) throws ASN_Exception, NotSupportedException {
        EndContainer endContainer = new EndContainer();
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(65280);
        EncodedContainer encodedContainer2 = new EncodedContainer(65280);
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        GenTimeContainer genTimeContainer2 = new GenTimeContainer(0xA10000);
        OfContainer ofContainer2 = new OfContainer(0xA10001, 12288, (ASN1Container)new EncodedContainer(12288));
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, genTimeContainer, genTimeContainer2, ofContainer2, endContainer};
        int n2 = ofContainer.getContainerCount();
        this.e = new OCSPCertID[n2];
        this.n = new CertRevocationInfo[n2];
        for (int i = 0; i < n2; ++i) {
            ASN1Container aSN1Container = ofContainer.containerAt(i);
            ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray);
            this.n[i] = new CertRevocationInfo();
            OCSPRevocationInfo oCSPRevocationInfo = this.a(encodedContainer2.data, encodedContainer2.dataOffset, this.n[i]);
            try {
                Date date2 = new Date(genTimeContainer.theTime.getTime());
                Date date3 = genTimeContainer2.dataPresent ? new Date(genTimeContainer2.theTime.getTime()) : null;
                OCSPEvidence oCSPEvidence = new OCSPEvidence(0, date, date2, date3, ofContainer2.dataPresent && ofContainer2.data != null ? new X509V3Extensions(ofContainer2.data, ofContainer2.dataOffset, ofContainer2.dataLen, 4) : null, oCSPRevocationInfo);
                this.n[i].setEvidence(oCSPEvidence);
                this.n[i].setType(2);
                this.e[i] = new OCSPCertID(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
                if (this.a(this.l, this.m, oCSPEvidence)) continue;
                this.n[i].setStatus(2);
                continue;
            }
            catch (CertificateException certificateException) {
                throw new NotSupportedException(certificateException.getMessage());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new NotSupportedException(invalidParameterException.getMessage());
            }
        }
    }

    private boolean a(CertPathCtx certPathCtx, ASN1Container aSN1Container, ASN1Container aSN1Container2) throws CertStatusException {
        boolean bl = false;
        CertPathCtx certPathCtx2 = certPathCtx;
        for (int i = 0; i < this.j.size(); ++i) {
            this.i = (X509Certificate)this.j.elementAt(0);
            if (!this.a(this.i, this.d, aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen, aSN1Container2.data, aSN1Container2.dataOffset, aSN1Container2.dataLen)) continue;
            try {
                if (this.f.equals(this.i)) {
                    if (this.p) {
                        certPathCtx2 = new CertPathCtx(certPathCtx.getPathOptions() | 4, certPathCtx.getTrustedCerts(), certPathCtx.getPolicies(), certPathCtx.getValidationTime(), certPathCtx.getDatabase());
                    } else {
                        return false;
                    }
                }
                bl = this.a.buildCertPath(certPathCtx2, this.i, null, null, null, null);
            }
            catch (CertJException certJException) {
                bl = false;
            }
            if (!bl) continue;
            if (this.i.equals(this.g)) {
                return true;
            }
            if (this.a(this.i, this.f)) {
                return true;
            }
            if (this.i.equals(this.h)) {
                return true;
            }
            bl = false;
        }
        return bl;
    }

    private boolean a(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions == null || x509V3Extensions.getExtensionCount() == 0) {
            return false;
        }
        try {
            ExtendedKeyUsage extendedKeyUsage = (ExtendedKeyUsage)x509V3Extensions.getExtensionByType(37);
            if (extendedKeyUsage == null) {
                return false;
            }
            for (int i = 0; i < extendedKeyUsage.getKeyUsageCount(); ++i) {
                if (!CertJUtils.byteArraysEqual(ExtendedKeyUsage.ID_KP_OCSP_SIGNING, extendedKeyUsage.getExtendedKeyUsage(i))) continue;
                return true;
            }
        }
        catch (CertificateException certificateException) {
            return false;
        }
        return this.i.getIssuerName().equals(x509Certificate2.getSubjectName());
    }
}

