/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.OCSPServiceLocator;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.revocation.ocsp.OCSPCertID;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.Vector;

public final class OCSPRequest {
    private CertJ a;
    private byte[] b;
    private OCSPCertID[] c;
    private X509V3Extension[] d;
    private X509V3Extensions[] e;
    private X509V3Extensions f;
    private OCSPResponderInternal g;

    protected OCSPRequest(CertJ certJ, OCSPResponderInternal oCSPResponderInternal, Certificate[] certificateArray) throws CertificateException, NotSupportedException {
        int n = certificateArray.length;
        try {
            Object object;
            Object object2;
            this.a = certJ;
            this.a(oCSPResponderInternal);
            int n2 = oCSPResponderInternal.getFlags();
            if ((n2 & 1) == 0) {
                object2 = certJ.getRandomObject();
                object = new byte[16];
                object2.generateRandomBytes(object, 0, 16);
                this.setNonce((byte[])object, 0, 16);
            }
            this.e = new X509V3Extensions[n];
            this.c = new OCSPCertID[n];
            this.d = new X509V3Extension[n];
            for (int i = 0; i < n; ++i) {
                object2 = (X509Certificate)certificateArray[i];
                object = oCSPResponderInternal.getResponderCACert((X509Certificate)object2);
                this.c[i] = new OCSPCertID(certJ, (X509Certificate)object, (X509Certificate)object2, oCSPResponderInternal.getRequestControl().getDigestAlgorithm());
                X500Name x500Name = ((X509Certificate)object2).getIssuerName();
                X509V3Extensions x509V3Extensions = ((X509Certificate)object2).getExtensions();
                AuthorityInfoAccess authorityInfoAccess = null;
                if (x509V3Extensions == null || (authorityInfoAccess = (AuthorityInfoAccess)x509V3Extensions.getExtensionByType(100)) == null) continue;
                this.d[i] = new OCSPServiceLocator(x500Name, authorityInfoAccess);
            }
            this.g = oCSPResponderInternal;
        }
        catch (CertificateException certificateException) {
            throw new NotSupportedException(certificateException.getMessage());
        }
        catch (NoServiceException noServiceException) {
            throw new NotSupportedException(noServiceException.getMessage());
        }
        catch (RandomException randomException) {
            throw new NotSupportedException(randomException.getMessage());
        }
        catch (NameException nameException) {
            throw new NotSupportedException(nameException.getMessage());
        }
    }

    private void a(OCSPResponderInternal oCSPResponderInternal) throws NotSupportedException {
        X509V3Extensions x509V3Extensions = oCSPResponderInternal.getRequestControl().getRequestExtensions();
        try {
            this.f = x509V3Extensions != null ? (X509V3Extensions)x509V3Extensions.clone() : new X509V3Extensions(5);
            OCSPAcceptableResponses oCSPAcceptableResponses = new OCSPAcceptableResponses();
            byte[] byArray = OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC;
            int n = OCSPAcceptableResponses.ID_PKIX_OCSP_BASIC.length;
            oCSPAcceptableResponses.addAcceptableResponse(byArray, 0, n);
            this.f.addV3Extension(oCSPAcceptableResponses);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NotSupportedException(cloneNotSupportedException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new NotSupportedException(certificateException.getMessage());
        }
    }

    protected void setSingleRequestExtensions(int n, X509V3Extensions x509V3Extensions) throws NotSupportedException {
        try {
            this.e[n] = (X509V3Extensions)x509V3Extensions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NotSupportedException(cloneNotSupportedException.getMessage());
        }
    }

    protected byte[] getNonce() {
        return this.b;
    }

    protected int setNonce(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null || n2 == 0) {
            return 0;
        }
        this.b = new byte[n2];
        System.arraycopy(byArray, n, this.b, 0, n2);
        OCSPNonce oCSPNonce = new OCSPNonce(this.b, 0, n2);
        if (this.f == null) {
            this.f = new X509V3Extensions(5);
        }
        this.f.addV3Extension(oCSPNonce);
        return n2;
    }

    protected OCSPCertID getCertID(int n) {
        return this.c[n];
    }

    protected byte[] encode(CertPathCtx certPathCtx) throws NotSupportedException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        X500Name x500Name = null;
        try {
            X509Certificate x509Certificate = this.g.getRequestControl().getSignerCert();
            if (x509Certificate != null) {
                x500Name = x509Certificate.getSubjectName();
            }
            byte[] byArray3 = this.a(0, x500Name, this.f);
            if (x509Certificate != null) {
                byArray = this.a(this.a, certPathCtx, this.g, x509Certificate, byArray3);
            }
            byArray2 = this.a(byArray3, byArray);
        }
        catch (Exception exception) {
            throw new NotSupportedException(exception.getMessage());
        }
        return byArray2;
    }

    private byte[] a(CertJ certJ, CertPathCtx certPathCtx, OCSPResponderInternal oCSPResponderInternal, Certificate certificate, byte[] byArray) throws NotSupportedException, ASN_Exception {
        byte[] byArray2 = null;
        EndContainer endContainer = new EndContainer();
        try {
            JSAFE_PrivateKey jSAFE_PrivateKey = certPathCtx.getDatabase().selectPrivateKeyByCertificate(certificate);
            String string = oCSPResponderInternal.getSignatureAlgorithm();
            JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)string, (String)certJ.getDevice());
            jSAFE_Signature.signInit(jSAFE_PrivateKey, null, (SecureRandom)certJ.getRandomObject(), certJ.getPKCS11Sessions());
            jSAFE_Signature.signUpdate(byArray, 0, byArray.length);
            byte[] byArray3 = jSAFE_Signature.signFinal();
            JSAFE_Signature jSAFE_Signature2 = JSAFE_Signature.getInstance((String)string, (String)this.a.getDevice());
            byte[] byArray4 = jSAFE_Signature2.getDERAlgorithmID();
            SequenceContainer sequenceContainer = new SequenceContainer(0xA10000, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray4, 0, byArray4.length);
            BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, byArray3, 0, byArray3.length, byArray3.length * 8, false);
            ASN1Container aSN1Container = this.a(oCSPResponderInternal.getFlags(), oCSPResponderInternal.getRequestControl().getExtraCerts(), certPathCtx, certificate);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, bitStringContainer, aSN1Container, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            byArray2 = this.a(aSN1Template);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new NotSupportedException(jSAFE_Exception.getMessage());
        }
        catch (CertJException certJException) {
            throw new NotSupportedException(certJException.getMessage());
        }
        return byArray2;
    }

    private byte[] a() throws NotSupportedException {
        try {
            Object object;
            OfContainer ofContainer = null;
            for (int i = 0; i < this.c.length; ++i) {
                X509V3Extensions x509V3Extensions;
                object = null;
                if (this.e[i] == null) {
                    if (this.d[i] == null) {
                        x509V3Extensions = null;
                    } else {
                        x509V3Extensions = new X509V3Extensions(4);
                        x509V3Extensions.addV3Extension(this.d[i]);
                    }
                } else if (this.d[i] == null) {
                    x509V3Extensions = this.e[i];
                } else {
                    x509V3Extensions = (X509V3Extensions)this.e[i].clone();
                    x509V3Extensions.addV3Extension(this.d[i]);
                }
                object = this.a(this.c[i].encode(), x509V3Extensions);
                ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                ofContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, (byte[])object, 0, ((ASN1Template)object).length));
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            object = new ASN1Template(aSN1ContainerArray);
            return this.a((ASN1Template)object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NotSupportedException(aSN_Exception.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new NotSupportedException(certificateException.getMessage());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NotSupportedException(cloneNotSupportedException.getMessage());
        }
    }

    private byte[] a(int n, X500Name x500Name, X509V3Extensions x509V3Extensions) throws NotSupportedException, ASN_Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        try {
            EncodedContainer encodedContainer;
            EncodedContainer encodedContainer2;
            Object object;
            IntegerContainer integerContainer = n != 0 ? new IntegerContainer(0xA30000, true, 0, n) : new IntegerContainer(0xA30000, false, 0, 0);
            if (x500Name != null) {
                int n2 = 0;
                byte[] byArray = null;
                object = new GeneralName();
                ((GeneralName)object).setGeneralName(x500Name, 5);
                n2 = ((GeneralName)object).getDERLen(0xA10001);
                byArray = new byte[n2];
                ((GeneralName)object).getDEREncoding(byArray, 0, 0xA10001);
                encodedContainer2 = new EncodedContainer(12288, true, 12288, byArray, 0, n2);
            } else {
                encodedContainer2 = new EncodedContainer(0xA10001, false, 0, null, 0, 0);
            }
            byte[] byArray = this.a();
            EncodedContainer encodedContainer3 = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
            if (x509V3Extensions != null) {
                int n3 = x509V3Extensions.getDERLen(10551298);
                object = new byte[n3];
                x509V3Extensions.getDEREncoding((byte[])object, 0, 10551298);
                encodedContainer = new EncodedContainer(10551298, true, 0, (byte[])object, 0, n3);
            } else {
                encodedContainer = new EncodedContainer(10551298, false, 0, null, 0, 0);
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, encodedContainer3, encodedContainer, endContainer};
            object = new ASN1Template(aSN1ContainerArray);
            return this.a((ASN1Template)object);
        }
        catch (NameException nameException) {
            throw new NotSupportedException(nameException.getMessage());
        }
    }

    private ASN1Container a(int n, X509Certificate[] x509CertificateArray, CertPathCtx certPathCtx, Certificate certificate) throws NotSupportedException, ASN_Exception {
        int n2;
        Vector<Certificate> vector = new Vector<Certificate>();
        if ((n & 2) == 0) {
            vector.addElement(certificate);
        }
        if ((n & 4) != 0) {
            Vector vector2 = new Vector();
            try {
                this.a.buildCertPath(certPathCtx, certificate, vector2, null, null, null);
                for (n2 = 0; n2 < vector2.size(); ++n2) {
                    vector.addElement((Certificate)vector2.elementAt(n2));
                }
            }
            catch (CertJException certJException) {
                throw new ASN_Exception(certJException.getMessage());
            }
        }
        if (x509CertificateArray != null) {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                vector.addElement(x509CertificateArray[i]);
            }
        }
        if (vector.isEmpty()) {
            return new EncodedContainer(0xA10000, false, 0, null, 0, 0);
        }
        OfContainer ofContainer = new OfContainer(0xA10000, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Certificate certificate2 = (Certificate)vector.elementAt(n2);
            byte[] byArray = new byte[((X509Certificate)certificate2).getDERLen(0)];
            try {
                ((X509Certificate)certificate2).getDEREncoding(byArray, 0, 0);
                ofContainer.addContainer((ASN1Container)new EncodedContainer(0, true, 0, byArray, 0, byArray.length));
                continue;
            }
            catch (CertificateException certificateException) {
                throw new NotSupportedException(certificateException.getMessage());
            }
            catch (ASN_Exception aSN_Exception) {
                throw new NotSupportedException(aSN_Exception.getMessage());
            }
        }
        return ofContainer;
    }

    private byte[] a(byte[] byArray, X509V3Extensions x509V3Extensions) throws NotSupportedException, ASN_Exception {
        byte[] byArray2 = null;
        int n = 0;
        if (x509V3Extensions != null) {
            n = x509V3Extensions.getDERLen(0xA10000);
            byArray2 = new byte[n];
            x509V3Extensions.getDEREncoding(byArray2, 0, 0xA10000);
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
        EncodedContainer encodedContainer2 = new EncodedContainer(0, true, 0, byArray2, 0, n);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
        ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
        return this.a(aSN1Template);
    }

    private byte[] a(byte[] byArray, byte[] byArray2) throws NotSupportedException, ASN_Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
        EncodedContainer encodedContainer2 = byArray2 == null ? new EncodedContainer(0xA10000, false, 0, null, 0, 0) : new EncodedContainer(0xA10000, true, 0, byArray2, 0, byArray2.length);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, endContainer};
        ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
        return this.a(aSN1Template);
    }

    private byte[] a(ASN1Template aSN1Template) throws NotSupportedException {
        byte[] byArray = null;
        try {
            int n = aSN1Template.derEncodeInit();
            byArray = new byte[n];
            int n2 = aSN1Template.derEncode(byArray, 0);
            return (byte[])(n == n2 ? byArray : null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NotSupportedException(aSN_Exception.getMessage());
        }
    }
}

