/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;

public final class OCSPCertID {
    public String hashAlg = null;
    public byte[] issuerKeyHash = null;
    public byte[] issuerNameHash = null;
    public byte[] serial = null;
    public byte[] encoding = null;
    private static final int a = 0;
    private static final int b = 0;
    private static final int c = 0;
    private static final boolean d = true;

    protected OCSPCertID(CertJ certJ, X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) throws NameException, CertificateException, NotSupportedException {
        this.hashAlg = new String(string);
        try {
            byte[] byArray = OCSPutil.extractKeyDER(x509Certificate.getSubjectPublicKeyBER(), 0);
            this.issuerKeyHash = OCSPutil.makeDataDigest(certJ, string, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new NotSupportedException(exception.getMessage());
        }
        byte[] byArray = new byte[x509Certificate.getSubjectName().getDERLen(0)];
        x509Certificate.getSubjectName().getDEREncoding(byArray, 0, 0);
        try {
            this.issuerNameHash = OCSPutil.makeDataDigest(certJ, string, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new NotSupportedException(exception.getMessage());
        }
        byte[] byArray2 = x509Certificate2.getSerialNumber();
        this.serial = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, this.serial, 0, byArray2.length);
    }

    protected OCSPCertID(byte[] byArray, int n, int n2) throws NotSupportedException {
        OctetStringContainer octetStringContainer = null;
        OctetStringContainer octetStringContainer2 = null;
        EncodedContainer encodedContainer = null;
        try {
            EndContainer endContainer = new EndContainer();
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            EncodedContainer encodedContainer2 = new EncodedContainer(65280);
            octetStringContainer = new OctetStringContainer(0);
            octetStringContainer2 = new OctetStringContainer(0);
            encodedContainer = new EncodedContainer(65280);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer2, octetStringContainer, octetStringContainer2, encodedContainer, endContainer};
            SequenceContainer sequenceContainer2 = new SequenceContainer(0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer3 = new EncodedContainer(65536);
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, oIDContainer, encodedContainer3, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            ASN1.berDecode((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (String)"Java");
            this.hashAlg = jSAFE_MessageDigest.getAlgorithm();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NotSupportedException(aSN_Exception.getMessage());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new NotSupportedException(jSAFE_Exception.getMessage());
        }
        this.issuerKeyHash = new byte[octetStringContainer2.dataLen];
        System.arraycopy(octetStringContainer2.data, octetStringContainer2.dataOffset, this.issuerKeyHash, 0, octetStringContainer2.dataLen);
        this.issuerNameHash = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.issuerNameHash, 0, octetStringContainer.dataLen);
        this.serial = new byte[encodedContainer.dataLen];
        System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, this.serial, 0, encodedContainer.dataLen);
        this.encoding = new byte[n2];
        System.arraycopy(byArray, n, this.encoding, 0, n2);
    }

    private byte[] a(String string) throws NotSupportedException {
        try {
            JSAFE_MessageDigest jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)string, (String)"Java");
            return jSAFE_MessageDigest.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new NotSupportedException(jSAFE_Exception.getMessage());
        }
    }

    protected byte[] encode() throws NotSupportedException {
        if (this.encoding != null) {
            return this.encoding;
        }
        byte[] byArray = this.a(this.hashAlg);
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EncodedContainer encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, byArray.length);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.issuerNameHash, 0, this.issuerNameHash.length);
            OctetStringContainer octetStringContainer2 = new OctetStringContainer(0, true, 0, this.issuerKeyHash, 0, this.issuerKeyHash.length);
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.serial, 0, this.serial.length, true);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, octetStringContainer, octetStringContainer2, integerContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n = aSN1Template.derEncodeInit();
            this.encoding = new byte[n];
            int n2 = aSN1Template.derEncode(this.encoding, 0);
            return n == n2 ? this.encoding : null;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NotSupportedException(aSN_Exception.getMessage());
        }
    }
}

