/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.CertificateIssuer;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.IssuingDistributionPoint;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.ReasonCode;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.provider.revocation.Cae;
import com.rsa.certj.provider.revocation.Caf;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public final class CRLCertStatus
extends Provider {
    public CRLCertStatus(String string) throws InvalidParameterException {
        super(2, string);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("CRLCertStatus.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements CertStatusInterface {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        public CertRevocationInfo checkCertRevocation(CertPathCtx certPathCtx, Certificate certificate) throws NotSupportedException, CertStatusException {
            if (!(certificate instanceof X509Certificate)) {
                throw new NotSupportedException("CRLCertStatus$Implementation.checkCertRevocation: does not support certificat types other than X509Certificate.");
            }
            X509Certificate x509Certificate = (X509Certificate)certificate;
            CRLDistributionPoints cRLDistributionPoints = (CRLDistributionPoints)this.a(x509Certificate, 31);
            CertRevocationInfo certRevocationInfo = null;
            if (cRLDistributionPoints != null && !certPathCtx.isFlagRaised(1024)) {
                certRevocationInfo = this.a(certPathCtx, x509Certificate, cRLDistributionPoints);
            } else {
                cRLDistributionPoints = new CRLDistributionPoints();
                GeneralNames generalNames = new GeneralNames();
                GeneralName generalName = new GeneralName();
                try {
                    generalName.setGeneralName(x509Certificate.getIssuerName(), 5);
                }
                catch (NameException nameException) {
                    throw new CertStatusException(nameException.getMessage());
                }
                generalNames.addGeneralName(generalName);
                cRLDistributionPoints.addDistributionPoints(generalNames, -1, null);
                certRevocationInfo = this.a(certPathCtx, x509Certificate, cRLDistributionPoints);
            }
            return certRevocationInfo;
        }

        private CertRevocationInfo a(CertPathCtx certPathCtx, X509Certificate x509Certificate, CRLDistributionPoints cRLDistributionPoints) throws CertStatusException {
            CertRevocationInfo certRevocationInfo = new CertRevocationInfo();
            Caf caf = new Caf(this, null);
            Vector vector = new Vector();
            Vector<X509CRL> vector2 = new Vector<X509CRL>();
            Vector vector3 = new Vector();
            Date date = null;
            date = certPathCtx.getValidationTime() == null ? new Date() : certPathCtx.getValidationTime();
            int n = cRLDistributionPoints.getDistributionPointCount();
            block4: for (int i = 0; i < n; ++i) {
                Vector vector4 = null;
                GeneralNames generalNames = null;
                try {
                    generalNames = cRLDistributionPoints.getCRLIssuer(i);
                }
                catch (NameException nameException) {
                    this.a(nameException);
                }
                X500Name x500Name = null;
                boolean bl = false;
                if (generalNames != null) {
                    x500Name = this.a(generalNames);
                    this.b(x500Name);
                    vector4 = this.a(certPathCtx, x500Name, date);
                    bl = true;
                } else {
                    vector4 = this.a(certPathCtx, x509Certificate.getIssuerName(), date);
                }
                Iterator iterator = ((AbstractList)vector4).iterator();
                while (iterator.hasNext()) {
                    Object object;
                    if (caf.a() || !caf.c()) break block4;
                    X509CRL x509CRL = (X509CRL)iterator.next();
                    if (this.a(certPathCtx, x509CRL, date) || bl && !this.a(x509CRL)) continue;
                    this.b();
                    try {
                        if (!this.a(certPathCtx, x509CRL, x509Certificate, cRLDistributionPoints, i)) {
                            continue;
                        }
                    }
                    catch (NameException nameException) {
                        this.a(nameException);
                    }
                    this.a();
                    if (!certPathCtx.isFlagRaised(16384)) {
                        this.a(certPathCtx, caf, x509CRL, cRLDistributionPoints, i);
                        if (!this.a(caf)) continue;
                    }
                    if (!this.a(certPathCtx, x509CRL, x509Certificate, vector, vector2, vector3)) continue;
                    if (vector2 != null && !vector2.contains(x509CRL)) {
                        vector2.add(x509CRL);
                    }
                    CertJUtils.mergeLists(vector3, vector);
                    if (this.a(x509Certificate, x509CRL, bl)) {
                        object = (ReasonCode)this.a(x509CRL, 21);
                        caf.c = object != null ? ((ReasonCode)object).getReasonCode() : 0;
                        certRevocationInfo.setStatus(1);
                        certRevocationInfo.setType(1);
                        CRLEvidence cRLEvidence = new CRLEvidence(x509CRL, null, null);
                        certRevocationInfo.setEvidence(cRLEvidence);
                    } else if (!certPathCtx.isFlagRaised(128) && this.b(x509CRL)) {
                        caf.c = 0;
                        certRevocationInfo.setStatus(2);
                        certRevocationInfo.setType(1);
                        object = new CRLEvidence(x509CRL, null, null);
                        certRevocationInfo.setEvidence(object);
                    } else if (certPathCtx.isFlagRaised(16384)) {
                        certRevocationInfo.setStatus(0);
                        certRevocationInfo.setType(1);
                        object = new CRLEvidence(null, vector3, vector2);
                        certRevocationInfo.setEvidence(object);
                    }
                    if (caf.c == 8) {
                        caf.d();
                    }
                    caf.b |= caf.d;
                }
            }
            if (certPathCtx.isFlagRaised(16384)) {
                return certRevocationInfo;
            }
            if (caf.a() || !caf.c()) {
                if (caf.c()) {
                    CRLEvidence cRLEvidence = new CRLEvidence(null, vector3, vector2);
                    certRevocationInfo.setStatus(0);
                    certRevocationInfo.setType(1);
                    certRevocationInfo.setEvidence(cRLEvidence);
                }
            } else {
                certRevocationInfo.setStatus(2);
                certRevocationInfo.setEvidence(null);
                certRevocationInfo.setType(0);
            }
            return certRevocationInfo;
        }

        private boolean a(X509CRL x509CRL) {
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)this.a(x509CRL, 28);
            if (issuingDistributionPoint == null) {
                return false;
            }
            return issuingDistributionPoint.getIndirectCRL();
        }

        private X500Name a(GeneralNames generalNames) {
            Vector vector = generalNames.getGeneralNames();
            for (int i = 0; i < vector.size(); ++i) {
                GeneralName generalName = (GeneralName)vector.get(i);
                Object object = generalName.getGeneralName();
                if (!(object instanceof X500Name)) continue;
                return (X500Name)object;
            }
            return null;
        }

        private void a(Exception exception) throws CertStatusException {
            throw new CertStatusException("Internal error! " + exception.getMessage());
        }

        private boolean a(Caf caf) {
            return (caf.d & ~caf.b) != 0;
        }

        private void a(CertPathCtx certPathCtx, Caf caf, X509CRL x509CRL, CRLDistributionPoints cRLDistributionPoints, int n) throws CertStatusException {
            int n2 = -1;
            try {
                n2 = cRLDistributionPoints.getReasonFlags(n);
            }
            catch (NameException nameException) {
                throw new CertStatusException("Internal error! " + nameException.getMessage());
            }
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)this.a(x509CRL, 28);
            if (issuingDistributionPoint == null) {
                caf.d = n2 != -1 ? n2 : -8388608;
                return;
            }
            int n3 = issuingDistributionPoint.getReasonFlags();
            if (n3 == -1) {
                caf.d = n2 != -1 ? n2 : -8388608;
                return;
            }
            caf.d = n3;
            if (n2 != -1) {
                caf.d &= n2;
            }
        }

        private Vector a(CertPathCtx certPathCtx, X500Name x500Name, Date date) throws CertStatusException {
            Vector<Object> vector = new Vector<Object>();
            try {
                DatabaseService databaseService = certPathCtx.getDatabase();
                databaseService.setupCRLIterator();
                while (databaseService.hasMoreCRLs()) {
                    Date date2;
                    X509CRL x509CRL;
                    X500Name x500Name2;
                    CRL cRL = databaseService.nextCRL();
                    if (!(cRL instanceof X509CRL) || !x500Name.equals(x500Name2 = (x509CRL = (X509CRL)cRL).getIssuerName()) || (date2 = x509CRL.getThisUpdate()).after(date) || vector.contains(x509CRL)) continue;
                    vector.add(x509CRL.clone());
                }
            }
            catch (Exception exception) {
                throw new CertStatusException("CRLCertStatus$Implementation.checkCertRevocation: " + exception.getMessage());
            }
            return this.a(vector);
        }

        private boolean a() {
            return true;
        }

        private boolean a(CertPathCtx certPathCtx, X509CRL x509CRL, X509Certificate x509Certificate, CRLDistributionPoints cRLDistributionPoints, int n) throws NameException, CertStatusException {
            Cloneable cloneable;
            GeneralNames generalNames = cRLDistributionPoints.getCRLIssuer(n);
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)this.a(x509CRL, 28);
            if (generalNames != null) {
                cloneable = this.a(generalNames);
                this.b((X500Name)cloneable);
                if (!NameMatcher.matchDirectoryNames(x509CRL.getIssuerName(), (X500Name)cloneable)) {
                    return false;
                }
                if (!(certPathCtx.isFlagRaised(16384) || issuingDistributionPoint != null && issuingDistributionPoint.getIndirectCRL())) {
                    return false;
                }
            } else if (!NameMatcher.matchDirectoryNames(x509CRL.getIssuerName(), x509Certificate.getIssuerName())) {
                return false;
            }
            if (issuingDistributionPoint == null || certPathCtx.isFlagRaised(16384)) {
                return true;
            }
            if (!this.a(generalNames, x509CRL, x509Certificate, issuingDistributionPoint, cRLDistributionPoints, n)) {
                return false;
            }
            cloneable = (BasicConstraints)this.a(x509Certificate, 19);
            if (issuingDistributionPoint.getUserCerts() && cloneable != null && ((BasicConstraints)cloneable).getCA()) {
                return false;
            }
            if (issuingDistributionPoint.getCACerts() && (cloneable == null || !((BasicConstraints)cloneable).getCA())) {
                return false;
            }
            return !issuingDistributionPoint.getAttributeCerts();
        }

        private boolean a(GeneralNames generalNames, X509CRL x509CRL, X509Certificate x509Certificate, IssuingDistributionPoint issuingDistributionPoint, CRLDistributionPoints cRLDistributionPoints, int n) throws NameException, CertStatusException {
            Object object = issuingDistributionPoint.getDistributionPointName();
            Object object2 = cRLDistributionPoints.getDistributionPointName(n);
            if (object == null) {
                return true;
            }
            if (object2 != null) {
                if (object instanceof RDN) {
                    X500Name x500Name = x509CRL.getIssuerName();
                    x500Name.addRDN((RDN)object);
                    if (object2 instanceof RDN) {
                        X500Name x500Name2 = null;
                        if (generalNames != null) {
                            x500Name2 = this.a(generalNames);
                            this.b(x500Name2);
                        } else {
                            x500Name2 = x509Certificate.getIssuerName();
                        }
                        x500Name2.addRDN((RDN)object2);
                        if (!x500Name.equals(x500Name2)) {
                            return false;
                        }
                    } else {
                        GeneralNames generalNames2 = (GeneralNames)object2;
                        GeneralName generalName = new GeneralName();
                        generalName.setGeneralName(x500Name, 5);
                        if (!this.a(generalName, generalNames2)) {
                            return false;
                        }
                    }
                } else {
                    GeneralNames generalNames3 = (GeneralNames)object;
                    GeneralNames generalNames4 = null;
                    if (object2 instanceof GeneralNames) {
                        generalNames4 = (GeneralNames)object2;
                    } else {
                        X500Name x500Name = null;
                        if (generalNames != null) {
                            x500Name = this.a(generalNames);
                            this.b(x500Name);
                        } else {
                            x500Name = x509Certificate.getIssuerName();
                        }
                        x500Name.addRDN((RDN)object2);
                        generalNames4 = this.a(x500Name);
                    }
                    if (!this.a(generalNames3, generalNames4)) {
                        return false;
                    }
                }
            } else {
                if (generalNames == null) {
                    return false;
                }
                GeneralNames generalNames5 = null;
                if (object instanceof RDN) {
                    X500Name x500Name = x509CRL.getIssuerName();
                    x500Name.addRDN((RDN)object);
                    generalNames5 = this.a(x500Name);
                } else {
                    generalNames5 = (GeneralNames)object;
                }
                if (!this.a(generalNames5, generalNames)) {
                    return false;
                }
            }
            return true;
        }

        private boolean a(GeneralName generalName, GeneralNames generalNames) throws NameException {
            if (generalName == null || generalNames == null) {
                return false;
            }
            for (int i = 0; i < generalNames.getNameCount(); ++i) {
                if (!generalName.equals(generalNames.getGeneralName(i))) continue;
                return true;
            }
            return false;
        }

        private boolean a(GeneralNames generalNames, GeneralNames generalNames2) throws NameException {
            if (generalNames == null) {
                return false;
            }
            for (int i = 0; i < generalNames.getNameCount(); ++i) {
                GeneralName generalName = generalNames.getGeneralName(i);
                if (!this.a(generalName, generalNames2)) continue;
                return true;
            }
            return false;
        }

        private GeneralNames a(X500Name x500Name) throws NameException {
            GeneralNames generalNames = new GeneralNames();
            GeneralName generalName = new GeneralName();
            generalName.setGeneralName(x500Name, 5);
            generalNames.addGeneralName(generalName);
            return generalNames;
        }

        private void b(X500Name x500Name) throws CertStatusException {
            if (x500Name == null) {
                throw new CertStatusException("the cRLIssuer MUST contain at least one X.500 distinguished name");
            }
        }

        private void b() {
        }

        private Vector a(Vector vector) {
            HashMap<IssuingDistributionPoint, X509CRL> hashMap = new HashMap<IssuingDistributionPoint, X509CRL>();
            IssuingDistributionPoint issuingDistributionPoint = new IssuingDistributionPoint();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                X509CRL x509CRL;
                X509CRL x509CRL2 = (X509CRL)iterator.next();
                IssuingDistributionPoint issuingDistributionPoint2 = (IssuingDistributionPoint)this.a(x509CRL2, 28);
                if (issuingDistributionPoint2 == null) {
                    issuingDistributionPoint2 = issuingDistributionPoint;
                }
                if ((x509CRL = (X509CRL)hashMap.get(issuingDistributionPoint2)) != null && !x509CRL2.getThisUpdate().after(x509CRL.getThisUpdate())) continue;
                hashMap.put(issuingDistributionPoint2, x509CRL2);
            }
            return new Vector(hashMap.values());
        }

        private boolean a(CertPathCtx certPathCtx, X509CRL x509CRL, X509Certificate x509Certificate, Vector vector, Vector vector2, Vector vector3) throws CertStatusException {
            Vector vector4 = (Vector)certPathCtx.getAttribute(x509CRL);
            if (vector4 != null) {
                CertJUtils.mergeLists(vector3, vector4);
                return true;
            }
            certPathCtx.setAttribute(x509CRL, new Vector());
            Vector vector5 = new Vector();
            try {
                this.certJ.getNextCertInPath(certPathCtx, x509CRL, vector5);
            }
            catch (Exception exception) {
                certPathCtx.removeAttribute(x509CRL);
                throw new CertStatusException("CRLCertStatus$Implementation.verifyPath: " + exception.getMessage());
            }
            if (vector5.size() == 0) {
                certPathCtx.removeAttribute(x509CRL);
                return false;
            }
            for (int i = 0; i < vector5.size(); ++i) {
                X509Certificate x509Certificate2 = (X509Certificate)vector5.get(i);
                CertPathResult certPathResult = null;
                try {
                    certPathResult = this.certJ.buildCertPath(certPathCtx, x509Certificate2, vector, vector2, vector3);
                }
                catch (Exception exception) {
                    certPathCtx.removeAttribute(x509CRL);
                    throw new CertStatusException("CRLCertStatus$Implementation.verifyPath: " + exception.getMessage());
                }
                if (!certPathResult.getValidationResult() || !this.a(x509CRL, x509Certificate2, certPathResult) || !this.a(certPathCtx, x509Certificate2)) continue;
                certPathCtx.setAttribute(x509CRL, vector.clone());
                return true;
            }
            certPathCtx.removeAttribute(x509CRL);
            return false;
        }

        private boolean a(X509CRL x509CRL, X509Certificate x509Certificate, CertPathResult certPathResult) {
            try {
                String string = this.certJ.getDevice();
                JSAFE_PublicKey jSAFE_PublicKey = certPathResult.getSubjectPublicKey(string);
                if (jSAFE_PublicKey == null) {
                    jSAFE_PublicKey = x509Certificate.getSubjectPublicKey(string);
                }
                return x509CRL.verifyCRLSignature(string, jSAFE_PublicKey, (SecureRandom)this.certJ.getRandomObject());
            }
            catch (NoServiceException noServiceException) {
                return false;
            }
            catch (RandomException randomException) {
                return false;
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }

        private boolean a(CertPathCtx certPathCtx, X509Certificate x509Certificate) {
            if (certPathCtx.isFlagRaised(64)) {
                return true;
            }
            KeyUsage keyUsage = (KeyUsage)this.a(x509Certificate, 15);
            if (keyUsage == null) {
                return true;
            }
            return (keyUsage.getKeyUsage() & 0x2000000) != 0;
        }

        private X509V3Extension a(X509V3Extensions x509V3Extensions, int n) {
            X509V3Extension x509V3Extension = null;
            if (x509V3Extensions != null) {
                try {
                    x509V3Extension = x509V3Extensions.getExtensionByType(n);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            return x509V3Extension;
        }

        private X509V3Extension a(X509CRL x509CRL, int n) {
            if (x509CRL == null) {
                return null;
            }
            return this.a(x509CRL.getExtensions(), n);
        }

        private X509V3Extension a(X509Certificate x509Certificate, int n) {
            if (x509Certificate == null) {
                return null;
            }
            return this.a(x509Certificate.getExtensions(), n);
        }

        private boolean b(X509CRL x509CRL) throws CertStatusException {
            X509V3Extensions x509V3Extensions = x509CRL.getExtensions();
            if (x509V3Extensions == null) {
                return false;
            }
            try {
                for (int i = 0; i < x509V3Extensions.getExtensionCount(); ++i) {
                    X509V3Extension x509V3Extension = x509V3Extensions.getExtensionByIndex(i);
                    int n = x509V3Extension.getExtensionType();
                    if (n == 28 || !x509V3Extension.getCriticality()) continue;
                    return true;
                }
            }
            catch (CertificateException certificateException) {
                this.a(certificateException);
            }
            return false;
        }

        private boolean a(X509Certificate x509Certificate, X509CRL x509CRL, boolean bl) throws CertStatusException {
            RevokedCertificates revokedCertificates = x509CRL.getRevokedCertificates();
            byte[] byArray = x509Certificate.getSerialNumber();
            if (revokedCertificates == null) {
                return false;
            }
            X500Name x500Name = x509CRL.getIssuerName();
            try {
                for (int i = 0; i < revokedCertificates.getCertificateCount(); ++i) {
                    CertificateIssuer certificateIssuer;
                    if (bl && (certificateIssuer = (CertificateIssuer)this.a(revokedCertificates.getExtensions(i), 29)) != null) {
                        x500Name = this.a(certificateIssuer.getGeneralNames());
                    }
                    if (!CertJUtils.byteArraysEqual(byArray, revokedCertificates.getSerialNumber(i))) continue;
                    if (bl) {
                        return x509Certificate.getIssuerName().equals(x500Name);
                    }
                    return true;
                }
            }
            catch (CertificateException certificateException) {
                this.a(certificateException);
            }
            return false;
        }

        private boolean a(CertPathCtx certPathCtx, X509CRL x509CRL, Date date) {
            if (certPathCtx.isFlagRaised(262144)) {
                return false;
            }
            Date date2 = x509CRL.getNextUpdate();
            return date2 != null && date.after(date2);
        }

        public String toString() {
            return "CRL Certificate Status provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cae cae) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

