/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.random;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.provider.random.Cad;
import com.rsa.certj.spi.random.RandomInterface;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.security.NoSuchAlgorithmException;

public final class DefaultRandom
extends Provider {
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;
    private byte[] d = null;

    public DefaultRandom(String string) throws InvalidParameterException {
        super(0, string);
    }

    public DefaultRandom(String string, long l) throws InvalidParameterException {
        super(0, string);
        this.d = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.d[7 - i] = (byte)(0xFFL & l);
            l >>= 8;
        }
    }

    public DefaultRandom(String string, byte[] byArray) throws InvalidParameterException {
        super(0, string);
        this.d = byArray;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("DefaultRandom.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements RandomInterface {
        private JSAFE_SecureRandom a;
        private int b;

        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
            this.a();
            if (DefaultRandom.this.d != null) {
                this.b = 0;
                this.a.seed(DefaultRandom.this.d);
            }
            this.updateRandom();
        }

        private void a() {
            String string = "SHA1Random";
            try {
                if (CertJ.isFIPS140Compliant()) {
                    string = "FIPS186Random";
                }
            }
            catch (InvalidUseException invalidUseException) {
                // empty catch block
            }
            try {
                this.a = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"HWRandom", (String)"Intel");
                this.b = 1;
            }
            catch (Exception exception) {
                try {
                    this.a = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)string, (String)this.certJ.getDevice());
                    this.b = 2;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }

        public JSAFE_SecureRandom getRandomObject() {
            return this.a;
        }

        public void updateRandom() {
            switch (this.b) {
                case 0: {
                    break;
                }
                case 1: {
                    this.a.autoseed();
                    break;
                }
                case 2: {
                    this.a.autoseed();
                    break;
                }
            }
        }

        public String toString() {
            return "Default Random provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cad cad) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

