/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPCertResponseCommon;
import com.rsa.certj.provider.pki.cmp.CMPConfirmMessage;
import com.rsa.certj.provider.pki.cmp.CMPErrorMessage;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPRevokeResponseMessage;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.Date;

public abstract class CMPResponseCommon
extends PKIResponseMessage {
    private GeneralName a = null;
    private GeneralName b = null;
    private byte[] c = null;
    private byte[] d = null;
    private byte[] e = null;
    private byte[] f = null;
    private TypeAndValue[] g = null;
    private int h = -1;

    protected CMPResponseCommon(int n, PKIHeader pKIHeader, PKIStatusInfo pKIStatusInfo) {
        super(pKIStatusInfo);
        this.h = n;
        this.a = pKIHeader.sender;
        this.b = pKIHeader.recipient;
        this.c = pKIHeader.getSenderKID();
        this.d = pKIHeader.getRecipKID();
        this.e = pKIHeader.getSenderNonce();
        this.f = pKIHeader.getRecipNonce();
        this.g = pKIHeader.generalInfo;
    }

    protected int getMessageType() {
        return this.h;
    }

    public GeneralName getSenderName() {
        return this.a;
    }

    public GeneralName getRecipientName() {
        return this.b;
    }

    public byte[] getSenderKID() {
        return this.c;
    }

    public byte[] getRecipKID() {
        return this.d;
    }

    public byte[] getSenderNonce() {
        return this.e;
    }

    public byte[] getRecipNonce() {
        return this.f;
    }

    public TypeAndValue[] getGeneralInfo() {
        return this.g;
    }

    protected static CMPResponseCommon berDecode(byte[] byArray, CMPProtectInfo cMPProtectInfo, CMPRequestCommon cMPRequestCommon, CertJ certJ) throws CMPException {
        Object[] objectArray;
        Object object;
        Object object2;
        EncodedContainer encodedContainer = null;
        EncodedContainer encodedContainer2 = null;
        BitStringContainer bitStringContainer = null;
        OfContainer ofContainer = null;
        try {
            object2 = new SequenceContainer(0);
            encodedContainer = new EncodedContainer(12288);
            encodedContainer2 = new EncodedContainer(65280);
            bitStringContainer = new BitStringContainer(0xA10000);
            ofContainer = new OfContainer(0xA10001, 12288, (ASN1Container)new EncodedContainer(12288));
            object = new EndContainer();
            objectArray = new ASN1Container[]{object2, encodedContainer, encodedContainer2, bitStringContainer, ofContainer, object};
            ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])objectArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPResponseCommon.berDecode: unable to decode response message(" + aSN_Exception.getMessage() + ").");
        }
        object2 = new PKIHeader(encodedContainer.data, encodedContainer.dataOffset);
        object = CMPResponseCommon.berDecodeBody((PKIHeader)object2, encodedContainer2.data, encodedContainer2.dataOffset, cMPProtectInfo, cMPRequestCommon, certJ);
        objectArray = CMPResponseCommon.a(ofContainer);
        ((PKIMessage)object).setExtraCerts((Certificate[])objectArray);
        ((PKIMessage)object).setFreeText(((PKIHeader)object2).freeText);
        ((PKIMessage)object).setMessageTime(((PKIHeader)object2).messageTime);
        ((PKIMessage)object).setTransactionID(((PKIHeader)object2).getTransactionID());
        Certificate[] certificateArray = ((PKIResponseMessage)object).getCACerts();
        if (!CMPResponseCommon.a(cMPProtectInfo, (ASN1Container)bitStringContainer, (ASN1Container)encodedContainer, (ASN1Container)encodedContainer2, (PKIHeader)object2, (Certificate[])objectArray, certificateArray, certJ)) {
            throw new CMPException("CMPResponseCommon.berDecode: unable to verify protection.");
        }
        return object;
    }

    protected static CMPResponseCommon berDecodeBody(PKIHeader pKIHeader, byte[] byArray, int n, CMPProtectInfo cMPProtectInfo, CMPRequestCommon cMPRequestCommon, CertJ certJ) throws CMPException {
        CMPResponseCommon cMPResponseCommon = null;
        int n2 = 0xFF & byArray[n] - 160;
        switch (n2) {
            case 1: 
            case 3: {
                cMPResponseCommon = CMPCertResponseCommon.berDecodeBody(n2, pKIHeader, byArray, n, cMPProtectInfo, cMPRequestCommon, certJ);
                break;
            }
            case 19: {
                cMPResponseCommon = CMPConfirmMessage.berDecodeBody(pKIHeader, byArray, n);
                break;
            }
            case 23: {
                cMPResponseCommon = CMPErrorMessage.berDecodeBody(pKIHeader, byArray, n);
                break;
            }
            case 12: {
                cMPResponseCommon = CMPRevokeResponseMessage.berDecodeBody(pKIHeader, byArray, n);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                throw new CMPException("CMPResponseCommon.berDecodeBody: unsupported response message type(" + n2 + ").");
            }
            default: {
                throw new CMPException("CMPResponseCommon.berDecodeBody: unexpected response message type(" + n2 + ").");
            }
        }
        return cMPResponseCommon;
    }

    private static boolean a(CMPProtectInfo cMPProtectInfo, ASN1Container aSN1Container, ASN1Container aSN1Container2, ASN1Container aSN1Container3, PKIHeader pKIHeader, Certificate[] certificateArray, Certificate[] certificateArray2, CertJ certJ) throws CMPException {
        if (!aSN1Container.dataPresent) {
            return true;
        }
        if (cMPProtectInfo == null) {
            throw new CMPException("CMPResponseCommon.verifyProtection: protectInfo should be null.");
        }
        byte[] byArray = CMP.derEncodeProtectedPart(aSN1Container2.data, aSN1Container2.dataOffset, aSN1Container2.dataLen, aSN1Container3.data, aSN1Container3.dataOffset, aSN1Container3.dataLen);
        byte[] byArray2 = pKIHeader.getProtectionAlg();
        JSAFE_Signature jSAFE_Signature = null;
        try {
            int n = 1 + ASN1Lengths.determineLengthLen((byte[])byArray2, (int)1);
            jSAFE_Signature = JSAFE_Signature.getInstance((byte[])byArray2, (int)n, (String)certJ.getDevice());
        }
        catch (JSAFE_Exception jSAFE_Exception) {
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPResponseCommon.verifyProtection: " + aSN_Exception.getMessage());
        }
        if (jSAFE_Signature != null) {
            return CMPResponseCommon.a(jSAFE_Signature, cMPProtectInfo, aSN1Container, byArray, certificateArray, certificateArray2, certJ);
        }
        if (!cMPProtectInfo.pbmProtected()) {
            throw new CMPException("CMPResponseCommon.verifyProtection: protectInfo should contain PBM protection info.");
        }
        return CMPResponseCommon.a(byArray2, cMPProtectInfo, aSN1Container, byArray, certJ);
    }

    private static boolean a(JSAFE_Signature jSAFE_Signature, CMPProtectInfo cMPProtectInfo, ASN1Container aSN1Container, byte[] byArray, Certificate[] certificateArray, Certificate[] certificateArray2, CertJ certJ) throws CMPException {
        int n;
        JSAFE_SecureRandom jSAFE_SecureRandom;
        Certificate[] certificateArray3 = cMPProtectInfo.getCACerts();
        CertPathCtx certPathCtx = new CertPathCtx(0, certificateArray3, null, new Date(), cMPProtectInfo.getDatabase());
        try {
            jSAFE_SecureRandom = certJ.getRandomObject();
        }
        catch (CertJException certJException) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to get a registered random service(" + certJException.getMessage() + ").");
        }
        X509Certificate x509Certificate = cMPProtectInfo.getRecipCert();
        if (x509Certificate != null && CMPResponseCommon.a(jSAFE_Signature, certPathCtx, x509Certificate, byArray, aSN1Container, jSAFE_SecureRandom, certJ)) {
            return true;
        }
        if (certificateArray3 != null) {
            for (n = 0; n < certificateArray3.length; ++n) {
                if (certificateArray3[n] == null || !CMPResponseCommon.a(jSAFE_Signature, certPathCtx, certificateArray3[n], byArray, aSN1Container, jSAFE_SecureRandom, certJ)) continue;
                return true;
            }
        }
        if (certificateArray2 != null) {
            for (n = 0; n < certificateArray2.length; ++n) {
                if (certificateArray2[n] == null || !CMPResponseCommon.a(jSAFE_Signature, certPathCtx, certificateArray2[n], byArray, aSN1Container, jSAFE_SecureRandom, certJ)) continue;
                return true;
            }
        }
        if (certificateArray != null) {
            for (n = 0; n < certificateArray.length; ++n) {
                if (certificateArray[n] == null || !CMPResponseCommon.a(jSAFE_Signature, certPathCtx, certificateArray[n], byArray, aSN1Container, jSAFE_SecureRandom, certJ)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean a(JSAFE_Signature jSAFE_Signature, CertPathCtx certPathCtx, Certificate certificate, byte[] byArray, ASN1Container aSN1Container, JSAFE_SecureRandom jSAFE_SecureRandom, CertJ certJ) {
        try {
            if (certJ.verifyCertPath(certPathCtx, certificate)) {
                jSAFE_Signature.verifyInit(certificate.getSubjectPublicKey(certJ.getDevice()), null, (SecureRandom)jSAFE_SecureRandom, certJ.getPKCS11Sessions());
                jSAFE_Signature.verifyUpdate(byArray, 0, byArray.length);
                if (jSAFE_Signature.verifyFinal(aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen)) {
                    return true;
                }
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (CertJException certJException) {
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean a(byte[] byArray, CMPProtectInfo cMPProtectInfo, ASN1Container aSN1Container, byte[] byArray2, CertJ certJ) throws CMPException {
        int n;
        char[] cArray = cMPProtectInfo.getSharedSecret();
        SequenceContainer sequenceContainer = new SequenceContainer(0xA10001);
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        EncodedContainer encodedContainer = new EncodedContainer(77824);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)0, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPResponseCommon.verifyProtection: Decoding PKIHeader.protectionAlg faild(" + aSN_Exception.getMessage() + ").");
        }
        if (!CMPResponseCommon.a(CMP.PASSWORD_BASED_MAC_OID, 0, CMP.PASSWORD_BASED_MAC_OID.length, oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen)) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unsupported PBM algorithm.");
        }
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        IntegerContainer integerContainer = new IntegerContainer(0);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, octetStringContainer, encodedContainer2, integerContainer, encodedContainer3, endContainer};
        try {
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPResponseCommon.verifyProtection: decoding PKIHeader.protectionAlg faild(" + aSN_Exception.getMessage() + ").");
        }
        JSAFE_MAC jSAFE_MAC = null;
        try {
            n = integerContainer.getValueAsInt();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to get interationCount as integer (" + aSN_Exception.getMessage() + ").");
        }
        try {
            jSAFE_MAC = JSAFE_MAC.getInstance((String)("PBE/HMAC/SHA1/PKIXPBE-" + n), (String)certJ.getDevice());
            jSAFE_MAC.setSalt(octetStringContainer.data, octetStringContainer.dataOffset, octetStringContainer.dataLen);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
            jSAFE_MAC.verifyInit(jSAFE_SecretKey, null);
            jSAFE_MAC.verifyUpdate(byArray2, 0, byArray2.length);
            boolean bl = jSAFE_MAC.verifyFinal(aSN1Container.data, aSN1Container.dataOffset, aSN1Container.dataLen);
            return bl;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to verify PBM(" + jSAFE_Exception.getMessage() + ").");
        }
        finally {
            if (jSAFE_MAC != null) {
                jSAFE_MAC.clearSensitiveData();
            }
        }
    }

    private static Certificate[] a(OfContainer ofContainer) throws CMPException {
        if (!ofContainer.dataPresent) {
            return null;
        }
        int n = ofContainer.getContainerCount();
        Certificate[] certificateArray = new Certificate[n];
        for (int i = 0; i < n; ++i) {
            try {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                certificateArray[i] = new X509Certificate(aSN1Container.data, aSN1Container.dataOffset, 0);
                continue;
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CMPException("CMPResponseCommon.decodeExtraCerts: unable to get an element container of OfContainer(" + aSN_Exception.getMessage() + ").");
            }
            catch (CertificateException certificateException) {
                throw new CMPException("CMPResponseCommon.decodeExtraCerts: unable to decode a certificate(" + certificateException.getMessage() + ").");
            }
        }
        return certificateArray;
    }

    private static boolean a(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }
}

